/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;

public class Namespace
extends SimpleNodeConstructor {
    private Expression name;

    public Namespace(Expression expression) {
        this.name = expression;
    }

    public String getInstructionName() {
        return "namespace";
    }

    public ItemType getItemType() {
        return NodeKindTest.NAMESPACE;
    }

    public int getCardinality() {
        return 512;
    }

    public void promoteInst(PromotionOffer promotionOffer) {
    }

    public void typeCheck(StaticContext staticContext) {
    }

    public void getXPathExpressions(List list) {
        list.add(this.name);
        super.getXPathExpressions(list);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!string.equals("") && !XMLChar.isValidNCName(string)) {
            Instruction.recoverableError(this, "Namespace prefix is invalid: " + string, controller);
            return null;
        }
        String string2 = this.expandChildren(xPathContext).toString();
        if (string2.equals("")) {
            Instruction.recoverableError(this, "Namespace URI is an empty string", controller);
            return null;
        }
        int n = controller.getNamePool().allocateNamespaceCode(string, string2);
        controller.getReceiver().namespace(n, 32);
        return null;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "namespace");
        this.name.display(n + 1, namePool);
        super.display(n + 1, namePool);
    }
}

