#!/usr/bin/env bash
## Test for issue1290 - darcs diff --index
##
## Public domain - 2010 Eric Kow

. lib                           # Load some portability helpers.
rm -rf R                        # Another script may have left a mess.
darcs init      --repo R        # Create our test repos.

cd R
 echo '1' > f
 darcs record -lam 'one'
 echo '2' > f
 darcs record -lam 'two'
 echo '3' > f
 darcs record -lam 'three'
 echo '4' > f
 darcs record -lam 'four'
 darcs diff --from-patch one --to-patch two > d1
 darcs diff --index=3-4 > d2 # the numbers go backwards
 diff -q d1 d2
cd ..
