#!/usr/bin/env bash
## Test for issue1465 - ortryrunning should try RHS if AND ONLY IF the
## LHS actually failed wasn't found or wasn't executable.
##
## Copyright (C) 2009  Trent W. Buck
##
## Permission is hereby granted, free of charge, to any person
## obtaining a copy of this software and associated documentation
## files (the "Software"), to deal in the Software without
## restriction, including without limitation the rights to use, copy,
## modify, merge, publish, distribute, sublicense, and/or sell copies
## of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
##
## The above copyright notice and this permission notice shall be
## included in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
## EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
## MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
## NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
## BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
## ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.

. ../tests/lib                  # Load some portability helpers.
rm -rf R                        # Another script may have left a mess.
darcs init      --repo R        # Create our test repo.
mkdir R/d                       # Change the working tree.

# Set the editor to a program that just fails (VISUAL), make Darcs use
# it (--edit), and then make sure when it brokenly launches a fallback
# editor, that editor will exit because stdin isn't a tty (/dev/null).
not env -u TERM VISUAL=false </dev/null &>R/log \
darcs record    --repo R -lam 'Initial commit.' --edit

# If Darcs did the right thing, the output won't make any mention of
# the fallback editors.
not egrep -i 'not found|vi|emacs|nano|edit' R/log

rm -rf R/                       # Clean up after ourselves.
