#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

export DARCS_EMAIL='hello world'
rm -rf tempA
mkdir tempA
cd tempA
$DARCS initialize
echo hello world > foo
$DARCS add foo
$DARCS record -a -m hellofoo

echo goodbye world >> foo
$DARCS record -a -m goodbyefoo

$DARCS replace world bar foo
echo Hi there foo > bar
$DARCS add bar
$DARCS record -a -m addbar

$DARCS mv bar baz
$DARCS replace bar baz foo
$DARCS record -a -m bar2baz

echo Do not love the baz, or anything in the baz. >> foo
$DARCS record -a -m nolove

$DARCS mv baz world
$DARCS replace baz world foo
$DARCS record -a -m baz2world

$DARCS whatsnew | grep 'No changes'

grep 'love the world' foo

echo y | $DARCS obliterate -p baz2world

$DARCS whatsnew | grep 'No changes'

grep 'love the baz' foo

echo y | $DARCS obliterate -p bar2baz

grep 'love the bar' foo

echo y | $DARCS obliterate -p nolove

! grep 'love' foo

cd ..
rm -rf tempA

