#ifndef __HPP_VIRUSSCANNER
#define __HPP_VIRUSSCANNER

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Written by James A. Pattie (james@pcxperience.com) Xperience, Inc. (www.pcxperience.com)
// and some additions by mad@madness.at

#include "autoconf/platform.h"
#include <stdexcept>
#include <fstream>
#include <cerrno>
#include <libesmtp.h>
#include <syslog.h>
#include <unistd.h>
#include <utime.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "OptionContainer.hpp"
#include "Socket.hpp"
#include "String.hpp"
#include "VirusEngine.hpp"
#include "TrickleHandler.hpp"
#include "HTTPHeader.hpp"

#ifdef __GCCVER3
using namespace std;
#endif

// XXX: add other engines here
//
#ifdef __CLAMAV
#include "ClamAV.hpp"
#endif

#ifdef __CLAMDSCAN
#include "ClamDScan.hpp"
#endif

#ifdef __KAV
#include "KAV.hpp"
#endif

#ifdef __KAV5
#include "KAVScan.hpp"
#endif

#ifdef __ICAP
#include "ICAPScan.hpp"
#endif

#ifdef __TROPHIE
#include "TrophieScan.hpp"
#endif

#ifdef __SOPHIE
#include "SophieScan.hpp"
#endif

#define SIZE 32768              // 32k
#define MAX_BUF 262144          // 256k

#define TEMPDELAY 86400         // Delay of 1 day for automatic removal of temp files

#ifdef __WITH_GRP_ACCESS_TEMP
#define TEMPDIR_MASK (S_IRWXU|S_IXGRP)
#else
#define TEMPDIR_MASK (S_IRWXU)
#endif

class VirusScanner
{
private:
  int timeout;
  int trickle_pos;
  int file_length;
  int infected;

  char *tempFileName;
  int tempFileFD;
  int tempFileTrickle;

  VirusEngine *avEngine;

  bool scanIt;

  bool out (Socket * sock, char *block, int size) throw ();
  void sendmail (std::string username, String url, std::string clientip);

public:
    VirusScanner ();
   ~VirusScanner ();

  int loadScanner ();
  int reloadScanner ();
  int unloadScanner ();

  void resetScanner ();

  void handleScanning (Socket * proxysock, Socket * peerconn, String url, int docsize, int contentLength,
                       std::string username, std::string clientip, int filtergroup, std::string location, int reporting_level, HTTPHeader * _docheader, bool dlmgr, int scantype);

  void createTempFile (void) throw (exception);
  void createTempFile (const char *_buffer, const int _len);

  void sendFile (Socket * peerconn, HTTPHeader * _docheader, char *tempFileName);
  void scan (Socket * proxysock, Socket * peerconn, String url, std::string username, std::string clientip, int filtergroup, std::string location, int reporting_level, HTTPHeader * _docheader, bool dlmgr, int scantype);

  bool isInfected () const
  {
    return infected == VirusEngine::AV_VIRUS ? true : false;
  }
  bool scanFailed () const
  {
    return infected == VirusEngine::AV_FAIL ? true : false;
  }

  void setTimeout (int t);

  void cleanUp (void);

  int getFileLength () const
  {
    return file_length;
  }
  const char *getFileName () const
  {
    return tempFileName;
  }
  const char *getVirusName () const
  {
    return avEngine->getVirusName ();
  }
};

#endif
