/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#include "intrusive_ptr.hpp"

#ifndef dammit_visitor_hpp_
#define dammit_visitor_hpp_ 1

namespace dammit {

class node;

class parallel_node;

class project_node;
class configuration_node;

class input_node;
class temporary_node;
class output_node;

class tool_node;
class environment_node;

class action_node;

class visitor
{
public:
	virtual ~visitor(void) throw() { }

	virtual intrusive_ptr<node> visit(parallel_node &) = 0;

	virtual intrusive_ptr<node> visit(project_node &) = 0;
	virtual intrusive_ptr<node> visit(configuration_node &) = 0;

	virtual intrusive_ptr<node> visit(input_node &) = 0;
	virtual intrusive_ptr<node> visit(temporary_node &) = 0;
	virtual intrusive_ptr<node> visit(output_node &) = 0;

	virtual intrusive_ptr<node> visit(tool_node &) = 0;
	virtual intrusive_ptr<node> visit(environment_node &) = 0;

	virtual intrusive_ptr<node> visit(action_node &) = 0;
};

}

#endif
