/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_cache_hpp_
#define dammit_cache_hpp_ 1

#include <dammit/path.hpp>

#include <map>

namespace dammit {

class cache
{
public:
	cache(path const &base_path);
	~cache(void) throw();

	typedef std::multimap<path, path> dependency_map;
	typedef dependency_map::iterator dependency_iterator;
	typedef dependency_map::const_iterator dependency_const_iterator;
	
	dependency_map dependencies;

private:
	path const base_path;
};

}

#endif
