#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

# Complex layouts

. ./test_style.sh

ctioga -N --xpdf --math --grid column=2 'sin(x)' \
    --next 'sin(x)' --next 'sin(x)' --next 'sin(x)'

ctioga -N --xpdf --math -t "A nice grid" \
    --grid column=2 'sin(x)' \
    --next 'sin(x)' --next 'sin(x)' --next 'sin(x)' \
    --next 'sin(x)' --next 'sin(x)' --next 'sin(x)' 

# And few nice versions using the automatic --next:
ctioga --xpdf --math --grid column=2 'sin(x)' \
    --auto-next 'cos(x + 1##4)' 'tan(x)'

ctioga --xpdf --math --grid column=2 'sin(x)' \
    --auto-next-expanded 'cos(x + 1##4)' 'tan(x)'

# Columns now:

ctioga -N --xpdf --math -t "A column plot" \
    --col 'sin(x)' --next 'sin(x+1)' --next 'sin(x+2)' 

