/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <wx/wx.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/progdlg.h> //progress dialog
#include <wx/dir.h>
#include <wx/menuitem.h>
#include <wx/regex.h>


#include <string>
#include <assert.h>
#include <vector>

#include <iostream>

#include "../../config.h"

#include "../pkcs7.hh" 
#include "../pkcs8.hh"
#include "../pkcs10.hh"
#include "../pkcs12.hh"
#include "../Certificate.hh"
#include "../AddressBook.hh"
#include "../Crl.hh"
#include "../Utils.hh"
#include "../SoftKeyStore.hh"
#include "../P11KeyStore.hh"

#include "MainWindow.hh"
#include "Common.hh"
#include "EncryptSettingsDlg.hh" //for
#include "RecipientsDlg.hh" // encrypting
#include "SelfEncryptSettingsDlg.hh"
#include "DecryptSettingsDlg.hh"
#include "DecryptProgressDlg.hh" 
#include "SignSettingsDlg.hh"
#include "VerifySettingsDlg.hh"
#include "VerifyStatusDlg.hh"
#include "VerifyCertDlg.hh"
#include "AddressBookFrame.hh"
#include "PropertiesFrame.hh"
#include "PasswordDlg.hh"
#include "wxPasswordManager.hh"
#include "KeyChoiceDlg.hh"
#include "OverwriteDlg.hh"
#include "AboutDlg.hh"

// add-ins related to the use of libP11cryptonit
#include "Erreur.hh"


//#include "pics/resources.h" 
//icons  : pb avec les xpm non static dans gcc 2.96 et 3.2
#ifndef __WXMSW__ // en attendant
//#include "pics/users.xpm"
#include "pics/config.xpm"
#include "pics/file_locked.xpm"
#include "pics/folder_locked.xpm"
#include "pics/addressbook.xpm"
#include "pics/encrypted.xpm"
#include "pics/decrypted.xpm"
#include "pics/exit.xpm"
#include "pics/sign.xpm"
#include "pics/verify.xpm"
#include "pics/exec.xpm"
#include "pics/about.xpm"
#include "pics/folder.xpm"
#include "pics/stop.xpm"
#endif

BEGIN_EVENT_TABLE(MainWindow, wxFrame)
#ifdef __WXMAC__
    EVT_MENU (wxID_EXIT, MainWindow::exit)
    EVT_MENU (wxID_ABOUT, MainWindow::about)
    EVT_MENU (wxID_HELP_CONTENTS, MainWindow::about)
#endif
    EVT_TOOL (MW_FILE_BTN_ID, MainWindow::onFile)
    EVT_TOOL (MW_ENCRYPT_BTN_ID, MainWindow::onEncrypt)
    EVT_TOOL (MW_DECRYPT_BTN_ID, MainWindow::onDecrypt)
    EVT_TOOL (MW_SIGN_BTN_ID, MainWindow::onSign)
    EVT_TOOL (MW_VERIFY_BTN_ID, MainWindow::onVerify)
  EVT_TOOL (MW_SELF_BTN_ID, MainWindow::onSelf)
  EVT_TOOL (MW_EMPTY_BTN_ID, MainWindow::onEmpty)
    EVT_TOOL (MW_ADDRESSBOOK_BTN_ID, MainWindow::addressBook)
    EVT_TOOL (MW_CONFIG_BTN_ID, MainWindow::config)
    EVT_TOOL (MW_ABOUT_BTN_ID, MainWindow::about)
    EVT_TOOL (MW_EXIT_BTN_ID, MainWindow::exit)
    EVT_CLOSE(MainWindow::exit2)
END_EVENT_TABLE();


BEGIN_EVENT_TABLE(SelectedFilesList, wxListCtrl)
    EVT_LIST_KEY_DOWN(MW_DROP_LIST_ID, SelectedFilesList::OnListKeyDown)
END_EVENT_TABLE();

using namespace Cryptonit;

MainWindow::MainWindow(wxWindow *parent, wxWindowID id,
		       const wxString &title, Cryptonit::User* usr,
		       const wxPoint &position, const wxSize &size,
		       long style ) :
    wxFrame ( parent, id, title, position, size, style )
{

    user = usr;
    p = parent;
#ifdef __WXMSW__
    SetIcon(wxICON(aaa));
#endif
    createToolBar();
    createStatusBar();
    createDropList();
    initKeyStores();
    this->SetSize(mainToolBar->GetSize().GetWidth()+10,wxDefaultCoord);
    Center();

    CryptonitGui& app = wxGetApp();
    dropList->addFiles( app.getFiles() );
    
    /* Autofill drop list with files present in the default folder */

    wxArrayString	*choosenFiles = new wxArrayString();
    wxArrayString	*files = new wxArrayString();
    std::string		userDefaultFolder = user->getInfo("DefaultFolder");
    wxString		userDefaultFolderStr(std2wx(userDefaultFolder));
    std::string		userDefaultFolderAutofill = user->getInfo("DefaultFolderAutofill");
    wxDir		dir(wxGetCwd());
    size_t		nFiles;
    
#ifdef __WXMSW__
    wxRegEx		regExp(_T("/"));
    const wxString	replacement(_T("\\\\"), 2);
    regExp.ReplaceAll(&userDefaultFolderStr, replacement); 
#endif

    if (userDefaultFolder != "") {
      if ( (userDefaultFolderAutofill == "1") 
	   && dir.Exists(userDefaultFolderStr.c_str()) ) {
					dir.GetAllFiles(userDefaultFolderStr.c_str(), choosenFiles, wxString(_T('*'), 1), wxDIR_FILES);
	nFiles = choosenFiles->GetCount();
	for ( size_t n = 0; n < nFiles; n++ )
			if (!(strstr((char *)(*choosenFiles)[n].c_str(), ".pkcs7")))
	    files->Add((*choosenFiles)[n]);
	dropList->addFiles(*files);
	delete choosenFiles;
	delete files;
      }
    }
    else {
      wxString *currentPath = new wxString(wxGetCwd());     
#ifdef __WXMSW__
      wxRegEx	regExp(_T("\\\\"));
      const wxString	replacement(_T("/"));
      regExp.ReplaceAll(currentPath, replacement); 
#endif
      user->setInfo("DefaultFolder", wx2std(*currentPath));
    }

    if (user->getInfo("Signing Profile") == "") {
      user->setInfo("Signing Profile Attached", "1");
      user->setInfo("Signing Profile Detached", "0");
      wxString *currentPath = new wxString(wxGetCwd());     
#ifdef __WXMSW__
      wxRegEx		regExp(_T("\\\\"));
      const wxString	replacement(_T("/"));
      regExp.ReplaceAll(currentPath, replacement); 
#endif
      user->setInfo("Signing Profile Path", wx2std(*currentPath));
      user->setInfo("Signing Profile LeaveCB", "1");
      user->setInfo("Signing Profile DeleteCB", "0");
      user->setInfo("Signing Profile", "1");
   }
}

MainWindow::~MainWindow() {

}

void MainWindow::createToolBar()
{
    wxBitmap toolBarBitmaps[12];
    toolBarBitmaps[0] = wxBITMAP(file_locked);
    toolBarBitmaps[1] = wxBITMAP(folder_locked);
    toolBarBitmaps[2] = wxBITMAP(addressbook);
    toolBarBitmaps[3] = wxBITMAP(config);
    toolBarBitmaps[4] = wxBITMAP(encrypted);
    toolBarBitmaps[5] = wxBITMAP(decrypted);
    toolBarBitmaps[6] = wxBITMAP(exit);
    toolBarBitmaps[7] = wxBITMAP(sign);
    toolBarBitmaps[8] = wxBITMAP(verify);
    toolBarBitmaps[9] = wxBITMAP(exec);
    toolBarBitmaps[10] = wxBITMAP(about);
    toolBarBitmaps[11] = wxBITMAP(stop);

#ifdef __WXMSW__
    mainToolBar = CreateToolBar( wxTB_FLAT |wxTB_TEXT | 
				 wxTB_HORIZONTAL| wxNO_BORDER, 500);
#else
    mainToolBar = new wxToolBar(this, MW_TOOLBAR_ID, wxDefaultPosition, 
				wxDefaultSize, wxTB_FLAT |wxTB_TEXT |
				wxTB_HORIZONTAL | wxNO_BORDER);
#endif

    mainToolBar->AddTool(MW_FILE_BTN_ID, _("File"),
			 toolBarBitmaps[0],_("Add files in the list"));
    mainToolBar->AddTool(MW_ADDRESSBOOK_BTN_ID, _("Contacts") ,
			 toolBarBitmaps[2],  _("Address Book"));
    mainToolBar->AddTool(MW_CONFIG_BTN_ID , _("Settings"),
			 toolBarBitmaps[3],  _("Display configuration dialog"));
    mainToolBar->AddSeparator();
    mainToolBar->AddTool(MW_ENCRYPT_BTN_ID,_("Encrypt"),
			 toolBarBitmaps[4],_("Encrypt files or directories"));
    mainToolBar->AddTool(MW_DECRYPT_BTN_ID,_("Decrypt"),
			 toolBarBitmaps[5],_("Decrypt files or directories") );
    mainToolBar->AddTool(MW_SIGN_BTN_ID,_("Sign"),
			 toolBarBitmaps[7],_("Sign files or directories") );
    mainToolBar->AddTool(MW_VERIFY_BTN_ID,_("Verify"),
			 toolBarBitmaps[8],_("Verify signed files validity") );
    mainToolBar->AddSeparator();
    mainToolBar->AddTool(MW_SELF_BTN_ID,_("Self"),
			 toolBarBitmaps[9],_("Generate Self Decryptable files") );
    mainToolBar->AddTool(MW_EMPTY_BTN_ID,_("Empty list"),
			 toolBarBitmaps[11],_("Empty list of files") );
    mainToolBar->AddSeparator();
    mainToolBar->AddTool(MW_ABOUT_BTN_ID,_("About"),
			 toolBarBitmaps[10],_("About Cryptonit") );
    mainToolBar->AddSeparator();
    mainToolBar->AddTool(MW_EXIT_BTN_ID,_("Quit"),
			 toolBarBitmaps[6],_("Exit Cryptonit") );

#ifndef __WXMSW__
    SetToolBar(mainToolBar);
#endif
    mainToolBar->SetToolBitmapSize(wxSize(32, 32));	
    mainToolBar->Realize();
    mainToolBar->SetRows(1);

#ifndef USE_ENCRYPT_SELF
    mainToolBar->EnableTool(MW_SELF_BTN_ID, false);
#endif

    enableButtons(false);

#ifdef __WXMAC__
       helpMenu = new wxMenu;
       helpMenu->Append(wxID_HELP_CONTENTS, _("&About"), _("About"));
       helpMenu->Append(wxID_ABOUT, _("&About"), _( "About Cryptonit"));
       menuBar = new wxMenuBar;
       /* Very dirty hack. Add an empty menu to enable Quit...*/
       wxMenu *bozomenu = new wxMenu;
       bozomenu->Append(wxID_EXIT, _("&Exit"), _( "Quit"));
       menuBar->Append(helpMenu,_("&Help"));
       menuBar->Append(bozomenu,_T(""));
       SetMenuBar(menuBar);
       SetIcon(wxICON(file_locked));
#endif     

}


void MainWindow::createStatusBar(){
    CreateStatusBar(1);
    SetStatusText(_("Welcome to Cryptonit"),0);
}

void MainWindow::createDropList(){
    dropList = new SelectedFilesList(this,MW_DROP_LIST_ID, wxLC_REPORT | wxLC_VRULES );
    dropList->InsertColumn(0, _("Path"),wxLIST_FORMAT_LEFT,wxLIST_AUTOSIZE_USEHEADER );
    dropList->InsertColumn(1, _("Size"),wxLIST_FORMAT_LEFT,wxLIST_AUTOSIZE_USEHEADER );
    dropList->InsertColumn(2, _("Type"),wxLIST_FORMAT_LEFT,wxLIST_AUTOSIZE_USEHEADER );
    SetDropTarget(dropList);
}

void MainWindow::onFile(wxCommandEvent& WXUNUSED(event)){
  wxArrayString *choosenFiles = new wxArrayString();
  std::string  	userDefaultFolder = user->getInfo("DefaultFolder");
   
  wxFileDialog openFileDialog
			( this, _("Select the files to ..."),
				std2wx(userDefaultFolder), _T(""), _T("All (*.*)|*"), wxMULTIPLE);
  if (openFileDialog.ShowModal() == wxID_OK) {
    openFileDialog.GetPaths(*choosenFiles);
    dropList->addFiles(*choosenFiles);
  }
    
  return;   
}

void MainWindow::onEncrypt(wxCommandEvent& WXUNUSED(event)) {
    if( dropList->GetItemCount() == 0 ) {
	wxMessageDialog errorMsg(this, _("There is no files to encrypt."),
				 _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	return;
    }

    EncryptSettingsDlg cd(this,-1,_("Encrypting: settings"));
    if( cd.showModal() == wxID_OK ){
	bool remove = cd.getDeleteFile();
	bool leave = cd.getLeaveFile();
	wxString path =  cd.getPath();

#ifdef DEBUG
	std::cerr << "Deleting files ? " << remove << std::endl;
	std::cerr << "Path: " << path << std::endl;
#endif
    
	RecipientsDlg rd(this, -1, user, _("Encrypting: choose the recipients"));
	if( rd.showModal() == wxID_OK){
	    std::vector<wxString>* recipientList;
	    if( (recipientList = rd.getRecipientList()) == NULL ) {
		wxMessageDialog errorMsg (this,  _("Operation aborted, because "
						   "there is no recipient selected."),
					  _("Error"), wxOK | wxICON_ERROR);
		errorMsg.ShowModal();
		return;
	    }

	    std::vector<wxString> certificatesFiles;
	    std::vector<wxString>::iterator itr;
	    for( itr = recipientList->begin(); itr != recipientList->end(); itr++ ) {
		if( user->addressBook->getContactInfo
		    ( wx2std(*itr), "userCertificate" ) == "" ) {
		  wxString msg = wxString::Format(_("There is no certificate associated with contact: '%s'.\n"),wxString(*itr).c_str());
		  msg+=_("Operation aborted");
		    wxMessageDialog errorMsg(this, msg,
					     _("Error"), wxOK | wxICON_ERROR);
		    errorMsg.ShowModal();
		}
		
		wxFileName certFile( std2wx(user->addressBook->getContactInfo
																( wx2std(*itr), "userCertificate")));
		certFile=wxMyPrepend(certFile,std2wx(user->getCertificatesDir()));
		certificatesFiles.push_back( certFile.GetFullPath()  );
	    }
	    
	    delete recipientList;
	    
	    if(certificatesFiles.size() != 0){
#ifdef DEBUG
		std::cerr << "Certificate Checking" << std::endl;
#endif
		VerifyCertDlg vcd(this, -1 ,_("Certificate checking"),user );
		vcd.verify(certificatesFiles);
		if(vcd.showModal(wxSize(540,400), _("Continue")) == wxID_OK)
		    encryptFiles( remove, leave, path, certificatesFiles );
	    } else {
		wxMessageDialog errorMsg(this, _("No recipient selected"),
					 _("Error"), wxOK | wxICON_ERROR);
		errorMsg.ShowModal();
	  
	    }
	}
    }
}


void MainWindow::onDecrypt(wxCommandEvent& WXUNUSED(event)) {
    if( dropList->GetItemCount() == 0 ) {
	wxMessageDialog errorMsg(this, _("There is no files to decrypt."),
				 _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	return;
    }


  DecryptSettingsDlg dd(this,-1,_("Decrypting: settings"));
  if( dd.showModal() == wxID_OK ){

#ifdef DEBUG
      std::cerr << "Deleting files ? " << dd.getDeleteFile() << std::endl;
      std::cout << "Path: " << dd.getPath() << std::endl;
#endif
	decryptFiles( dd.getDeleteFile(), dd.getLeaveFile(), dd.getPath());
    }
}



void MainWindow::onSign(wxCommandEvent& WXUNUSED(event)){
    if( dropList->GetItemCount() == 0 ) {
	wxMessageDialog errorMsg(this, _("There is no files to sign."),
				 _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	return;
    }

    SignSettingsDlg sd(this, -1, user, _("Signing: settings"));
    if( sd.showModal() == wxID_OK ){
   
	std::vector<wxString> certificatesFiles;
	if(sd.getEncrypted() && sd.getAttached()) {
	  RecipientsDlg rd(this, -1, user,
			   _("Encrypting: choose the recipients"));
	  if( rd.showModal() == wxID_OK){
#ifdef DEBUG
	    std::cerr << "--> Encrypting" << std::endl;
#endif
	      
	    std::vector<wxString>* recipientList;
	    if( (recipientList = rd.getRecipientList()) == NULL ) {
	      wxMessageDialog errorMsg
		(this, _("Operation aborted, because there is no recipient "
			 "selected."), _("Error"), wxOK | wxICON_ERROR);
	      errorMsg.ShowModal();
	      return;
	    }
	    
	    std::vector<wxString>::iterator itr;
		for( itr = recipientList->begin(); itr != recipientList->end(); itr++ ) {
		    if( user->addressBook->getContactInfo
						(wx2std(*itr), "userCertificate" ) == "") {
		      wxString msg = _("There is no certificate associated with this "
				       "contact: ") + wxString(*itr) + _("\nOperation aborted");
		      wxMessageDialog errorMsg(this, msg,
					       _("Error"), wxOK | wxICON_ERROR);
		      errorMsg.ShowModal();
		    }
		    
		    wxFileName certificateFilename( std2wx(user->getCertificatesDir()) );

		    wxString file = certificateFilename.GetFullPath();
		    // pour les tests, doublons dans le path, le path du home est
		    // deja present dans le path du certif
		    file+= certificateFilename.GetPathSeparator(); 
		    file+= std2wx(user->addressBook->getContactInfo
											(wx2std(*itr), "userCertificate" ));
#ifdef DEBUG
		    std::cerr << "userCertificate: " << file << std::endl;
#endif		    
		    
		    certificatesFiles.push_back( file.c_str() );
		}
		delete recipientList;
	    }
	    signFiles(sd.getDetached(),true /*sd.getEncrypted()*/,
		      sd.getLeave(), sd.getDelete(),sd.getPath(),
		      certificatesFiles);
	} else {
	  signFiles(sd.getDetached(),false /*sd.getEncrypted()*/,
		    sd.getLeave(), (sd.getDelete() && sd.getAttached()), sd.getPath(),
		    certificatesFiles /*will be ignored */);
	}
    }
}

#ifdef USE_ENCRYPT_SELF
#include "../self/encryptSelf.h"
#endif

void MainWindow::onSelf(wxCommandEvent& WXUNUSED(event))
{
#ifdef USE_ENCRYPT_SELF
    if( dropList->GetItemCount() == 0 ) {
	wxMessageBox( _("There is no files to encrypt."), _("Error"), 
		      wxOK | wxICON_ERROR, this );
	return;
    }

    SelfEncryptSettingsDlg cd(this,-1,_("Self-Decrypting Archive: settings"));
    if( cd.showModal() == wxID_OK ) {
	bool remove = cd.getDeleteFile();
	bool leave = cd.getLeaveFile();
	std::list<unsigned int>  targetPlatformsList = cd.getPlatforms();

	if( targetPlatformsList.size() == 0 ) {
	    wxMessageBox(_("You must choose at least one platform."),
			 _("Error"), wxOK | wxICON_ERROR, this);
	    return;
	}

	wxString path = cd.getPath();

	PasswordDlg pd( this, -1, _("Enter the password"),
			_("Enter the password for encryption") );
	PasswordDlg againPw( this, -1, _("Enter the password"),
			     _("Retype your passphrase: ") );
	pd.addButtons();
	againPw.addButtons();

	if( pd.ShowModal() == wxID_OK ) {
	    wxString password = pd.getPassword();

	    /* Recheck the password */
	    if( againPw.ShowModal() == wxID_OK 
		&& againPw.getPassword() == password ) {

		for( std::list<unsigned int>::const_iterator iter = targetPlatformsList.begin();
		     iter != targetPlatformsList.end(); ++iter ) {
		    /* for each target platform selected */
		    wxProgressDialog pg(_("Encryption in progress... "), _("Please wait"),
					dropList->GetItemCount(), this, wxPD_CAN_ABORT |
					wxPD_REMAINING_TIME | wxPD_ELAPSED_TIME );
		    int max = dropList->GetItemCount();
		    int value = 0;
		    long item = -1;
		    wxString file;
#ifdef DEBUG
		    std::cerr << "valeur de *iter: " << *iter << std::endl;
#endif		    
		    switch (*iter) {

		    case WINDOWS_NT:
			while( (item = dropList->GetNextItem(item)) != -1 ) {
			    if (leave) {
				//put encrypted files in the same directory than original files
				file = dropList->GetItemText(item);
			    } else { //put them in "path"
				wxFileName filename(dropList->GetItemText(item));
				filename = filename.GetFullName();
				filename=wxMyPrepend(filename,path);
				file = filename.GetFullPath();
			    }
#ifdef DEBUG			    
			    std::cerr << "Encrypt self: " << dropList->GetItemText(item) << std::endl;
#endif
			    file += _T(".exe");
#ifdef DEBUG
			    std::cerr <<  "encrypting to target file: " << file << std::endl;
#endif			    
			    if(encrypt_self(wx2std(dropList->GetItemText(item)).c_str(), wx2std(file).c_str(),
					    wx2std(password).c_str(), STUB_WIN32) == 0) {
				pg.Update(value++,dropList->GetItemText(item));
				if(remove)
				  wxRemoveFile(dropList->GetItemText(item).c_str());
			    } else {
				pg.Update(value++,file + _(": ") + _("Error"));
			    }
			}
			break;

		    case GNU_LINUX:
			while( (item = dropList->GetNextItem(item)) != -1 ) {
			    if (leave) {
				//put encrypted files in the same directory than original files
				file = dropList->GetItemText(item);
			    } else { //put them in "path"
				wxFileName filename(dropList->GetItemText(item));
				filename = filename.GetFullName();
				filename=wxMyPrepend(filename,path);
				file = filename.GetFullPath();
			    }
#ifdef DEBUG			    
			    std::cerr << "Encrypt self: " << dropList->GetItemText(item) << std::endl;
#endif			    

			    file += _T(".self");
#ifdef DEBUG			    
			    std::cerr <<  "encrypting to target file: " << file << std::endl;
#endif			    
			    if(encrypt_self(wx2std(dropList->GetItemText(item)).c_str(), wx2std(file).c_str(),
					    wx2std(password).c_str(), STUB_POSIX) == 0) {
				/* chmod a+x ? */
				pg.Update(value++,dropList->GetItemText(item));
				if(remove) {
				  wxRemoveFile(dropList->GetItemText(item).c_str());
				}
			    } else {
				pg.Update(value++, file + _(": ") + _("Error"));
			    }
			}
			break;
		    }
		    pg.Update(max);
		}
		dropList->DeleteAllItems();
		enableButtons(false);
	    } else {
		wxMessageBox(_("Passphrase is incorrect"), _("Error"),
			     wxOK | wxICON_ERROR, this);
	    }
	}
    }
#else
    wxMessageBox(_("This feature does not exist in this version."), 
		 _("Error"), wxOK | wxICON_ERROR, this);
#endif
}


void MainWindow::onEmpty(wxCommandEvent& WXUNUSED(event)) {
  //item = dropList->GetNextItem(item)
  dropList->DeleteAllItems();
}

/*void MainWindow::onUsers(wxCommandEvent& WXUNUSED(event))
{
    wxMenu userMenu;
    wxMenu *pkcs12Menu = new wxMenu();
    pkcs12Menu->Append(MW_USER_MENU_PKCS10 ,
		       _("Create a certificate request"));	    
    pkcs12Menu->Append(MW_USER_MENU_ADD_CERT ,
		       _("Add generated certificate"));	    
  
  
    wxMenuItem *P10Item = new wxMenuItem
	(&userMenu, 0 ,_("Certificate request"), "" ,
	 wxITEM_NORMAL, pkcs12Menu );
  
    userMenu.Append(MW_USER_MENU_PKCS12 , _("Export personnal data") );
    userMenu.Append(P10Item);
    wxWindow::PopupMenu(&userMenu,0,0);
  
}
*/

void MainWindow::onVerify(wxCommandEvent& WXUNUSED(event))
{
  
    if( dropList->GetItemCount() == 0 ) {
	wxMessageDialog errorMsg(this, _("There is no file to verify."),
				 _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	return;
    }
  
    VerifySettingsDlg vsd(this,-1,_("Verify signatures: settings"));
    if(vsd.showModal()== wxID_OK){
// 	RecipientsDlg rd(this, -1, user,
// 			 _("Choose the signer of these files"),true);
// 	if( rd.showModal() == wxID_OK){
// 	    wxString signer = rd.getRecipient();
// 	    if( signer == "" ) {
// 		wxMessageDialog errorMsg
// 		    (this, _("Operation aborted, because there is no signer "
// 			     "selected."), _("Error"), wxOK | wxICON_ERROR);
// 		errorMsg.ShowModal();
// 		return;
// 	    }
	    
// 	    if( user->addressBook->getContactInfo
// 		( std::string(signer.c_str()), "userCertificate" ) == "" ) {
// 		wxString msg = _("There is no certificate associated with this "
// 				 "contact: ") + signer + _("\nOperation aborted");
// 		wxMessageDialog errorMsg(this, msg, _("Error"), 
// 					 wxOK | wxICON_ERROR);
// 		errorMsg.ShowModal();
// 	    }
	    
// 	    wxFileName certificateFilename( user->getCertificatesDir().c_str() );
// 	    wxString file = certificateFilename.GetFullPath();
// 	    // pour les tests, doublons dans le path, le path du 
// 	    // home est deja present dans le path du certif
// 	    file+= certificateFilename.GetPathSeparator(); 
// 	    file+= user->addressBook->getContactInfo( std::string(signer.c_str()), "userCertificate" ).c_str(); 
	    
// 	    std::cerr << "userCertificate: " << file << std::endl;
	    
	verifyFiles(vsd.getLeave(), vsd.getDelete(), vsd.getPath(), vsd.getExtract() );//, file);
    //}
    }
}

void MainWindow::addressBook(wxCommandEvent& WXUNUSED(event))
{
    AddressBookFrame *ab = new  AddressBookFrame(this, -1 ,_("Address Book"), user, &keyStores);
    ab->Show();
    enableAddressBookBtn( false );
}

void MainWindow::config(wxCommandEvent& WXUNUSED(event))
{
    PropertiesFrame *pf = new  PropertiesFrame(this, -1 ,_("Properties"), user, &keyStores);
    pf->Show();
}

void MainWindow::exit2(wxCloseEvent& WXUNUSED(event))
{
		wxCommandEvent e;
		this->exit(e);
}

void MainWindow::exit(wxCommandEvent& WXUNUSED(event)){

    std::vector< KeyStore *>::iterator i;
    std::vector< std::string > fields;
    for( i = keyStores.begin() ; i != keyStores.end() ; i++ ){
	if( (*i)->getType() == PKCS11_KEYSTORE ){
	    fields.push_back( ((P11KeyStore*) *i)->getLib() );
	}
	delete *i;
    }
    user->setInfos( "PKCS11_KEYSTORE" , fields );

    if( ! (user->addressBook->save()) ){
	wxString msg = _("An error occured while saving address book: ");
	wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
    }

    if( ! (user->authorities->save()) ){
	wxString msg = _("An error occured while saving the authorities data base: ");
	wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
    }

    if( ! (user->saveToFile()) ){
	wxString msg = _("An error occured while saving user's preferences: ");
	wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
    }
	
    delete user;
    
    keyStores.clear();
    std::exit(-1);
    Close();
    delete p; //delete login frame
}
    





void MainWindow::about(wxCommandEvent& WXUNUSED(event)){
    AboutDlg aboutCryptonit( this, -1 );
    aboutCryptonit.showModal(wxDefaultSize, _("OK"), false);
}


    
int MainWindow::decryptFiles(bool remove, bool leave, wxString path){
    
    wxProgressDialog pg(_("Decryption in progress ..."),_("Please wait"),
			dropList->GetItemCount(), this,wxPD_CAN_ABORT |
			wxPD_REMAINING_TIME | wxPD_ELAPSED_TIME ); 
    int max = dropList->GetItemCount();
    int value = 0;
	
    long item = -1;
	

    Key *pkey;

    bool alwaysOverwrite = false;


    for ( ; ; )
	{
	    pkey = NULL;
	    Certificate *matchingCertificate = NULL;
		
	    item = dropList->GetNextItem(item);
	    if( item == -1)
		break;
	    pkcs7 p7; 

	    int p7status = p7.read(wx2std(dropList->GetItemText(item)).c_str());

	    if( p7status != SUCCESS  ||  p7.isSigned() || p7.isDetached() ){
		
		pg.Update(value++,dropList->GetItemText(item));
		wxString msg = wxString::Format(_("%s is not encrypted!"),dropList->GetItemText(item).c_str());
		wxMessageBox( msg, _("Error"),  wxICON_ERROR, this);
		
	    } else {
		
		std::vector<PKCS7_RECIP_INFO> rinfo = p7.getRecipientInfos();
		std::vector<PKCS7_RECIP_INFO>::iterator rit;

		std::vector< KeyStore *>::iterator storeIt;
		std::vector<Certificate>::iterator certIt;
	    
		KeyStore *matchingKeyStore = NULL ;
		//try to find a matching certificate 'matchingCertificate'
		for( rit = rinfo.begin() ; rit!= rinfo.end() ; rit++ ){

		    //iterate through all available keystores
		    for( storeIt = keyStores.begin() ; storeIt != keyStores.end() ; storeIt++ ){
			std::vector<Certificate> certVect = (*storeIt)->listCertificates();

			// iterate through all the certificates of this keystore.
			for( certIt = certVect.begin() ; certIt != certVect.end() ; certIt++ ){
			    dn issuer(rit->issuer_and_serial->issuer);
			    if( certIt->getIssuerName().compare( issuer ) )   {
				BIGNUM *bn=ASN1_INTEGER_to_BN(rit->issuer_and_serial->serial,NULL);
				std::string ret(BN_bn2hex(bn));
				if(strcmp(ret.c_str() , certIt->getSerialNumber().c_str()) == 0)  {
				    // find a matching certificate !
				    matchingCertificate = new Certificate(*certIt) ; 
				    matchingKeyStore = *storeIt;
				    break;
				}
			    }	
			
			}
		    
		    }
		}
    
		if( matchingCertificate != NULL ) {
		    //now get the pkey from the store
		    int ret = -1;
		    while ( ret == -1 || ret == GETKEY_BAD_PASSWD  ){
			ret = matchingKeyStore->getKey(*matchingCertificate , &pkey );
			if(ret == GETKEY_BAD_PASSWD){
			    wxMessageDialog errorMsg(this, _("Bad password! "), _("Error"), wxOK | wxICON_ERROR);
			    errorMsg.ShowModal();
			}
		    }
		
		    if(pkey != NULL) {
			if(p7.decrypt(pkey, matchingCertificate) != SUCCESS) {
#ifdef DEBUG				
			    std::cerr << "Error while decrypting" << std::endl;
#endif			    
			    if( ERR_GET_REASON( ERR_get_error()) == PKCS7_R_NO_RECIPIENT_MATCHES_CERTIFICATE){
			      wxString msg = wxString::Format(_("Error !: '%s' doesn't seem to be encrypted for you."),dropList->GetItemText(item).c_str());
				wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
				errorMsg.ShowModal();
	    
			    } else {
			      wxString msg = wxString::Format(_("Error !: unable to decrypt '%s'"),dropList->GetItemText(item).c_str());
				wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
				errorMsg.ShowModal();
			    }
#ifdef DEBUG			    
			    std::cerr << ERR_GET_REASON( ERR_get_error() )<< std::endl;
#endif			    
			    pg.Update(value++,dropList->GetItemText(item) + _T(": ") + _("Error"));

			} else {
			
			    // create decrypted filename , ie without the ending .pkcs7
			    wxFileName filename(dropList->GetItemText(item));
			    wxString file;
			    
			    if(leave) {
				file = filename.GetFullPath();
			    } else {
				filename = filename.GetFullName();
				filename=wxMyPrepend(filename,path);
				file = filename.GetFullPath();
			    }
			    //we remove the .pkcs7 extension
			    file = file.Mid(0,file.Len()-6);

			    // If the destination file already exists, ask the user
			    // what to do
			    bool overwriteDest = true;


			    if ( !alwaysOverwrite ){
				if( wxFileName::FileExists(file) ) {
				    wxFileName tmpFile( file );
				    OverwriteDlg askOverwrite( this , -1 , tmpFile.GetFullName() );
				    
				    int ret = askOverwrite.ShowModal();
				    
				    if( ret == ODL_ALL_ID ){
					alwaysOverwrite = true;
				    } else if( ret != wxID_YES ) {
					overwriteDest = false;
				    }
					
				}
			    }
			    
			    if( alwaysOverwrite || overwriteDest ) {
							if(p7.writeDecrypted(wx2std(file).c_str())==SUCCESS){
				    pg.Update(value++,dropList->GetItemText(item));
				    if(remove) wxRemoveFile(dropList->GetItemText(item).c_str());
				} else {
				    pg.Update(value++,file+ _T(": ") + _("Error"));
				}
			    } else {
				pg.Update(value++,file+ _T(": ") + _("Canceled"));
			    }
			}
		    } else {
			if( ret != GETKEY_CANCELED && ret != GETKEY_SUCCESS ) {
			    wxMessageBox(_("Error !: Private key not valid"), _("Error"), 
					 wxOK | wxICON_ERROR, this);
			    pg.Update(value++,dropList->GetItemText(item) + _T(": ") + _("Error"));
		    
			} else {
			    pg.Update(value++,dropList->GetItemText(item) + _T(": ") + _("Canceled"));
			}
		    }
		    delete matchingCertificate;
	    
		} else {
		    pg.Update(value++,dropList->GetItemText(item));
		    wxString msg = wxString::Format(_("'%s' was not encrypted for you"),dropList->GetItemText(item).c_str());
		    wxMessageBox( msg, _("Error"),  wxICON_ERROR, this);
		}

	    }
	}
    pg.Update(max);
    dropList->DeleteAllItems();
    enableButtons(false);
    return SUCCESS;
}
   
int MainWindow::encryptFiles(bool remove, bool leave, wxString path, 
			     std::vector<wxString>& certificates_files) {
    std::vector<Certificate> certificates;
    OpenSSL_add_all_algorithms();
    bool error = false;
    long item = -1;
  
    if( certificates_files.size() == 0){
				wxMessageDialog errorMsg(this, _("Empty! "), _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
    }
  
    std::vector<wxString>::iterator itr;

    wxProgressDialog pg(_("Encryption in progress ..."),
			_("Please wait"),
			dropList->GetItemCount(), 
			this, wxPD_CAN_ABORT | wxPD_REMAINING_TIME | wxPD_ELAPSED_TIME ); 
    int max = dropList->GetItemCount();
    int value = 0;


    bool alwaysOverwrite = false;
    for ( ;; ) {
	item = dropList->GetNextItem(item);
	if(item == -1) {
	    break;
	}
    
	pkcs7 *p7=new pkcs7();
	std::string cipher = user->getInfo("CipherAlgo");
	if (cipher == "") cipher = "AES-128";
	p7->setCipher( cipher );
	p7->setContentType( PKCS7Encrypted );
	for( itr = certificates_files.begin(); itr != certificates_files.end(); itr++ ) {
	    Certificate *certif = new Certificate();
      
	    if( certif->load( wx2std(*itr).c_str() ) != SUCCESS ) {
	      wxString msg = wxString::Format(_("An error occured while loading '%s'!"),itr->c_str());
		wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
		errorMsg.ShowModal();

#ifdef DEBUG	
		std::cerr << "Cannot load certificate '" << *itr << "'." << std::endl;
#endif		
		delete p7;
		delete certif;
		return -1;
	    }
	    p7->addRecipient( *certif );
      
	    delete certif;
	}
		
			
	wxString file;
    
	if (leave) {
	    //put encrypted files in the same directory than original files
	    file = dropList->GetItemText(item);
	} else { //put them in "path"
	    wxFileName filename(dropList->GetItemText(item));
	    filename = filename.GetFullName();
	    filename=wxMyPrepend(filename,path);
      
	    file = filename.GetFullPath();
	}

	file += _T(".pkcs7");
#ifdef DEBUG	
	std::cerr << file << std::endl;
#endif	
        
	std::string err = getErrorMsg(p7->encrypt(wx2std(dropList->GetItemText(item)).c_str()));
	if(err != ""){
	    wxMessageDialog errorMsg(this, std2wx(err), _("Error"), wxOK | wxICON_ERROR);
	    errorMsg.ShowModal();
	    error = true ;
	}
		
	if(!error){
	    bool overwriteDest = true;
	    if( !alwaysOverwrite ){
		if( wxFileName::FileExists(file) ) {
		    wxFileName tmpFile( file );
		    
		    OverwriteDlg askOverwrite( this , -1 , tmpFile.GetFullName() );
		    
		    int ret = askOverwrite.ShowModal() ;
		    
		    if( ret == ODL_ALL_ID ) {
			alwaysOverwrite = true;
		    } else if( ret != wxID_YES ){
			overwriteDest = false;
		    }
		}
	    }
	    
	    if( alwaysOverwrite || overwriteDest ){
					if(p7->write(wx2std(file).c_str())==SUCCESS){
		    pg.Update(value++,dropList->GetItemText(item));
		    if(remove) wxRemoveFile(dropList->GetItemText(item).c_str());
		}
	    } else {
		pg.Update(value++,file+ _T(": ") + _("Canceled"));
	    }
	    
	}else  {
	    pg.Update(value++,file+ _T(": ") + _("Error"));
#ifdef DEBUG	    
	    std::cerr << "Error: "<< file << std::endl;
#endif	    
	    error = TRUE;
	}
	delete p7;
    }
    pg.Update(max);
    dropList->DeleteAllItems();
    enableButtons(false);
    
    if(error) return -1; // TODO : ajouter des codes d'erreurs
    return SUCCESS;
}

int MainWindow::signFiles(bool detached, bool encrypted, bool leave,
			  bool remove, const wxString &path,
			  std::vector<wxString>& certificates_files) {

    KeyChoiceDlg kcd( this, keyStores , user ,KEY_SIGN );
    Certificate userCert;
    int ret = -2;

#ifdef DEBUG
		std::cerr << "--> Signing" << std::endl;
		std::cerr << "    Looking for Key and Cert" << std::endl;
#endif

    Key *pkey = kcd.getKeyAndCert( userCert , &ret);
    
#ifdef DEBUG
		std::cerr << "    Search over" << std::endl;
#endif

    if( ret == GETKEY_SUCCESS ){
    
#ifdef DEBUG
		std::cerr << "    Found Key" << std::endl;
#endif
    
	wxDir dir(wxGetCwd());
	wxArrayString filename;
	
	wxFileName CADir(std2wx(user->getCACertificatesDir()));
	dir.GetAllFiles(CADir.GetFullPath(), &filename,
			wxEmptyString, wxDIR_FILES);
    
	std::vector<Certificate> *certList = new std::vector<Certificate>;
	Certificate *cert;
	for(unsigned int i = 0 ; i < filename.GetCount() ; i++) {
	    cert = new Certificate();
	    if(cert->load(wx2std(filename.Item(i)).c_str())==SUCCESS){
		certList->push_back(*cert);
	    }
	}
    
	//get certificates chain for userCert
	std::vector<Certificate> *vect = userCert.getChain(certList);

	//loading the recipients Certificates
	std::vector<Certificate> *recipients = new std::vector<Certificate>;
	if( certificates_files.size()>0){
	    std::vector<wxString>::iterator fileIt =  certificates_files.begin();
	    while(fileIt !=  certificates_files.end()){
		Certificate *certif = new Certificate();
    
		if( certif->load( wx2std(*fileIt).c_str(), der_format ) != SUCCESS ) {
		    wxString msg = wxString::Format(_("An error occured while loading '%s'!"),fileIt->c_str());
		    wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
		    errorMsg.ShowModal();
#ifdef DEBUG	
		    std::cerr << "Cannot load certificate '" << *fileIt << "'." << std::endl;
#endif		    
		    delete certif;
		    
		    
		    
		    vect->clear();
		    delete vect;
		    
		    recipients->clear();
		    delete recipients;
		    
		    return -1;
		}
		recipients->push_back(*certif);
		delete certif;
		fileIt++;
	    }
	}
	
	/** signature **/
	long item = -1;
	pkcs7 *p7=new pkcs7();
	bool error = false;

	wxBeginBusyCursor();
	wxProgressDialog pg(_("Signature in progress ..."),
			    _("Please wait"),
			    dropList->GetItemCount(), 
			    this, wxPD_CAN_ABORT | wxPD_REMAINING_TIME | wxPD_ELAPSED_TIME ); 
	int max = dropList->GetItemCount();
	int value = 0;
	
	if(encrypted){
	    std::string cipher = user->getInfo("CipherAlgo");
	    if (cipher == "") cipher = "AES-128";
	    
	    p7->setCipher( cipher );

	}
	
	std::string digest =   user->getInfo("DigestAlgo");
	if( digest == "" ) digest = "SHA1";
	p7->setDigest( digest );



	bool alwaysOverwrite = false;	
	for ( ;; ) {
	    item = dropList->GetNextItem(item);
	    if( item == -1)
		break;
      
	    wxString file;
      
	    if (leave) {
		//put encrypted files in the same directory than original files
		file = dropList->GetItemText(item);
	    } else { //put them in "path"
		wxFileName filename(dropList->GetItemText(item));
		filename = filename.GetFullName();
		filename=wxMyPrepend(filename,path);
	  
		file = filename.GetFullPath();
	    }
	    file += _T(".pkcs7");
#ifdef DEBUG	    
	    std::cerr << file.c_str() << std::endl;
#endif	    

	    if(!encrypted){ //we will use pkcs7::sign()
		p7->setContentType( PKCS7Signed );
#ifdef DEBUG		
		std::cerr << "signature" << std::endl;
#endif		
		p7->sign(wx2std(dropList->GetItemText(item)).c_str(),
			 userCert, *pkey, *vect, detached);
	
	    } else { // we will use pkcs7::signAndEncrypt();
		p7->setContentType( PKCS7SignedEncrypted );
#ifdef DEBUG		
		std::cerr <<   p7->isSignedAndEncrypted()<< std::endl;
#endif		
		int i = p7->signAndEncrypt(wx2std(dropList->GetItemText(item)).c_str(),
					   userCert, *pkey, *vect, *recipients );
#ifdef DEBUG		
		std::cerr << i << std::endl;
#endif		
	    }
      
	    
	    bool overwriteDest = true;
	    if( !alwaysOverwrite ){
		if( wxFileName::FileExists(file) ) {
		    wxFileName tmpFile( file );
		    
		    OverwriteDlg askOverwrite( this , -1 , tmpFile.GetFullName() );
		    
		    int ret = askOverwrite.ShowModal() ;
		    
		    if( ret == ODL_ALL_ID ) {
			alwaysOverwrite = true;
		    } else if( ret != wxID_YES ){
			overwriteDest = false;
		    }
		}
	    }
	    
	    if( overwriteDest || alwaysOverwrite){
					if(p7->write(wx2std(file).c_str())== SUCCESS) {
		    pg.Update(value++,dropList->GetItemText(item));
		    if(remove) 
		      wxRemoveFile(dropList->GetItemText(item).c_str());
		} else  {
		  pg.Update(value++,file+ _T(": ") + _("Error"));
		  error = TRUE;
		}
	    } else {
	      pg.Update(value++,file+ _T(": ") + _("Canceled"));
	      
	    }
	}
	pg.Update(max);
	dropList->DeleteAllItems();
	enableButtons(false);
    
	
	vect->clear();
	delete vect;
	    
	recipients->clear();
	delete recipients;

	delete p7;
	wxEndBusyCursor();
	if (!error) return SUCCESS;  	    
    }


#ifdef DEBUG
		std::cerr << "<-- Signing" << std::endl;
#endif
    return -1;  
}

int MainWindow::verifyFiles(const bool leave, const bool remove,
			    const wxString &path, const bool extract){
    //		    const wxString &signerFile) {
    //loading signer certificate;
/*    Certificate *signer = new Certificate();
    if(signer->load(signerFile.c_str()) != SUCCESS) {
	wxString msg = "Error while loading ";
	msg += signerFile.c_str();
	wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	errorMsg.ShowModal();
	delete signer;
	return -1;
    }*/
	 
    //user certificate and PKCS#12

		wxFileName X509Filename(std2wx(user->getInfo("X509_Certificate")));
	wxFileName Pkcs12Filename(std2wx(user->getInfo("PKCS12")));
	
	X509Filename=wxMyPrepend(X509Filename,std2wx(user->getCertificatesDir()));
	Pkcs12Filename=wxMyPrepend(Pkcs12Filename,std2wx(user->getP12Dir()));
	
	//loading user x509
	Certificate *userCert = new Certificate();
	if( user->getInfo("X509_Certificate") != "" ){
	
			if(userCert->load(wx2std(X509Filename.GetFullPath()).c_str()) != SUCCESS){
			  wxString msg =  wxString::Format(_("An error occured while loading '%s'!"),X509Filename.GetFullPath().c_str());
	    wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	    errorMsg.ShowModal();
	    delete userCert;
	    //delete signer;
	    return -1;
	  }
	}

    //signature verification now
    long item = -1;
    pkcs7 *p7=new pkcs7();
     
    wxFileName CADir( std2wx(user->getCACertificatesDir()) );


    pkcs12 *p12 = NULL;
    pkcs8 *pkey = NULL;
    OpenSSL_add_all_algorithms();


    wxBeginBusyCursor();
    wxProgressDialog pg(_("Verification in progress ..."),
			_("Please wait"),
			dropList->GetItemCount(), 
			this, wxPD_AUTO_HIDE | wxPD_CAN_ABORT | wxPD_REMAINING_TIME | wxPD_ELAPSED_TIME ); 

    int max = dropList->GetItemCount();
    int value = 0;

    VerifyCertDlg vcd(this, -1 ,_("signature checking"),user );     

    bool alwaysOverwrite = false;

    for ( ;; ) {
      item = dropList->GetNextItem(item);
      if( item == -1)
	break;

	     
      if(p7->read(wx2std(dropList->GetItemText(item)).c_str())==SUCCESS 
	 && (p7->isSigned() || p7->isSignedAndEncrypted()) ){
	//loading signer certificate;
	Certificate signer = p7->getSignerCertificate();
	if(signer.getHash() == "") {
	  wxString msg = _("Error while loading signer certificate.\n");
	  msg+=wxString::Format(_("Maybe '%s' is not a signed file."),dropList->GetItemText(item).c_str());
	  wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
	  errorMsg.ShowModal();
	  //return -1;
	  
	} else {
#ifdef DEBUG	
	  std::cerr << "SIGN: " << signer.getSubjectName().getValues( DN_DISPLAY_LONG | DN_DISPLAY_VALUE) << std::endl;
#endif	  
	  
	  if(p7->isSignedAndEncrypted()){
		    if(p12 == NULL){
			//loading pkcs12
			p12 = new pkcs12();
			PasswordDlg pd(this, -1, _("Enter your private key password"));
			pd.addButtons();
			wxString password;
	
			bool loaded = false;
		 
			while(!loaded){
			    if(pd.ShowModal() == wxID_OK){
				password = pd.getPassword();
				if(p12->load( wx2std(Pkcs12Filename.GetFullPath()).c_str(),wx2std(password).c_str())==SUCCESS){
				    loaded = true;
				}
				else {
				    pd.clear();
				    wxString msg = _("Error while loading private key ");
				    msg += _T("\n");
						msg += _("Maybe your password is not valid.");
				    wxMessageDialog errorMsg(this, msg, _("Error"), wxOK | wxICON_ERROR);
				    errorMsg.ShowModal();
				}
			    }
			    else { //cancel btn pressed
				delete p12;
				return -1;
			    }
			}
			//now we load private key
			pkey = new pkcs8(p12->getKey());
		    }
		}
#ifdef DEBUG
		std::cerr << dropList->GetItemText(item) << std::endl ;
#endif		

		int valid = -1;
		pg.Update(value,dropList->GetItemText(item));
		if(p7->isSigned() || p7->isSignedAndEncrypted()){
		    if( p7->isSignedAndEncrypted() ){
			valid = p7->verify(signer, *pkey, *userCert,
												 wx2std(CADir.GetFullPath()).c_str());
		    } else if(!p7->isDetached()){
			valid = p7->verify(signer, *pkey, *userCert,
												 wx2std(CADir.GetFullPath()).c_str());
		    } else { //detached signature
			// we try to find the data file for this detached
			// signature in the same directory
			wxString dataFile;
			wxFileName dataFilename(dropList->GetItemText(item));
			dataFile = dataFilename.GetFullPath();
			dataFile = dataFile.Mid(0,dataFile.Len()-6);
		     
			if(!wxFileName::FileExists(dataFile)) {
			    //we can't find a file that match the signature, let the
			    //user choose it
			    wxMessageBox(_("No dettached signature was found, please specify in the next window..."),
					 _("Warning"), wxICON_WARNING | wxOK, this);
			    dataFile =  wxFileSelector(_("Please choose the file matched "
							 "by the signature"), wxGetCwd());
			}
#ifdef DEBUG
			std::cerr << "[DATA]: " << dataFile << std::endl;
#endif			
	    
			if(!dataFile.empty()) {
			    valid = p7->verify(signer, *pkey, *userCert,
														wx2std(CADir.GetFullPath()).c_str(), wx2std(dataFile).c_str());
			}
		    }
		    std::vector<Certificate> *certList = new std::vector<Certificate>;
			
		    wxDir dir(wxGetCwd());
		    wxArrayString filename;
			
		    wxFileName CADir( std2wx(user->getCACertificatesDir()) );
		    dir.GetAllFiles(CADir.GetFullPath(), &filename,
				    wxEmptyString, wxDIR_FILES);
			
		    for(unsigned int i = 0 ; i < filename.GetCount() ; i++) {
			Certificate cert;
#ifdef DEBUG			
			std::cerr << cert.getHash() << std::endl;
#endif			
			if(cert.load(wx2std(filename.Item(i)).c_str())==SUCCESS){
#ifdef DEBUG				
			    std::cerr<<filename.Item(i)<<std::endl;
#endif			    
			    certList->push_back(cert);
			}
		    }

		    //get the CA List 
		
		    std::vector<Certificate> *CA = p7->getChainFromSigned(certList);
#ifdef DEBUG		    
		    std::cerr << CA->size() << std::endl;
#endif		    
			
		    vcd.addRootItem(_T(""));
			
		    vcd.verifySignature(valid , dropList->GetItemText(item) , CA);
			
		    if(extract && !p7->isDetached()) {
			//extract data from signed file (attached signature)
			if(p7->extract(*pkey, *userCert)) {
			    wxFileName filename(dropList->GetItemText(item));
			    wxString file;
			 
			    if(leave) {
				file = filename.GetFullPath();
			    } else {
				filename = filename.GetFullName();
				filename=wxMyPrepend(filename,path);
				file = filename.GetFullPath();
			    }
			    //we remove the .pkcs7 extension
			    file = file.Mid(0,file.Len()-6);
			 
			    
			    // If the destination file already exists, ask the user
			    // what to do
			    bool overwriteDest = true;


			    if( !alwaysOverwrite ){
				if( wxFileName::FileExists(file) ) {
				    wxFileName tmpFile( file );
				    
				    OverwriteDlg askOverwrite( this , -1 , tmpFile.GetFullName() );
				    
				    int ret = askOverwrite.ShowModal() ;
				    
				    if( ret == ODL_ALL_ID ) {
					alwaysOverwrite = true;
				    } else if( ret != wxID_YES ){
					overwriteDest = false;
				    }
				}
			    }
			    
			    
			    if( alwaysOverwrite || overwriteDest ) {
							p7->writeExtracted(wx2std(file).c_str());
				if(remove) wxRemoveFile(dropList->GetItemText(item).c_str());
			    }
			}
			 
			
		    } else if(extract && !valid && !p7->isDetached()) {
			wxTreeItemId id = vcd.addItem
			    (vcd.getRootItem(), wxFileName
			     (dropList->GetItemText(item)).GetFullName(), 0);
			vcd.addItem(id, _("Unable to extract data from this signed "
					  "file (invalid signature)"),0);
			vcd.expand( id );
		    }
		} else {
		    vcd.addRootItem(_T(""));
		    wxTreeItemId id = vcd.addItem
			(vcd.getRootItem(), wxFileName
			 (dropList->GetItemText(item)).GetFullName(), 0);
		    vcd.addItem(id, _("This file is not a signed file"),0);
		    vcd.expand( id );
		}
		pg.Update(++value,dropList->GetItemText(item));

	    }

	    
	} else {
					vcd.addRootItem(_T(""));
	    wxTreeItemId id = vcd.addItem(  vcd.getRootItem(),dropList->GetItemText(item), 0);
	    vcd.addItem(id, _("This file is probably not a signed file"),0);
	    vcd.expand( id );
	    pg.Update(++value,dropList->GetItemText(item));
	}
    }
    pg.Update(max);
    dropList->DeleteAllItems();
    enableButtons(false);
    vcd.showModal(wxSize(540,400), _("OK"), false);

    delete p7;
    delete userCert;
    delete pkey;
    wxEndBusyCursor();
    return SUCCESS;     
}

void verifCallback(std::string filename, std::string m, void* statusDlg, bool ok){
    ((VerifyStatusDlg *)statusDlg)->addItem(std2wx(filename), ok, std2wx(m));
}

void MainWindow::enableButtons(const bool enable){
  mainToolBar->EnableTool(MW_ENCRYPT_BTN_ID, enable);
  mainToolBar->EnableTool(MW_DECRYPT_BTN_ID, enable );
  mainToolBar->EnableTool(MW_SIGN_BTN_ID,  enable);
  mainToolBar->EnableTool(MW_VERIFY_BTN_ID,  enable);
#ifdef USE_ENCRYPT_SELF
  mainToolBar->EnableTool(MW_SELF_BTN_ID, enable);
#endif
}



void MainWindow::enableAddressBookBtn(bool enable)
{
    mainToolBar->EnableTool(MW_ADDRESSBOOK_BTN_ID, enable);

}


void MainWindow::initKeyStores(){

    //OpenSSL KeyStore
    SoftKeyStore *sks = new SoftKeyStore( user );
    wxPasswordManager *pm  = new wxPasswordManager
	(this, -1 , user , _("Enter your password"));
    sks->setPasswordManager( pm );
    keyStores.push_back( sks );

    if ( sks->count() == 0 ){
	mainToolBar->EnableTool(MW_ENCRYPT_BTN_ID, false);
	mainToolBar->EnableTool(MW_DECRYPT_BTN_ID, false );	
#ifdef USE_ENCRYPT_SELF
	mainToolBar->EnableTool(MW_SELF_BTN_ID, false);
#endif

    }

    //PKCS11 KeyStores
	 
	 
    std::vector< std::string > pkcs11libs = user->getInfos( "PKCS11_KEYSTORE" );
    std::vector< std::string >::iterator i;
    for( i = pkcs11libs.begin() ; i != pkcs11libs.end() ; i++ ){
#ifdef DEBUG	    
	std::cerr << "Loading keystore: " << i->c_str() << std::endl;
#endif	
	Erreur * errorManager = new Erreur(this);
	P11KeyStore *pks = new P11KeyStore( i->c_str(), errorManager, pm );
	keyStores.push_back( pks );
    }
}



