/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _CertificateRequestWizard_hh_
#define _CertificateRequestWizard_hh_

#include <wx/wx.h>
#include <wx/wizard.h>

#include "../User.hh"

using namespace Cryptonit;

class CertificateRequestWizard: public wxWizard
{

private:

    wxWizard* wizard;
    User* user;
    bool success;


    class UserInformations: public wxWizardPageSimple
    {
    private:
	wxTextCtrl* tcFirstname;
	wxTextCtrl* tcLastname;
	wxTextCtrl* tcTitle;
	wxTextCtrl* tcDisplayname;
	wxTextCtrl* tcNickname;
	wxTextCtrl* tcEmail;
	wxTextCtrl* tcEmail2;
	wxTextCtrl* tcScreenname;

	void onWizardPageChanging(wxWizardEvent& event);

	DECLARE_EVENT_TABLE();

    public:
	std::vector< std::pair< std::pair< wxString, wxString >, wxString > > infos;
	UserInformations(wxWizard* parent);
    };



    class OrganizationInformations: public wxWizardPageSimple
    {
    private:
	wxTextCtrl* tcOrganization;
	wxTextCtrl* tcDepartment;
	wxTextCtrl* tcAddress;
	wxTextCtrl* tcAddress2;
	wxTextCtrl* tcCity;
	wxTextCtrl* tcState;
	wxTextCtrl* tcZip;
	wxTextCtrl* tcCountry;
	wxTextCtrl* tcWebpage;

	void onWizardPageChanging(wxWizardEvent& event);

	DECLARE_EVENT_TABLE();

    public:
	std::vector< std::pair< std::pair< wxString, wxString >, wxString > > infos;

	OrganizationInformations(wxWizard* parent);
    };



    class OptionnalAttributes: public wxWizardPageSimple
    {
    private:
	void onWizardPageChanging(wxWizardEvent& event);
	DECLARE_EVENT_TABLE();
    public:
	wxString challenge;

	OptionnalAttributes(wxWizard* parent);
    };



    class PrivateKeyPasswordAlgorithm: public wxWizardPageSimple
    {
    private:
	std::vector< std::pair < std::string, std::string > > ciphers;

	wxComboBox* cbCipher;
	wxTextCtrl* tcPassphraseFirst;
	wxTextCtrl* tcPassphrase;
	wxTextCtrl* tcKeySize;
	wxStaticText* passphraseValid;

	void onWizardPageChanging(wxWizardEvent& event);
	void check(wxCommandEvent& event);

	DECLARE_EVENT_TABLE();

    public:
	wxString algorithm;
	wxString prettyAlgorithm;
	wxString passphrase;
	int keySize;

	PrivateKeyPasswordAlgorithm(wxWizard* parent);
    };



    class OutputFile: public wxWizardPageSimple
    {
    private:
	wxTextCtrl* tcFilename;

	void onWizardPageChanging(wxWizardEvent& event);
	void onFileBtnClick(wxCommandEvent &WXUNUSED(event));

	DECLARE_EVENT_TABLE();
    public:
	wxString filename;

	OutputFile(wxWizard* parent);
    };



    class Summary: public wxWizardPageSimple
    {
    private:
	UserInformations* userInformations;
	OrganizationInformations* organizationInformations;
	PrivateKeyPasswordAlgorithm* privateKey;
	OutputFile* outputFile;

	void onWizardPageChanging(wxWizardEvent& event);
	void onWizardPageChanged(wxWizardEvent& event);

	DECLARE_EVENT_TABLE();

    public:
	Summary(wxWizard* parent,
		UserInformations* user,
		OrganizationInformations* organization,
		PrivateKeyPasswordAlgorithm* key,
		OutputFile* file);
    };



    class Process: public wxWizardPageSimple
    {
    private:
	User* user;

	UserInformations* userInformations;
	OrganizationInformations* organizationInformations;
	PrivateKeyPasswordAlgorithm* privateKey;
	OutputFile* outputFile;

	wxStaticText* primeP;
	wxStaticText* primeQ;
	wxStaticText* encrypting;
	wxStaticText* request;
	wxStaticText* finishText;
	wxStaticText* doneText;

	wxStaticBitmap* primePBitmap;
	wxStaticBitmap* primeQBitmap;
	wxStaticBitmap* encryptingBitmap;
	wxStaticBitmap* requestBitmap;
	wxStaticBitmap* doneBitmap;

	bool generated;

	void onWizardPageChanging(wxWizardEvent& event);
	void onWizardPageChanged(wxWizardEvent& event);
	void onIdle(wxIdleEvent& event);
	static void generateKeyCallback(int p, int n, void *arg);

	DECLARE_EVENT_TABLE();

    public:
	Process(wxWizard* parent,
		User* u,
		UserInformations* userInfos,
		OrganizationInformations* organization,
		PrivateKeyPasswordAlgorithm* key,
		OutputFile* file);
    };



public:
    bool getSuccess() { return success; }
    CertificateRequestWizard( User* u, wxWindow* parent );
    ~CertificateRequestWizard();

};

enum {
    CRW_OUTPUT_FILE_BTN = 8500,
    CRW_PASS_FIRST_TC,
    CRW_PASS_TC
};

#endif
