if not modules then modules = { } end modules ['luat-fio'] = {
    version   = 1.001,
    comment   = "companion to luat-lib.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files"
}

local texiowrite_nl = (texio and texio.write_nl) or print
local texiowrite    = (texio and texio.write) or print

local format = string.format

texconfig.kpse_init      = false
texconfig.shell_escape   = 't'
texconfig.max_in_open    = 127
texconfig.max_print_line = 100000

if not resolvers.instance then

    resolvers.reset()

    resolvers.instance.progname   = 'context'
    resolvers.instance.engine     = 'luatex'
    resolvers.instance.validfile  = resolvers.validctxfile

--~ trackers.enable("resolvers.*")
    resolvers.load()
--~ trackers.disable("resolvers.*")

    if callback then

        callbacks.register('find_read_file'      , function(id,name) return resolvers.findtexfile(name)   end,  true)
        callbacks.register('open_read_file'      , function(   name) return resolvers.opentexfile(name)   end,  true)

        callbacks.register('find_data_file'      , function(name) return resolvers.findbinfile(name,"tex") end, true)
        callbacks.register('find_enc_file'       , function(name) return resolvers.findbinfile(name,"enc") end, true)
        callbacks.register('find_font_file'      , function(name) return resolvers.findbinfile(name,"tfm") end, true)
        callbacks.register('find_format_file'    , function(name) return resolvers.findbinfile(name,"fmt") end, true)
        callbacks.register('find_image_file'     , function(name) return resolvers.findbinfile(name,"tex") end, true)
        callbacks.register('find_map_file'       , function(name) return resolvers.findbinfile(name,"map") end, true)
        callbacks.register('find_ocp_file'       , function(name) return resolvers.findbinfile(name,"ocp") end, true)
        callbacks.register('find_opentype_file'  , function(name) return resolvers.findbinfile(name,"otf") end, true)
        callbacks.register('find_output_file'    , function(name) return name                              end, true)
        callbacks.register('find_pk_file'        , function(name) return resolvers.findbinfile(name,"pk")  end, true)
        callbacks.register('find_sfd_file'       , function(name) return resolvers.findbinfile(name,"sfd") end, true)
        callbacks.register('find_truetype_file'  , function(name) return resolvers.findbinfile(name,"ttf") end, true)
        callbacks.register('find_type1_file'     , function(name) return resolvers.findbinfile(name,"pfb") end, true)
        callbacks.register('find_vf_file'        , function(name) return resolvers.findbinfile(name,"vf")  end, true)

        callbacks.register('read_data_file'      , function(file) return resolvers.loadbinfile(file,"tex") end, true)
        callbacks.register('read_enc_file'       , function(file) return resolvers.loadbinfile(file,"enc") end, true)
        callbacks.register('read_font_file'      , function(file) return resolvers.loadbinfile(file,"tfm") end, true)
     -- format
     -- image
        callbacks.register('read_map_file'       , function(file) return resolvers.loadbinfile(file,"map") end, true)
        callbacks.register('read_ocp_file'       , function(file) return resolvers.loadbinfile(file,"ocp") end, true)
     -- output
        callbacks.register('read_pk_file'        , function(file) return resolvers.loadbinfile(file,"pk")  end, true) -- 600dpi/manfnt.720pk
        callbacks.register('read_sfd_file'       , function(file) return resolvers.loadbinfile(file,"sfd") end, true)
        callbacks.register('read_vf_file'        , function(file) return resolvers.loadbinfile(file,"vf" ) end, true)

        callbacks.register('find_font_file'      , function(name) return resolvers.findbinfile(name,"ofm") end, true)
        callbacks.register('find_vf_file'        , function(name) return resolvers.findbinfile(name,"ovf") end, true)

        callbacks.register('read_font_file'      , function(file) return resolvers.loadbinfile(file,"ofm") end, true)
        callbacks.register('read_vf_file'        , function(file) return resolvers.loadbinfile(file,"ovf") end, true)

     -- callbacks.register('read_opentype_file'  , function(file) return resolvers.loadbinfile(file,"otf") end, true)
     -- callbacks.register('read_truetype_file'  , function(file) return resolvers.loadbinfile(file,"ttf") end, true)
     -- callbacks.register('read_type1_file'     , function(file) return resolvers.loadbinfile(file,"pfb") end, true)

        callbacks.register('find_write_file'     , function(id,name) return name end, true)
        callbacks.register('find_format_file'    , function(name)    return name end, true)

    end

end

statistics.register("input load time", function()
    return format("%s seconds", statistics.elapsedtime(resolvers.instance))
end)
