(*                        guibase.ml

    This file is part of COLLATINUS

    COLLATINUS is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    COLLATINUS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with COLLATINUS; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    (c) Yves Ouvrard, Angoulme, 2005 - 2006

    compilation : 
	ocamlopt -o collatinus -I +lablgtk2 lablgtk.cmxa guibase.ml str.cmxa latinus.ml collatinus.ml

    # vim: syntax=ocaml
*)

class main () =
  let fenestra =
    GWindow.window ~width:700 ~height:500 ~title:"Collatinus" ~allow_shrink:true
      ~allow_grow:true ~modal:true ()
  in
  let vbox = GPack.vbox ~homogeneous:false ~packing:(fenestra#add) () in
  let mbar =
    GMenu.menu_bar ~packing:(vbox#pack ~expand:false ~fill:true ~padding:1) ()
  in

  (* Menu Capsa *)
  let _Capsa = GMenu.menu_item ~label:"Capsa" ~packing:(mbar#add) () in
  let menuCapsa = GMenu.menu ~packing:(_Capsa#set_submenu) () in
  let itemNoua = GMenu.menu_item ~label:"Noua" ~packing:(menuCapsa#add) () in
  let itemLegere = GMenu.menu_item ~label:"Legere" ~packing:(menuCapsa#add) () in
  let itemScribere = GMenu.menu_item ~label:"Scribere" ~packing:(menuCapsa#add) () in
  let itemScribereSub = GMenu.menu_item ~label:"Scribere sub" ~packing:(menuCapsa#add) () in
  let _ = GMenu.separator_item ~packing:(menuCapsa#add) () in
  let itemQuit = GMenu.menu_item ~label:"Exire" ~packing:(menuCapsa#add) () in
  (* Menu Editio *)
  let _Editio = GMenu.menu_item ~label:"Editio" ~packing:(mbar#add) () in
  let menuEditio = GMenu.menu ~packing:(_Editio#set_submenu) () in
  let itemDelere = GMenu.menu_item ~label:"Delere" ~packing:(menuEditio#add) () in
  let itemSeponere = GMenu.menu_item ~label:"Seponere" ~packing:(menuEditio#add) () in
  let itemDeponere = GMenu.menu_item ~label:"Deponere" ~packing:(menuEditio#add) () in
  let _ = GMenu.separator_item ~packing:(menuEditio#add) () in
  let itemMaiores = GMenu.menu_item ~label:"Maiores litterae" ~packing:(menuEditio#add) () in
  let itemExiliores = GMenu.menu_item ~label:"Exiliores litterae" ~packing:(menuEditio#add) () in
  let itemAlin = GMenu.check_menu_item ~label:"A linea" ~active: false ~packing:(menuEditio#add) () in
  (* Menu Lemmata *)
  let _Lemmata = GMenu.menu_item ~label:"Lemmata" ~packing:(mbar#add) () in
  let menuLemmata = GMenu.menu ~packing:(_Lemmata#set_submenu) () in
  let itemOmniaLemm = GMenu.menu_item ~label:"Omnia lemmatizare" ~packing:(menuLemmata#add) () in
  let itemLemmDele = GMenu.menu_item ~label:"lemmata radere" ~packing:(menuLemmata#add) () in
  let _ = GMenu.separator_item ~packing:(menuLemmata#add) () in
  let itemGermanice =
    GMenu.radio_menu_item ~label:"Germanice" ~active:true ~packing:(menuLemmata#add) ()
  in
  let itemAnglice =
    GMenu.radio_menu_item ~label:"Anglice" ~active:true
      ~group:(itemGermanice#group) ~packing:(menuLemmata#add) ()
  in
  let itemGallice =
    GMenu.radio_menu_item ~label:"Gallice" ~active:true 
    ~group:(itemAnglice#group) ~packing:(menuLemmata#add)
      ()
  in
  (* Menu Auxilium *)
  let _Auxilium = GMenu.menu_item ~label:"Auxilium" ~packing:(mbar#add) () in
  let menuAuxilium = GMenu.menu ~packing:(_Auxilium#set_submenu) () in
  let itemAuxilium = GMenu.menu_item ~label:"Auxilium" ~packing:(menuAuxilium#add) () in
  let itemDe = GMenu.menu_item ~label:"de Collatino" ~packing:(menuAuxilium#add) () in

  (* raccourcis *)
  let accel_mbar = GtkData.AccelGroup.create () in
  let _ = fenestra#add_accel_group accel_mbar in
  let _ = itemNoua#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._N
  in
  let _ = itemLegere#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._O
  in
  let _ = itemScribere#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._S
  in
  let _ = itemQuit#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._Q
  in
  let _ = menuEditio#set_accel_group accel_mbar in
  let _ = itemDelere#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._X
  in
  let _ = itemSeponere#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._C
  in
  let _ = itemDeponere#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._V
  in
  let _ = itemMaiores#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._M
  in
  let _ = itemExiliores#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._E
  in
  let _ = itemOmniaLemm#add_accelerator ~group:accel_mbar ~modi:([`CONTROL])
      ~flags:([`VISIBLE; `LOCKED]) GdkKeysyms._L
  in

  (* Utilium claues *)
  let toolbar = GButton.toolbar 
      ~height:40 
      ~orientation:`HORIZONTAL 
      ~style:`ICONS
      ~tooltips:true 
      ~packing:(vbox#pack ~expand:false ~fill:true) ()
  in
  let bnoua = 
    toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/noua.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"Capsa noua"
      ~text:"Noua"
      ()
  in
  let blege = toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/lege.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"Capsam legere"
      ~text:"Lege"
      ()
  in
  let bscribe = 
    toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/scribe.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"Capsam scribere"
      ~text:"Scribe"
      ()
  in
  let blemmata = 
    toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/lemmata.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"Omnia lemmata"
      ~text:"Lemmata"
      ()
  in
  let bnullum = toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/nulla.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"omnia lemmata inferiora radere"
      ~text:"Lemmata rade"
      ()
  in
  let bmaiores = toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/maiores.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"maiores litterae"
      ~text:"maiores litterae"
      ()
  in
  let bexiliores = toolbar#insert_button
      ~icon:( 
         let info = GDraw.pixmap_from_xpm ~file:"images/exiliores.xpm" () in
         (GMisc.pixmap info ())#coerce
         )
      ~tooltip:"exiliores litterae"
      ~text:"exiliores litterae"
      ()
  in
 (* choix des frquences *)
 (*
  let bfreq = GEdit.combo
      ~popdown_strings:["omnia";
               "frequentissima";
               "rara";
               "rariora";
               "rarissima"]
  *)
  let (bfreq, _) = GEdit.combo_box_text
      ~strings:["omnia";
               "frequentissima";
               "rara";
               "rariora";
               "rarissima"]
     ~packing: toolbar#add
     ()
  in
  let _ = bfreq#set_active 0
  in
 (* conteneur vertical *)
  let wpane_12 =
    GPack.paned `VERTICAL
      ~packing:(vbox#pack ~expand:true ~fill:true ~padding:1) ()
  in
  let wscroll_13 =
    GBin.scrolled_window ~height:200 ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT ~packing:(wpane_12#add1) ()
  in
  (*
  let buffer_lat = GText.buffer ()
  in
  let _ = buffer_lat#create_tag 
         ~name:"magnitudo" 
         [`SIZE (15*Pango.scale)]
  in
  *)
  let wt_lat =
    GText.view ~editable:true 
      ~packing:(wscroll_13#add)
      ~wrap_mode: `WORD
     (* ~buffer: buffer_lat*)
      ()
  in
  let wnote =
    GPack.notebook ~tab_pos:`BOTTOM ~show_tabs:true ~homogeneous_tabs:true
      ~show_border:true ~scrollable:false ~packing:(wpane_12#add2)
      ()
  in
  let wscroll_16 =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT
      ~packing:(
        fun w ->
          wnote#append_page ~tab_label:((GMisc.label ~text:"texte" ())#coerce)
            w)
      ()
  in
  let wt_txt =
    GText.view ~editable:true
      ~packing:(wscroll_16#add) ()
  in
  let wscroll_17 =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT
      ~packing:(
        fun w ->
          wnote#append_page ~tab_label:((GMisc.label ~text:"LaTex" ())#coerce)
            w)
      ()
  in
  let wt_tex =
    GText.view ~editable:true 
      ~packing:(wscroll_17#add) ()
  in
  let wscroll_18 =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT
      ~packing:(
        fun w ->
          wnote#append_page ~tab_label:((GMisc.label ~text:"html" ())#coerce)
            w)
      ()
  in
  let wt_html =
    GText.view ~editable:true
      ~packing:(wscroll_18#add) ()
  in
  (* Flexio : implementatio in futurum *)
  (*
  let wscroll_19 =
    GBin.scrolled_window ~hpolicy:`AUTOMATIC ~vpolicy:`AUTOMATIC
      ~placement:`TOP_LEFT
      ~packing:(
        fun w ->
          wnote#append_page
            ~tab_label:((GMisc.label ~text:"Flexio" ())#coerce) w)
      ()
  in
  let wt_flexio =
    GText.view ~editable:true 
      ~packing:(wscroll_19#add) ()
  in
  *)
  let wstat_24 =
    GMisc.statusbar ~packing:(vbox#pack ~expand:false ~fill:true) ()
  in
  object
    val fenestra = fenestra
    val vbox = vbox
    val mbar = mbar
    val itemNoua = itemNoua
    val bfreq = bfreq
    val bnoua = bnoua
    val blemmata = blemmata
    val blege = blege
    val bnullum = bnullum
    val bmaiores = bmaiores
    val bexiliores = bexiliores
    val bscribe = bscribe
    val itemAlin = itemAlin
    val itemAnglice = itemAnglice
    val itemAuxilium = itemAuxilium
    val itemDe = itemDe
    val itemDelere = itemDelere
    val itemDeponere = itemDeponere
    val itemExiliores = itemExiliores
    val itemGallice = itemGallice
    val itemGermanice = itemGermanice
    val itemLegere = itemLegere
    val itemScribere = itemScribere
    val itemScribereSub = itemScribereSub
    val itemLemmDele = itemLemmDele
    val itemMaiores = itemMaiores
    val itemOmniaLemm = itemOmniaLemm
    val itemQuit = itemQuit
    val itemSeponere = itemSeponere
    val accel_mbar = accel_mbar
    val wpane_12 = wpane_12
    val wscroll_13 = wscroll_13
    (* val buffer_lat = buffer_lat *)
    val wt_lat = wt_lat
    val wnote = wnote
    val wscroll_16 = wscroll_16
    val wt_txt = wt_txt
    val wscroll_17 = wscroll_17
    val wt_tex = wt_tex
    val wscroll_18 = wscroll_18
    val wt_html = wt_html
    (*
    val wscroll_19 = wscroll_19
    val wt_flexio = wt_flexio
    *)
    val wstat_24 = wstat_24
    method fenestra = fenestra
    method vbox = vbox
    method mbar = mbar
    method itemQuit = itemQuit
    method itemAlin = itemAlin
    method itemAnglice = itemAnglice
    method itemDe = itemDe
    method itemDeponere = itemDeponere
    method itemExiliores = itemExiliores
    method itemGallice = itemGallice
    method itemGermanice = itemGermanice
    method itemMaiores = itemMaiores
    method itemOmniaLemm = itemOmniaLemm
    method itemSeponere = itemSeponere
    method accel_mbar = accel_mbar
    method wpane_12 = wpane_12
    method wscroll_13 = wscroll_13
    (* method buffer_lat = buffer_lat *)
    method wt_lat = wt_lat
    method wnote = wnote
    method wscroll_16 = wscroll_16
    method wt_txt = wt_txt
    method wscroll_17 = wscroll_17
    method wt_tex = wt_tex
    method wscroll_18 = wscroll_18
    method wt_html = wt_html
    (*
    method wscroll_19 = wscroll_19
    method wt_flexio = wt_flexio
    *)
    method wstat_24 = wstat_24
  end
