/// \file pdffontdata.inc Definition of the 14 Adobe core fonts.

/*

The 14 core Postscript fonts:
-----------------------------

Helvetica, Helvetica-Bold, Helvetica-Oblique, Helvetica-BoldOblique

Times-Roman, Times-Bold, Times-Italic, Times-BoldItalic

Courier, Courier-Bold, Courier-Oblique, Courier-BoldOblique

Symbol, ZapfDingbats

*/

//=====================================================================

static short cwHelvetica[] =
  {
    /*   0 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  10 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  20 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  30 */  278,  278,  278,  278,  355,  556,  556,  889,  667,  191,
    /*  40 */  333,  333,  389,  584,  278,  333,  278,  278,  556,  556,
    /*  50 */  556,  556,  556,  556,  556,  556,  556,  556,  278,  278,
    /*  60 */  584,  584,  584,  556, 1015,  667,  667,  722,  722,  667,
    /*  70 */  611,  778,  722,  278,  500,  667,  556,  833,  722,  778,
    /*  80 */  667,  778,  722,  667,  611,  722,  667,  944,  667,  667,
    /*  90 */  611,  278,  278,  278,  469,  556,  333,  556,  556,  500,
    /* 100 */  556,  556,  278,  556,  556,  222,  222,  500,  222,  833,
    /* 110 */  556,  556,  556,  556,  333,  500,  278,  556,  500,  722,
    /* 120 */  500,  500,  500,  334,  260,  334,  584,  350,  558,  350,
    /* 130 */  222,  556,  333, 1000,  556,  556,  333, 1000,  667,  333,
    /* 140 */ 1000,  350,  611,  350,  350,  222,  222,  333,  333,  350,
    /* 150 */  556, 1000,  333, 1000,  500,  333,  944,  350,  500,  667,
    /* 160 */  278,  333,  556,  556,  556,  556,  260,  556,  333,  737,
    /* 170 */  370,  556,  584,  333,  737,  333,  333,  584,  333,  333,
    /* 180 */  333,  556,  537,  278,  333,  333,  365,  556,  834,  834,
    /* 190 */  834,  611,  667,  667,  667,  667,  667,  667, 1000,  722,
    /* 200 */  667,  667,  667,  667,  278,  278,  278,  278,  722,  722,
    /* 210 */  778,  778,  778,  778,  778,  584,  778,  722,  722,  722,
    /* 220 */  722,  667,  667,  611,  556,  556,  556,  556,  556,  556,
    /* 230 */  889,  500,  556,  556,  556,  556,  278,  278,  278,  278,
    /* 240 */  556,  556,  556,  556,  556,  556,  556,  584,  611,  556,
    /* 250 */  556,  556,  556,  500,  556,  500
  };

static short cwHelveticaBold[] =
  {
    /*   0 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  10 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  20 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  30 */  278,  278,  278,  333,  474,  556,  556,  889,  722,  238,
    /*  40 */  333,  333,  389,  584,  278,  333,  278,  278,  556,  556,
    /*  50 */  556,  556,  556,  556,  556,  556,  556,  556,  333,  333,
    /*  60 */  584,  584,  584,  611,  975,  722,  722,  722,  722,  667,
    /*  70 */  611,  778,  722,  278,  556,  722,  611,  833,  722,  778,
    /*  80 */  667,  778,  722,  667,  611,  722,  667,  944,  667,  667,
    /*  90 */  611,  333,  278,  333,  584,  556,  333,  556,  611,  556,
    /* 100 */  611,  556,  333,  611,  611,  278,  278,  556,  278,  889,
    /* 110 */  611,  611,  611,  611,  389,  556,  333,  611,  556,  778,
    /* 120 */  556,  556,  500,  389,  280,  389,  584,  350,  558,  350,
    /* 130 */  278,  556,  500, 1000,  556,  556,  333, 1000,  667,  333,
    /* 140 */ 1000,  350,  611,  350,  350,  278,  278,  500,  500,  350,
    /* 150 */  556, 1000,  333, 1000,  556,  333,  944,  350,  500,  667,
    /* 160 */  278,  333,  556,  556,  556,  556,  280,  556,  333,  737,
    /* 170 */  370,  556,  584,  333,  737,  333,  333,  584,  333,  333,
    /* 180 */  333,  611,  556,  278,  333,  333,  365,  556,  834,  834,
    /* 190 */  834,  611,  722,  722,  722,  722,  722,  722, 1000,  722,
    /* 200 */  667,  667,  667,  667,  278,  278,  278,  278,  722,  722,
    /* 210 */  778,  778,  778,  778,  778,  584,  778,  722,  722,  722,
    /* 220 */  722,  667,  667,  611,  556,  556,  556,  556,  556,  556,
    /* 230 */  889,  556,  556,  556,  556,  556,  278,  278,  278,  278,
    /* 240 */  611,  611,  611,  611,  611,  611,  611,  584,  611,  611,
    /* 250 */  611,  611,  611,  556,  611,  556
  };

static short cwHelveticaOblique[] =
  {
    /*   0 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  10 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  20 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  30 */  278,  278,  278,  278,  355,  556,  556,  889,  667,  191,
    /*  40 */  333,  333,  389,  584,  278,  333,  278,  278,  556,  556,
    /*  50 */  556,  556,  556,  556,  556,  556,  556,  556,  278,  278,
    /*  60 */  584,  584,  584,  556, 1015,  667,  667,  722,  722,  667,
    /*  70 */  611,  778,  722,  278,  500,  667,  556,  833,  722,  778,
    /*  80 */  667,  778,  722,  667,  611,  722,  667,  944,  667,  667,
    /*  90 */  611,  278,  278,  278,  469,  556,  333,  556,  556,  500,
    /* 100 */  556,  556,  278,  556,  556,  222,  222,  500,  222,  833,
    /* 110 */  556,  556,  556,  556,  333,  500,  278,  556,  500,  722,
    /* 120 */  500,  500,  500,  334,  260,  334,  584,  350,  558,  350,
    /* 130 */  222,  556,  333, 1000,  556,  556,  333, 1000,  667,  333,
    /* 140 */ 1000,  350,  611,  350,  350,  222,  222,  333,  333,  350,
    /* 150 */  556, 1000,  333, 1000,  500,  333,  944,  350,  500,  667,
    /* 160 */  278,  333,  556,  556,  556,  556,  260,  556,  333,  737,
    /* 170 */  370,  556,  584,  333,  737,  333,  333,  584,  333,  333,
    /* 180 */  333,  556,  537,  278,  333,  333,  365,  556,  834,  834,
    /* 190 */  834,  611,  667,  667,  667,  667,  667,  667, 1000,  722,
    /* 200 */  667,  667,  667,  667,  278,  278,  278,  278,  722,  722,
    /* 210 */  778,  778,  778,  778,  778,  584,  778,  722,  722,  722,
    /* 220 */  722,  667,  667,  611,  556,  556,  556,  556,  556,  556,
    /* 230 */  889,  500,  556,  556,  556,  556,  278,  278,  278,  278,
    /* 240 */  556,  556,  556,  556,  556,  556,  556,  584,  611,  556,
    /* 250 */  556,  556,  556,  500,  556,  500
  };

static short cwHelveticaBoldOblique[] =
  {
    /*   0 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  10 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  20 */  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
    /*  30 */  278,  278,  278,  333,  474,  556,  556,  889,  722,  238,
    /*  40 */  333,  333,  389,  584,  278,  333,  278,  278,  556,  556,
    /*  50 */  556,  556,  556,  556,  556,  556,  556,  556,  333,  333,
    /*  60 */  584,  584,  584,  611,  975,  722,  722,  722,  722,  667,
    /*  70 */  611,  778,  722,  278,  556,  722,  611,  833,  722,  778,
    /*  80 */  667,  778,  722,  667,  611,  722,  667,  944,  667,  667,
    /*  90 */  611,  333,  278,  333,  584,  556,  333,  556,  611,  556,
    /* 100 */  611,  556,  333,  611,  611,  278,  278,  556,  278,  889,
    /* 110 */  611,  611,  611,  611,  389,  556,  333,  611,  556,  778,
    /* 120 */  556,  556,  500,  389,  280,  389,  584,  350,  558,  350,
    /* 130 */  278,  556,  500, 1000,  556,  556,  333, 1000,  667,  333,
    /* 140 */ 1000,  350,  611,  350,  350,  278,  278,  500,  500,  350,
    /* 150 */  556, 1000,  333, 1000,  556,  333,  944,  350,  500,  667,
    /* 160 */  278,  333,  556,  556,  556,  556,  280,  556,  333,  737,
    /* 170 */  370,  556,  584,  333,  737,  333,  333,  584,  333,  333,
    /* 180 */  333,  611,  556,  278,  333,  333,  365,  556,  834,  834,
    /* 190 */  834,  611,  722,  722,  722,  722,  722,  722, 1000,  722,
    /* 200 */  667,  667,  667,  667,  278,  278,  278,  278,  722,  722,
    /* 210 */  778,  778,  778,  778,  778,  584,  778,  722,  722,  722,
    /* 220 */  722,  667,  667,  611,  556,  556,  556,  556,  556,  556,
    /* 230 */  889,  556,  556,  556,  556,  556,  278,  278,  278,  278,
    /* 240 */  611,  611,  611,  611,  611,  611,  611,  584,  611,  611,
    /* 250 */  611,  611,  611,  556,  611,  556
  };

/* 4 Times-Roman */
static short cwTimesRoman[] =
  {
    /*   0 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  10 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  20 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  30 */  250,  250,  250,  333,  408,  500,  500,  833,  778,  333,
    /*  40 */  333,  333,  500,  564,  250,  333,  250,  278,  500,  500,
    /*  50 */  500,  500,  500,  500,  500,  500,  500,  500,  278,  278,
    /*  60 */  564,  564,  564,  444,  921,  722,  667,  667,  722,  611,
    /*  70 */  556,  722,  722,  333,  389,  722,  611,  889,  722,  722,
    /*  80 */  556,  722,  667,  556,  611,  722,  722,  944,  722,  722,
    /*  90 */  611,  333,  278,  333,  469,  500,  333,  444,  500,  444,
    /* 100 */  500,  444,  333,  500,  500,  278,  278,  500,  278,  778,
    /* 110 */  500,  500,  500,  500,  333,  389,  278,  500,  500,  722,
    /* 120 */  500,  500,  444,  480,  200,  480,  541,  350,  500,  350,
    /* 130 */  333,  500,  444, 1000,  500,  500,  333, 1000,  556,  333,
    /* 140 */  889,  350,  611,  350,  350,  333,  333,  444,  444,  350,
    /* 150 */  500, 1000,  333,  980,  389,  333,  722,  350,  444,  722,
    /* 160 */  250,  333,  500,  500,  500,  500,  200,  500,  333,  760,
    /* 170 */  276,  500,  564,  333,  760,  333,  333,  564,  300,  300,
    /* 180 */  333,  500,  453,  250,  333,  300,  310,  500,  750,  750,
    /* 190 */  750,  444,  722,  722,  722,  722,  722,  722,  889,  667,
    /* 200 */  611,  611,  611,  611,  333,  333,  333,  333,  722,  722,
    /* 210 */  722,  722,  722,  722,  722,  564,  722,  722,  722,  722,
    /* 220 */  722,  722,  556,  500,  444,  444,  444,  444,  444,  444,
    /* 230 */  667,  444,  444,  444,  444,  444,  278,  278,  278,  278,
    /* 240 */  500,  500,  500,  500,  500,  500,  500,  564,  500,  500,
    /* 250 */  500,  500,  500,  500,  500,  500
  };

static short cwTimesBold[] =
  {
    /*   0 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  10 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  20 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  30 */  250,  250,  250,  333,  555,  500,  500, 1000,  833,  278,
    /*  40 */  333,  333,  500,  570,  250,  333,  250,  278,  500,  500,
    /*  50 */  500,  500,  500,  500,  500,  500,  500,  500,  333,  333,
    /*  60 */  570,  570,  570,  500,  930,  722,  667,  722,  722,  667,
    /*  70 */  611,  778,  778,  389,  500,  778,  667,  944,  722,  778,
    /*  80 */  611,  778,  722,  556,  667,  722,  722, 1000,  722,  722,
    /*  90 */  667,  333,  278,  333,  581,  500,  333,  500,  556,  444,
    /* 100 */  556,  444,  333,  500,  556,  278,  333,  556,  278,  833,
    /* 110 */  556,  500,  556,  556,  444,  389,  333,  556,  500,  722,
    /* 120 */  500,  500,  444,  394,  220,  394,  520,  350,  500,  350,
    /* 130 */  333,  500,  500, 1000,  500,  500,  333, 1000,  556,  333,
    /* 140 */ 1000,  350,  667,  350,  350,  333,  333,  500,  500,  350,
    /* 150 */  500, 1000,  333, 1000,  389,  333,  722,  350,  444,  722,
    /* 160 */  250,  333,  500,  500,  500,  500,  220,  500,  333,  747,
    /* 170 */  300,  500,  570,  333,  747,  333,  333,  570,  300,  300,
    /* 180 */  333,  556,  540,  250,  333,  300,  330,  500,  750,  750,
    /* 190 */  750,  500,  722,  722,  722,  722,  722,  722, 1000,  722,
    /* 200 */  667,  667,  667,  667,  389,  389,  389,  389,  722,  722,
    /* 210 */  778,  778,  778,  778,  778,  570,  778,  722,  722,  722,
    /* 220 */  722,  722,  611,  556,  500,  500,  500,  500,  500,  500,
    /* 230 */  722,  444,  444,  444,  444,  444,  278,  278,  278,  278,
    /* 240 */  500,  556,  500,  500,  500,  500,  500,  570,  500,  556,
    /* 250 */  556,  556,  556,  500,  556,  500,  667,  333,  333,  333,
    /* 260 */  278,  556,  556,  167,  333,  278,  570,  333,  400 
  };

static short cwTimesItalic[] =
  {
    /*   0 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  10 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  20 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  30 */  250,  250,  250,  333,  420,  500,  500,  833,  778,  214,
    /*  40 */  333,  333,  500,  675,  250,  333,  250,  278,  500,  500,
    /*  50 */  500,  500,  500,  500,  500,  500,  500,  500,  333,  333,
    /*  60 */  675,  675,  675,  500,  920,  611,  611,  667,  722,  611,
    /*  70 */  611,  722,  722,  333,  444,  667,  556,  833,  667,  722,
    /*  80 */  611,  722,  611,  500,  556,  722,  611,  833,  611,  556,
    /*  90 */  556,  389,  278,  389,  422,  500,  333,  500,  500,  444,
    /* 100 */  500,  444,  278,  500,  500,  278,  278,  444,  278,  722,
    /* 110 */  500,  500,  500,  500,  389,  389,  278,  500,  444,  667,
    /* 120 */  444,  444,  389,  400,  275,  400,  541,  350,  500,  350,
    /* 130 */  333,  500,  556,  889,  500,  500,  333, 1000,  500,  333,
    /* 140 */  944,  350,  556,  350,  350,  333,  333,  556,  556,  350,
    /* 150 */  500,  889,  333,  980,  389,  333,  667,  350,  389,  556,
    /* 160 */  250,  389,  500,  500,  500,  500,  275,  500,  333,  760,
    /* 170 */  276,  500,  675,  333,  760,  333,  333,  675,  300,  300,
    /* 180 */  333,  500,  523,  250,  333,  300,  310,  500,  750,  750,
    /* 190 */  750,  500,  611,  611,  611,  611,  611,  611,  889,  667,
    /* 200 */  611,  611,  611,  611,  333,  333,  333,  333,  722,  667,
    /* 210 */  722,  722,  722,  722,  722,  675,  722,  722,  722,  722,
    /* 220 */  722,  556,  611,  500,  500,  500,  500,  500,  500,  500,
    /* 230 */  667,  444,  444,  444,  444,  444,  278,  278,  278,  278,
    /* 240 */  500,  500,  500,  500,  500,  500,  500,  675,  500,  500,
    /* 250 */  500,  500,  500,  444,  500,  444,  556,  333,  333,  333,
    /* 260 */  278,  500,  500,  167,  333,  278,  675,  333,  400 
  };

static short cwTimesBoldItalic[] =
  {
    /*   0 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  10 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  20 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  30 */  250,  250,  250,  389,  555,  500,  500,  833,  778,  278,
    /*  40 */  333,  333,  500,  570,  250,  333,  250,  278,  500,  500,
    /*  50 */  500,  500,  500,  500,  500,  500,  500,  500,  333,  333,
    /*  60 */  570,  570,  570,  500,  832,  667,  667,  667,  722,  667,
    /*  70 */  667,  722,  778,  389,  500,  667,  611,  889,  722,  722,
    /*  80 */  611,  722,  667,  556,  611,  722,  667,  889,  667,  611,
    /*  90 */  611,  333,  278,  333,  570,  500,  333,  500,  500,  444,
    /* 100 */  500,  444,  333,  500,  556,  278,  278,  500,  278,  778,
    /* 110 */  556,  500,  500,  500,  389,  389,  278,  556,  444,  667,
    /* 120 */  500,  444,  389,  348,  220,  348,  570,  350,  500,  350,
    /* 130 */  333,  500,  500, 1000,  500,  500,  333, 1000,  556,  333,
    /* 140 */  944,  350,  611,  350,  350,  333,  333,  500,  500,  350,
    /* 150 */  500, 1000,  333, 1000,  389,  333,  722,  350,  389,  611,
    /* 160 */  250,  389,  500,  500,  500,  500,  220,  500,  333,  747,
    /* 170 */  266,  500,  606,  333,  747,  333,  333,  570,  300,  300,
    /* 180 */  333,  576,  500,  250,  333,  300,  300,  500,  750,  750,
    /* 190 */  750,  500,  667,  667,  667,  667,  667,  667,  944,  667,
    /* 200 */  667,  667,  667,  667,  389,  389,  389,  389,  722,  722,
    /* 210 */  722,  722,  722,  722,  722,  570,  722,  722,  722,  722,
    /* 220 */  722,  611,  611,  500,  500,  500,  500,  500,  500,  500,
    /* 230 */  722,  444,  444,  444,  444,  444,  278,  278,  278,  278,
    /* 240 */  500,  556,  500,  500,  500,  500,  500,  570,  500,  556,
    /* 250 */  556,  556,  556,  444,  500,  444
  };

static short cwCourier[] =
  {
    /*   0 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  10 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  20 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  30 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  40 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  50 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  60 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  70 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  80 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /*  90 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 100 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 110 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 120 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 130 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 140 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 150 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 160 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 170 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 180 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 190 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 200 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 210 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 220 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 230 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 240 */  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
    /* 250 */  600,  600,  600,  600,  600,  600
  };

static short cwSymbol[] =
  {
    /*   0 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  10 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  20 */  250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
    /*  30 */  250,  250,  250,  333,  713,  500,  549,  833,  778,  439,
    /*  40 */  333,  333,  500,  549,  250,  549,  250,  278,  500,  500,
    /*  50 */  500,  500,  500,  500,  500,  500,  500,  500,  278,  278,
    /*  60 */  549,  549,  549,  444,  549,  722,  667,  722,  612,  611,
    /*  70 */  763,  603,  722,  333,  631,  722,  686,  889,  722,  722,
    /*  80 */  768,  741,  556,  592,  611,  690,  439,  768,  645,  795,
    /*  90 */  611,  333,  863,  333,  658,  500,  500,  631,  549,  549,
    /* 100 */  494,  439,  521,  411,  603,  329,  603,  549,  549,  576,
    /* 110 */  521,  549,  549,  521,  549,  603,  439,  576,  713,  686,
    /* 120 */  493,  686,  494,  480,  200,  480,  549,    0,    0,    0,
    /* 130 */    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 140 */    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 150 */    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 160 */    0,  620,  247,  549,  167,  713,  500,  753,  753,  753,
    /* 170 */  753, 1042,  987,  603,  987,  603,  400,  549,  411,  549,
    /* 180 */  549,  713,  494,  460,  549,  549,  549,  549, 1000,  603,
    /* 190 */ 1000,  658,  823,  686,  795,  987,  768,  768,  823,  768,
    /* 200 */  768,  713,  713,  713,  713,  713,  713,  713,  768,  713,
    /* 210 */  790,  790,  890,  823,  549,  250,  713,  603,  603, 1042,
    /* 220 */  987,  603,  987,  603,  494,  329,  790,  790,  786,  713,
    /* 230 */  384,  384,  384,  384,  384,  384,  494,  494,  494,  494,
    /* 240 */    0,  329,  274,  686,  686,  686,  384,  384,  384,  384,
    /* 250 */  384,  384,  494,  494,  494,    0
  };

static short cwZapfDingbats[] =
  {
    /*   0 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /*  10 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /*  20 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /*  30 */       0,    0,  278,  974,  961,  974,  980,  719,  789,  790,
    /*  40 */     791,  690,  960,  939,  549,  855,  911,  933,  911,  945,
    /*  50 */     974,  755,  846,  762,  761,  571,  677,  763,  760,  759,
    /*  60 */     754,  494,  552,  537,  577,  692,  786,  788,  788,  790,
    /*  70 */     793,  794,  816,  823,  789,  841,  823,  833,  816,  831,
    /*  80 */     923,  744,  723,  749,  790,  792,  695,  776,  768,  792,
    /*  90 */     759,  707,  708,  682,  701,  826,  815,  789,  789,  707,
    /* 100 */     687,  696,  689,  786,  787,  713,  791,  785,  791,  873,
    /* 110 */     761,  762,  762,  759,  759,  892,  892,  788,  784,  438,
    /* 120 */     138,  277,  415,  392,  392,  668,  668,    0,    0,    0,
    /* 130 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 140 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 150 */       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    /* 160 */       0,  732,  544,  544,  910,  667,  760,  760,  776,  595,
    /* 170 */     694,  626,  788,  788,  788,  788,  788,  788,  788,  788,
    /* 180 */     788,  788,  788,  788,  788,  788,  788,  788,  788,  788,
    /* 190 */     788,  788,  788,  788,  788,  788,  788,  788,  788,  788,
    /* 200 */     788,  788,  788,  788,  788,  788,  788,  788,  788,  788,
    /* 210 */     788,  788,  894,  838, 1016,  458,  748,  924,  748,  918,
    /* 220 */     927,  928,  928,  834,  873,  828,  924,  924,  917,  930,
    /* 230 */     931,  463,  883,  836,  836,  867,  867,  696,  696,  874,
    /* 240 */       0,  874,  760,  946,  771,  865,  771,  888,  967,  888,
    /* 250 */     831,  873,  927,  970,  918,    0
  };

static const struct wxCoreFontDesc
{
  const wxChar* id;
  const wxChar* name;
  short*        cwArray;
  const wxChar* bbox;
  int           ascent;
  int           descent;
  int           capHeight;
  int           flags;
  int           italicAngle;
  int           stemV;
  int           missingWidth;
  int           xHeight;
  int           underlinePosition;
  int           underlineThickness;
}

//ascent, descent, int capHeight, flags, const wxString &fontBBox, italicAngle, stemV, missingWidth)

wxCoreFontTable[] =
{
  { wxT("courier"),      wxT("Courier"),               cwCourier,              wxT("[-166 -225 1000 931]"),  629, -157, 562, 0, 0,   0, 600, 426, -100, 50},
  { wxT("courierB"),     wxT("Courier-Bold"),          cwCourier,              wxT("[-170 -228 1003 962]"),  629, -157, 562, 0, 0,   0, 600, 439, -100, 50},
  { wxT("courierI"),     wxT("Courier-Oblique"),       cwCourier,              wxT("[-170 -225 1116 931]"),  629, -157, 562, 0, -12, 0, 600, 426, -100, 50},
  { wxT("courierBI"),    wxT("Courier-BoldOblique"),   cwCourier,              wxT("[-174 -228 1114 962]"),  629, -157, 562, 0, -12, 0, 600, 439, -100, 50},
  { wxT("helvetica"),    wxT("Helvetica"),             cwHelvetica,            wxT("[-168 -218 1000 898]"),  718, -207, 718, 0, 0,   0, 278, 523, -100, 50},
  { wxT("helveticaB"),   wxT("Helvetica-Bold"),        cwHelveticaBold,        wxT("[-168 -218 1000 935]"),  718, -207, 718, 0, 0,   0, 278, 532, -100, 50},
  { wxT("helveticaI"),   wxT("Helvetica-Oblique"),     cwHelveticaOblique,     wxT("[-169 -217 1010 883]"),  718, -207, 718, 0, -12, 0, 278, 523, -100, 50},
  { wxT("helveticaBI"),  wxT("Helvetica-BoldOblique"), cwHelveticaBoldOblique, wxT("[-200 -218 996 921]"),   718, -207, 718, 0, -12, 0, 278, 532, -100, 50},
  { wxT("times"),        wxT("Times-Roman"),           cwTimesRoman,           wxT("[-168 -218 1000 898]"),  683, -217, 662, 0, 0,   0, 250, 450, -100, 50},
  { wxT("timesB"),       wxT("Times-Bold"),            cwTimesBold,            wxT("[-113 -250 749 801]"),   683, -217, 676, 0, 0,   0, 250, 461, -100, 50},
  { wxT("timesI"),       wxT("Times-Italic"),          cwTimesItalic,          wxT("[-28 -250 742 805]"),    683, -217, 653, 0, -16, 0, 250, 441, -100, 50},
  { wxT("timesBI"),      wxT("Times-BoldItalic"),      cwTimesBoldItalic,      wxT("[-56 -250 868 801]"),    683, -217, 669, 0, -15, 0, 250, 462, -100, 50},
  { wxT("symbol"),       wxT("Symbol"),                cwSymbol,               wxT("[-180 -293 1090 1010]"), 600, -200, 600, 0, 0,   0, 0,   450, -100, 50},
  { wxT("zapfdingbats"), wxT("ZapfDingbats"),          cwZapfDingbats,         wxT("[-1 -143 981 820]"),     806, -198, 705, 0, 0,   0, 278, 705, -205, 123},
// Last dummy entry
  { wxEmptyString,       wxEmptyString,                NULL,                   wxEmptyString,                0,   0,    0,   0, 0,   0,      0,   0   }
};

