/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <clutk/clutk.h>

enum {
        TARGET_INT32,
        TARGET_STRING,
        TARGET_ROOTWIN
};

/* datatype (string), restrictions on DnD (GtkTargetFlags), datatype (int) */
static GtkTargetEntry target_list[] = {
        { "INTEGER",    0, TARGET_INT32 },
        { "STRING",     0, TARGET_STRING },
        { "text/plain", 0, TARGET_STRING },
        { "application/x-rootwindow-drop", 0, TARGET_ROOTWIN }
};

static guint n_targets = G_N_ELEMENTS (target_list);

void test_destination (void)
{
  GtkWidget *window;
  ClutterActor *stage;
  CtkActor *drag_dest_actor;
  GtkWidget *vbox, *clutter_embed;
  
  /* setup our window */  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  vbox = gtk_vbox_new(FALSE, 6);
  gtk_container_add(GTK_CONTAINER(window), vbox);

  /* make the clutterembed widget and add it to our vbox */
  clutter_embed = gtk_clutter_embed_new();
  gtk_widget_set_size_request(clutter_embed, 800, 600);
  gtk_container_add(GTK_CONTAINER(vbox), clutter_embed);
  stage = gtk_clutter_embed_get_stage(GTK_CLUTTER_EMBED(clutter_embed));
  
  ctk_dnd_init (clutter_embed, target_list, n_targets);

  drag_dest_actor = CTK_ACTOR (ctk_image_new(64));
  ctk_image_set_from_stock (CTK_IMAGE (drag_dest_actor), GTK_STOCK_EDIT);

  ctk_drag_dest_start (drag_dest_actor);
  
  g_assert (ctk_drag_dest_is_dest (drag_dest_actor));
}

void
test_dnd_create_suite (void)
{
#define DOMAIN "/DND"

  g_test_add_func (DOMAIN"/Destination", test_destination);

}
