/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jay.taoko@canonical.com>
 *              Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */
#ifndef _CTK_UTILS_H_
#define _CTK_UTILS_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-render-target.h>
#include <clutk/ctk-effect-context.h>

G_BEGIN_DECLS

#define CHECKGL( GLcall )                     \
  {                                           \
      GLcall;                                 \
      if(1)                                   \
      CheckGLError( (#GLcall), __FILE__, __LINE__ );   \
  }

#define CHECKGL_MSG( msg )                    \
  {                                           \
      if(1)                                   \
      CheckGLError( (#msg), __FILE__, __LINE__  );      \
  }

gint CheckGLError (const gchar *glCall, const gchar *file, gint line);

G_END_DECLS

#endif /* _CTK_UTILS_H_ */

