#!/usr/bin/env python

########################################################################
#    Chris's Lame File Browser 4 (Preference File Reader)
#    Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#######################################################################

import os, os.path, re, string, sys, shutil
from xml.dom import minidom
import gtk, gtk.gdk, pango

CONFIG_DIRECTORY = os.path.abspath(string.replace(sys.argv[0], "claw4.py", "config/"))

def read():
	'''This function reads the preferences.xml file and returns it's contents'''

	# Check to see if the preferences.xml file exists
	if not os.path.exists(os.environ['HOME'] + "/.claw/preferences.xml"):
		try:
			# If the ~/.claw/ directory is missing, make it
			if not os.path.exists(os.environ['HOME'] + "/.claw"):
				try:
					os.mkdir(os.environ['HOME'] + "/.claw")
				except:

					# If we can't make the .claw directory, then we have serious issues
					print "ERROR: You don't have permission to write to you home directory?!! You need to seriously fix this."
					gtk.main_quit()
					
			# If the preferences file is missing, copy the default one to ~/.claw/
			if os.path.exists(CONFIG_DIRECTORY + "/preferences.xml"):
				shutil.copy(CONFIG_DIRECTORY + "/preferences.xml", os.environ['HOME'] + "/.claw/preferences.xml")
			else:
				print "ERROR: I can't seem to find the preferences.xml file in the installation."
				gtk.main_quit()
		except:

			# If nothing works, we're screwed
			print "ERROR: Cannot Open Preferences file, and I don't know why"
			return 1

	# Try to parse the preferences file (using the built-in python XML reader)
	try:
		perferences_file = minidom.parse(os.environ['HOME'] + "/.claw/preferences.xml")
	except:
		print "ERROR: I can't read the ~/.claw/preferences.xml file!"
		return []

	# At this point, the preferences file is open, and we can extract information from it

	# Let's set a list of items we expect to find in the file
	preference_items = ["termcmd", "audio_previews", "image_previews","inline_image_previews", "image_preview_size",  "font", "font_color", "bg_color", "archive", "theme", "single_click"]	
	preferences = []

	# Get the information from the xml (DOM) tree
	for item in preference_items:
		node = perferences_file.getElementsByTagName(item)
		preferences.append(node[0].childNodes[0].data)

	return preferences


def set(tab, preferences):
	'''This function sets the preferences and allows you to change them one at a time'''

	if preferences[1] == "True":
		tab.play_audio_previews = True
	else:
		tab.play_audio_previews = False

	if preferences[2] == "True":
		tab.show_picture_preview = True
	else:
		tab.show_picture_preview = False			

	if preferences[3] == "True":
		tab.inline_picture_preview = True
	else:
		tab.inline_picture_preview = False

	tab.image_max_size = int(preferences[4])
	tab.font = pango.FontDescription(preferences[5])

	colors = string.split(preferences[6], ",")
	tab.font_color = gtk.gdk.Color(int(colors[0]), int(colors[1]), int(colors[2]), int(colors[3]))

	colors = string.split(preferences[7], ",")
	tab.bg_color = gtk.gdk.Color(int(colors[0]), int(colors[1]), int(colors[2]), int(colors[3]))
	
	tab.archive_command = preferences[8]

	tab.theme = preferences[9]
	
	if preferences[10] == "True":
		tab.single_click = True
	else:
		tab.single_click = False

########################################################################
# This function reads the translation file for the selected language
########################################################################
def getLanguage(Claw3, language):

	languageFile =minidom.parse(Claw3.CONFIG_DIRECTORY + "translations/" + language + ".trans")
	
	language = {}

	tags = languageFile.childNodes
	parentNodes = tags[-1].childNodes
	parentNodes = filter(lambda node: string.strip(node.toxml()) != "", parentNodes)

	for nodes in parentNodes:
		nodes = filter(lambda node: string.strip(node.toxml()) != "", nodes.childNodes)
		for node in nodes:
			language[node.tagName] = [node.childNodes[0].data,  node.getAttribute("tip")]

	Claw3.messages=language
	
	
