#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Creates the Toolbar for the Main Widget)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import string, os, os.path, re, sys, shutil
import pygtk, gtk
from xml.dom import minidom

CONFIG_LOCATION = os.path.abspath(string.replace(sys.argv[0],"claw4.py","") + "config")
IMAGE_DIRECTORY = os.path.abspath(string.replace(sys.argv[0],"claw4.py","") + "Images")
HOME_DIRECTORY =  os.path.abspath(string.replace(sys.argv[0],"claw4.py",""))

global history
history = {}

class create:
	def __init__(self, Notebook):
		'''This class creates the toolbar for the main widget. '''
		self.Notebook = Notebook
		self.main_notebook = Notebook.main_notebook
		
		# Create the handle box and tool bar widgets	
		self.handle_box = gtk.HandleBox()
		tool_bar = gtk.Toolbar()
		tool_bar.set_style(gtk.TOOLBAR_BOTH)
		self.handle_box.add(tool_bar)

		# Parse the menu.xml file		
		button_info = self.__readMenuFile__()
	
		# Create the buttons
		button_images=self.__createButtons__(button_info)
	
		# Populate the Toolbar
		self.__populateToolbar__(tool_bar, button_images, button_info)


	def __readMenuFile__(self):
		'''This function reads the config/toolbar.xml file in order to create the tool
		bar buttons.'''

		menu_file = minidom.parse(CONFIG_LOCATION + "/toolbar.xml")
		tags = menu_file.childNodes
		parentNodes = tags[-1].childNodes
		parentNodes = filter(lambda node: string.strip(node.toxml()) != "", parentNodes)
		button_info = []
		for node in parentNodes:
			button_info.append([node.childNodes[0].data, node.getAttribute("name"), node.getAttribute("icon")])

		'''
		button_lines = file(CONFIG_LOCATION + "/toolbar.xml", "r").readlines()
		for line in button_lines:
			if re.findall("\".*?\"", line) != []:
				icon, title = re.findall("\".*?\"", line)
				icon = string.replace(icon, "\"", "")
				title = string.replace(title, "\"", "")
				tip = string.replace(re.findall(">.*?<", line)[0], ">","")
				tip = string.replace(tip, "<", "")
				button_info.append([tip, icon, title])
		'''

		return button_info

	def __createButtons__(self, button_info):
		'''This function creates the button images for the toobar.'''
	
		button_images = []
		for button in button_info:
			button_image_name = button[2]
			button_image = gtk.Image()
			button_image.set_from_file(IMAGE_DIRECTORY + "/Toolbar/" + button_image_name)

			button_images.append(button_image)
	
		return button_images
	
	def __populateToolbar__(self, tool_bar, button_images, button_info):
		'''The function adds the buttons to the toolbar'''

		button_tooltips = gtk.Tooltips()
		button_tooltips.enable()

		for x in range(len(button_images)):

			# Create a tool button
			button = gtk.ToolButton(button_images[x], button_info[x][1])

			button_tooltips.set_tip(button, button_info[x][0], tip_private=None)
			#tool_bar.set_tooltips(True)

			# Connect the button to a call back			
			self._setButtonCallback_(button, button_info[x][1])

			# Add the button to the toolbar
			tool_bar.insert(button, x)
	

	def _setButtonCallback_(self, button, button_name):
		''' This functions connects the toolbar buttons to the callbacks'''
			
		callbacks = {"Back": self.__back__,"Up":self.__up__,  "Home":self.__home__, "Reload":self.__reload__, "New Tab":self.__tab__,  "Terminal":self.__terminal__}
		button.connect("clicked", callbacks[button_name])
			
	def __back__(self, button):
		for page in self.Notebook.pages:
			if page.scroll == self.main_notebook.get_children()[self.main_notebook.get_current_page()]:
				if len(page.history) > 1:
					page.history.pop()
					page.__populate__(page.history[-1])


	def __up__(self, button):
		current_directory = os.getcwd()
		if current_directory != "/":
			parent_directory = os.path.dirname(current_directory)
			self.Notebook._populate_(parent_directory)


	def __tab__(self, button):	
		self.Notebook.newNotebookPage()


	def __home__(self, button):		
		os.chdir(os.environ['HOME'])
		self.Notebook._populate_(os.environ['HOME'])


	def __reload__(self, button):
		self.Notebook._populate_(os.getcwd())

	def __terminal__(self, button):
		
		# Parse the preferences.xml file and get the terminal command
		preference_file = minidom.parse(os.environ['HOME'] + "/.claw/preferences.xml")
		node = preference_file.getElementsByTagName("termcmd")
		termcmd=node[0].childNodes[0].data
		os.popen2(termcmd)
		
		'''
		preference_lines = file(os.environ['HOME'] + "/.claw/preferences.xml", "r").readlines()
		for line in preference_lines:
			if re.findall("termcmd", line) != []:
				termcmd = re.findall(">.*?<", line)[0]
				termcmd = string.replace(termcmd, ">", "")
				termcmd = string.replace(termcmd, "<", "")
				os.popen2(termcmd)
		'''
