;;; -*- Lisp -*-
;;;
;;; Screamer - an extension of Common Lisp that adds support for
;;; nondeterministic programming

(defpackage #:screamer-system (:use #:asdf #:cl))
(in-package #:screamer-system)

(defclass file-warn-only (cl-source-file) ())

(defmethod perform :around ((op compile-op) (c file-warn-only))
  (setf (operation-on-failure op) :warn)
  (call-next-method))

(defsystem screamer
    :depends-on (cl-plus)
    :components
    ((:file "screamer")
     (:file "iterate")
     (:file "primordial" :depends-on ("iterate" "screamer"))
     ;;Permit four Duplicate definition warnings generated by SBCL
     (file-warn-only "screams" :depends-on ("iterate" "screamer"))
     (:file "equations" :depends-on ("iterate" "screamer")))
    
    :perform (compile-op :after (op c)
			 (print (funcall (intern
					  "PRIME-ORDEAL" "PRIMORDIAL")))))
