/*-----------------------------------------------------------------------------

  File        : odykill.cpp

  Description : Simple shoot-em-up game featuring the Robotvis/Odyssee Team !

  Copyright  : David Tschumperle - http://www.greyc.ensicaen.fr/~dtschump/

  This software is governed by the CeCILL  license under French law and
  abiding by the rules of distribution of free software.  You can  use,
  modify and/ or redistribute the software under the terms of the CeCILL
  license as circulated by CEA, CNRS and INRIA at the following URL
  "http://www.cecill.info".

  As a counterpart to the access to the source code and  rights to copy,
  modify and redistribute granted by the license, users are provided only
  with a limited warranty  and the software's author,  the holder of the
  economic rights,  and the successive licensors  have only  limited
  liability.

  In this respect, the user's attention is drawn to the risks associated
  with loading,  using,  modifying and/or developing or reproducing the
  software by the user in light of its specific status of free software,
  that may mean  that it is complicated to manipulate,  and  that  also
  therefore means  that it is reserved for developers  and  experienced
  professionals having in-depth computer knowledge. Users are therefore
  encouraged to load and test the software's suitability as regards their
  requirements in conditions enabling the security of their systems and/or
  data to be ensured and,  more generally, to use and operate it in the
  same conditions as regards security.

  The fact that you are presently reading this means that you have had
  knowledge of the CeCILL license and that you accept its terms.

  --------------------------------------------------------------------------*/

#include "../CImg.h"
using namespace cimg_library;
// The undef below is necessary when using a non-standard compiler.
#ifdef cimg_use_visualcpp6
#define std
#endif

int main(int argc,char **argv) {

  // Load game graphics
  CImg<unsigned char> graphics[21] = {
    CImg<unsigned char>("img/tomato.bmp"),
    CImg<unsigned char>("img/heart.bmp"),
    CImg<unsigned char>("img/dynamite.bmp"),
    CImg<unsigned char>("img/brain.bmp"),
    CImg<unsigned char>("img/cdrom.bmp"),
    CImg<unsigned char>("img/enemy.bmp"),
    CImg<unsigned char>("img/enemy2.bmp"),
    CImg<unsigned char>("img/enemy3.bmp"),
    CImg<unsigned char>("img/enemy4.bmp"),
    CImg<unsigned char>("img/enemy5.bmp"),
    CImg<unsigned char>("img/enemy6.bmp"),
    CImg<unsigned char>("img/enemy7.bmp"),
    CImg<unsigned char>("img/enemy8.bmp"),
    CImg<unsigned char>("img/enemy9.bmp"),
    CImg<unsigned char>("img/enemy10.bmp"),
    CImg<unsigned char>("img/enemy11.bmp"),
    CImg<unsigned char>("img/enemy12.bmp"),
    CImg<unsigned char>("img/enemy13.bmp"),
    CImg<unsigned char>("img/enemy14.bmp"),
    CImg<unsigned char>("img/enemy15.bmp"),
    CImg<unsigned char>("img/enemy16.bmp"),
  };
  CImg<> masks[21];
  for (unsigned int k=0; k<5; k++) graphics[k].resize(100,100,1,3,1);
  const unsigned char black[3] = { 0,0,0 }, white[3] = { 255,255,255 };

  // Display weapon selection menu
  CImg<unsigned char> back0(640,480,1,3), title("img/title.bmp"), choose("img/choose.bmp");
  back0.fill(0).draw_image(title,back0.dimx()/2-title.dimx()/2,30).draw_image(choose,back0.dimx()/2-choose.dimx()/2,150);
  CImgDisplay disp(back0,"OdyKill",0,3);
  int weapon=-1;

  while(!disp.button && !disp.is_closed) {
    weapon = -1;
    for (int k=0; k<5; k++) {
      const int mx = disp.mouse_x, my = disp.mouse_y;
      if (!((mx-40)/110==k && my>250 && my<350)) back0.draw_image(graphics[k]/2,40+k*110,250);
      else back0.draw_image(graphics[weapon=k],40+k*110,250);
    }
    CImg<unsigned char> tmp = CImg<unsigned char>().draw_text(0,0,white,black,32,1.0f,
							      weapon==0?" Tomato   ":
							      weapon==1?"  Heart   ":
							      weapon==2?" Dynamite ":
							      weapon==3?"  Brain   ":
							      weapon==4?"  CD-Rom  ":
							      "          ").resize(-100,-100,1,1),
      tmp2 = tmp.get_blur(6).normalize(0,255).draw_image(tmp,0,0,0,0,0.5f);
    { cimg_forV(back0,k) back0.draw_image(tmp2,250,390,0,k); }

    disp.resize(disp).display(back0).wait();
    if (disp.is_typed(cimg::keyCTRLLEFT,cimg::keyF)) disp.toggle_fullscreen();
    if (disp.is_closed || disp.key==cimg::keyQ || disp.key==cimg::keyESC) std::exit(0);
  }
  disp.hide_mouse();

  /*---------------------------------

  Go !

  --------------------------------*/

  const CImg<unsigned char>
    background = CImg<unsigned char>(100,100,1,3,0).noise(100,2).draw_plasma(0,0,99,99).
    resize(back0.dimx(),back0.dimy(),1,3,5)/2.5f;
  { for (unsigned int k=0; k<21; k++) {
    CImg<> tmp = graphics[k].resize(k<5?32:164,k<5?32:164,1,3);
    cimg_forXY(tmp,x,y) tmp(x,y)  = (tmp(x,y,0)==255 && tmp(x,y,1)==255 && tmp(x,y,2)==255)?0.0f:1.0f;
    masks[k]=tmp.get_shared_channel(0);
    graphics[k].resize(k<5?32:164,k<5?32:164,1,3,5);
  }}

  CImg<unsigned char> canvas(background);
  int n = 5+((int)(200*cimg::rand())%16);
  CImg<unsigned char> tomato = graphics[weapon], enemy = graphics[n];
  CImg<> m_tomato = masks[weapon], m_enemy = masks[n];

  double angle=0;
  int tomato_x=0,tomato_y=0,shooted=0;
  double enemy_x=-1000, enemy_y=-1000, enemy_z=-1000, tomato_z = 0, vx = 0, vy = 0, vz = 0, va = 0;
  double speed = cimg_option("-speed",5.0,"Speed");
  int timeleft = 2000, score = 0;
  CImg<unsigned char> r_enemy;

  // Main loop
  while(timeleft && !disp.is_closed && disp.key!=cimg::keyESC && disp.key!=cimg::keyQ) {
    timeleft--;
    const int mx = disp.mouse_x*back0.dimx()/disp.dimx(), my = disp.mouse_y*back0.dimy()/disp.dimy();

    // Handle object motion
    if (tomato_z>0) {
      tomato_z+=0.07; tomato_y -= (int)(20*std::cos(cimg::PI/7 + tomato_z*cimg::PI));
      if (tomato_z>=1) { tomato_z=0; tomato_x = mx; tomato_y = my; }
    }
    if (!shooted) {
      enemy_x +=vx;
      enemy_y +=vy;
      enemy_z +=vz;
    }
    else {
      va = 10;
      enemy_y += vy;
      vy += 2;
      tomato_z = 0;
      if (enemy_y>5*canvas.dimy()/4) {
        shooted = 0;
        int n = 5 + ((int)(200*cimg::rand())%16);
        enemy = graphics[n];
        m_enemy = masks[n];
        enemy_x=cimg::crand()*1e8; enemy_y=cimg::crand()*1e8; enemy_z=cimg::crand()*1e8;
        va = angle = 0;
      }
    }

    if (enemy_x<0) { enemy_x=0; vx = speed*cimg::crand(); }
    if (enemy_x>canvas.dimx()) { enemy_x=canvas.dimx(); vx = speed*cimg::crand(); }
    if (enemy_y<0) { enemy_y=0; vy = speed*cimg::crand(); }
    if (!shooted && enemy_y>canvas.dimy()) { enemy_y=canvas.dimy(); vy = speed*cimg::crand(); }
    if (enemy_z<0.1) { enemy_z = 0.1; vz = speed*0.01*cimg::crand(); }
    if (enemy_z>0.7) { enemy_z = 0.7; vz = speed*0.01*cimg::crand(); }
    angle+=va;

    // Handle mouse interaction
    if (!disp.button) {
      if (tomato_z==0) {
        tomato_x = mx; tomato_y = my;
      }
    } else tomato_z +=0.0001;

    // Detect shooting
    if (cimg::abs(tomato_z-enemy_z)<0.1) {
      if (tomato_x>enemy_x-r_enemy.dimx()/2 && tomato_x<enemy_x+r_enemy.dimx()/2 &&
      tomato_y>enemy_y-r_enemy.dimy()/2 && tomato_y<enemy_y+r_enemy.dimy()/2) {
        score++;
        shooted = 1;
      }
    }

    // Draw into canvas
    canvas = background;
    r_enemy = enemy.get_resize((int)(8+enemy.dimx()*(1-enemy_z)),(int)(8+enemy.dimy()*(1-enemy_z)),-100,-100);
    CImg<> rm_enemy = m_enemy.get_resize(r_enemy.dimx(),r_enemy.dimy());
    CImg<unsigned char> r_tomato  = tomato.get_resize((int)(8+tomato.dimx()*(1-tomato_z)),(int)(8+tomato.dimy()*(1-tomato_z)),-100,-100);
    CImg<> rm_tomato = m_tomato.get_resize(r_tomato.dimx(),r_tomato.dimy());

    if (angle!=0) { r_enemy.rotate((float)angle,0); rm_enemy.rotate((float)angle,0); cimg_forXY(r_enemy,x,y) r_enemy(x,y,0) = (r_enemy(x,y,0)+255)/2; }
    r_enemy*=(1-(enemy_z-0.1)/1.6);
    r_tomato*=(1-tomato_z/1.6);
    rm_enemy*=(1-(enemy_z-0.1)/1.6);

    if (enemy_z>tomato_z) {
      canvas.draw_image(r_enemy,rm_enemy,(int)(enemy_x-r_enemy.dimx()/2),(int)(enemy_y-r_enemy.dimy()/2));
      if (tomato_x>=0) canvas.draw_image(r_tomato,rm_tomato,tomato_x-r_tomato.dimx()/2,tomato_y-r_tomato.dimy()/2);
    }
    else {
      if (tomato_x>=0) canvas.draw_image(r_tomato,rm_tomato,tomato_x-r_tomato.dimx()/2,tomato_y-r_tomato.dimy()/2);
      canvas.draw_image(r_enemy,rm_enemy,(int)(enemy_x-r_enemy.dimx()/2),(int)(enemy_y-r_enemy.dimy()/2));
    }
    canvas.draw_text(1,1,white,0,24,0.5f,"\r Time left %d, Score = %d",timeleft,score);
    disp.resize(disp).display(canvas).wait(25);
    if (disp.is_typed(cimg::keyCTRLLEFT,cimg::keyF)) disp.toggle_fullscreen();
  }

  std::fprintf(stderr,"\n\n YOUR SCORE : %d\n\n\n",score);

  return 0;
}
