/*
 * This file is part of the chinese-calendar project
 * Copyright (C) 2013 National University of Defense Technology(NUDT) & Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This project is developed by "UbuntuKylin Members" team,
 * see <https://launchpad.net/~ubuntukylin~members>
 * Authors: Abel Liu <guiltyritter@gmail.com>
 *                 Shine Huang <hostc@163.com>
 */

#ifndef MYCALENDAR_H
#define MYCALENDAR_H

#include <QWidget>
#include <QDate>
#include <QSystemTrayIcon>
#include <QMenu>
#include <QProcess>
#include <QGraphicsItem>
#include <QtGui>
#include <QMap>
#include <QPixmap>
#include <QSystemTrayIcon>
#include <QMenu>
#include <QAction>
#include <QActionGroup>
#include "ui_calendar.h"
#include "ccbo.h"
#include "dateitem.h"

class CCBO;
class ChineseCalendar: public QWidget, private Ui::Calendar
{
    Q_OBJECT
public:
    explicit ChineseCalendar(QWidget *parent = 0);
    virtual ~ChineseCalendar();
    QIcon icon;
private:
    void setCalendar();
    void cleardate();
    void clearbackground();
    void createTray();
    void setItemLayout();
    void resetItemLayout();

    void paintEvent(QPaintEvent *);

    bool moveable;
    bool isTall;
    QPoint dragPos;
    QDate selectedDate;
    CCBO *mycalendat;
    QMap<QString, DateItem*> *map;

    QPixmap *bg;
    QSystemTrayIcon *trayIcon;
    QMenu *trayMenu;
    QActionGroup *ag;
    QAction *actionShow, *actionStaysOnTop, *actionStaysOnBottom, *actionStaysNormal, *actionQuit;

public slots:
    void setMonth(int month);
    void setYear(QDate date);
    void setTime();
    void resetcalendardate(QString);
    void backtoday();
    void showOrHide();
    void setMode();

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

private slots:
    void on_TbnextYear_clicked();
    void on_TbnextMonth_clicked();
    void on_TbpreviousMonth_clicked();
    void on_TbpreviousYear_clicked();
};

#endif
