/*
 * This file is part of the chinese-calendar project
 * Copyright (C) 2013 National University of Defense Technology(NUDT) & Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This project is developed by "UbuntuKylin Members" team,
 * see <https://launchpad.net/~ubuntukylin~members>
 * Authors: Abel Liu <guiltyritter@gmail.com>
 *                 Shine Huang <hostc@163.com>
 */

#include "chinesecalendar.h"

ChineseCalendar::ChineseCalendar(QWidget *parent)
    : QWidget(parent)
{
    setupUi(this);

    bg = new QPixmap(":/img/chinesecalendarBGyellow.png");
    icon = QIcon(":/img/chinesecalendar.png");
    mycalendat=new CCBO;
    mycalendat->InitConnection(QDir::currentPath ());
    selectedDate = QDate::currentDate();
	monthCombo->setCurrentIndex(selectedDate.month() - 1);
    YearSelect->setDate(selectedDate);
    connect(monthCombo, SIGNAL(currentIndexChanged(int)), this, SLOT(setMonth(int)));
    connect(monthCombo, SIGNAL(activated(int)), this, SLOT(setMonth(int)));
    connect(YearSelect, SIGNAL(dateChanged(QDate)), this, SLOT(setYear(QDate)));
    connect(this->backtotoday, SIGNAL(clicked()), this, SLOT(backtoday()));

    this->TbnextMonth->setStyleSheet("QPushButton{background-color:transparent;color:rgb(200,200,150);}QPushButton:hover{color:rgb(255,255,255);}");
    this->TbnextYear->setStyleSheet("QPushButton{background-color:transparent;color:rgb(200,200,150);}QPushButton:hover{color:rgb(255,255,255);}");
    this->TbpreviousMonth->setStyleSheet("QPushButton{background-color:transparent;color:rgb(200,200,150);}QPushButton:hover{color:rgb(255,255,255);}");
    this->TbpreviousYear->setStyleSheet("QPushButton{background-color:transparent;color:rgb(200,200,150);}QPushButton:hover{color:rgb(255,255,255);}");
    this->backtotoday->setStyleSheet("QPushButton{background-color:transparent;color:rgb(200,200,150);}QPushButton:hover{color:rgb(255,255,255);}");
    this->YearSelect->setStyleSheet("QDateEdit{border: 2px solid lightgray;border-radius: 5px;}");
    this->monthCombo->setStyleSheet("QComboBox{border: 2px solid lightgray;border-radius: 5px;font:12pt;}");
    this->label->setStyleSheet("QLabel{font:12pt;}");
    this->label_2->setStyleSheet("QLabel{font:12pt;}");

    QDateTime dateTime;
    QString currentTime;
    QString week;
    dateTime = QDateTime::currentDateTime();
    if(dateTime.toString("ddd") == "Mon")
        week = "星期一";
    if(dateTime.toString("ddd") == "Tue")
        week = "星期二";
    if(dateTime.toString("ddd") == "Wed")
        week = "星期三";
    if(dateTime.toString("ddd") == "Thu")
        week = "星期四";
    if(dateTime.toString("ddd") == "Fri")
        week = "星期五";
    if(dateTime.toString("ddd") == "Sat")
        week = "星期六";
    if(dateTime.toString("ddd") == "Sun")
        week = "星期日";
    currentTime = dateTime.toString("yyyy-MM-dd %1").arg(week);
    QDate day = QDate::currentDate();
    struct CCalendar datebase;
    mycalendat->ctcl_solar_to_lunar(day.year(),day.month(),day.day(),&datebase);
    QString chinesemonth = datebase.cmonth;
    if (chinesemonth == "一月")
        chinesemonth = "正月";
    if (chinesemonth == "十一月")
        chinesemonth = "冬月";
    if (chinesemonth == "十二月")
        chinesemonth = "腊月";
    QString chineseday = QString("农历 %1%2").arg(chinesemonth).arg(datebase.cday);
    QString chineseyear = QString("%1年(%2年)").arg(datebase.ganzhi).arg(datebase.shengxiao);

    QFont font;
    QPalette pa;
    font.setPointSize(48);
    font.setBold(true);
    this->label_10->setFont(font);
    this->label_10->setText(QString::number(day.day()));
    font.setBold(false);
    font.setPointSize(9);
    this->label_12->setFont(font);
    this->label_12->setText(currentTime);
    font.setPointSize(10);
    this->label_13->setFont(font);
    this->label_13->setText(chineseday);
    this->label_14->setFont(font);
    this->label_14->setText(chineseyear);
    font.setPointSize(15);
    this->label_15->setFont(font);

    pa.setColor(QPalette::WindowText,Qt::white);
    this->label->setPalette(pa);
    this->label_2->setPalette(pa);
    this->label_15->setPalette(pa);
    this->label_4->setPalette(pa);
    this->label_5->setPalette(pa);
    this->label_6->setPalette(pa);
    this->label_7->setPalette(pa);
    this->label_8->setPalette(pa);

    pa.setColor(QPalette::WindowText,QColor(255,255,255));
    this->label_3->setPalette(pa);
    this->label_9->setPalette(pa);

    pa.setColor(QPalette::WindowText,Qt::red);
    this->label_10->setPalette(pa);
    this->label_11->setPalette(pa);
    this->label_12->setPalette(pa);
    this->label_13->setPalette(pa);
    this->label_14->setPalette(pa);

    map = new QMap<QString, DateItem *>();
    DateItem *dateitem00 = new DateItem(this);
    dateitem00->show();
    map->insert(QString("1-1"), dateitem00 );
    connect(dateitem00, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem01 = new DateItem(this);
    dateitem01->show();
    map->insert(QString("1-2"), dateitem01 );
    connect(dateitem01, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem02 = new DateItem(this);
    dateitem02->show();
    map->insert(QString("1-3"), dateitem02 );
    connect(dateitem02, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem03 = new DateItem(this);
    dateitem03->show();
    map->insert(QString("1-4"), dateitem03 );
    connect(dateitem03, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem04 = new DateItem(this);
    dateitem04->show();
    map->insert(QString("1-5"), dateitem04 );
    connect(dateitem04, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem05 = new DateItem(this);
    dateitem05->show();
    map->insert(QString("1-6"), dateitem05 );
    connect(dateitem05, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem06 = new DateItem(this);
    dateitem06->show();
    map->insert(QString("1-7"), dateitem06 );
    connect(dateitem06, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem10 = new DateItem(this);
    dateitem10->show();
    map->insert(QString("2-1"), dateitem10 );
    connect(dateitem10, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem11 = new DateItem(this);
    dateitem11->show();
    map->insert(QString("2-2"), dateitem11 );
    connect(dateitem11, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem12 = new DateItem(this);
    dateitem12->show();
    map->insert(QString("2-3"), dateitem12 );
    connect(dateitem12, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem13 = new DateItem(this);
    dateitem13->show();
    map->insert(QString("2-4"), dateitem13 );
    connect(dateitem13, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem14 = new DateItem(this);
    dateitem14->show();
    map->insert(QString("2-5"), dateitem14 );
    connect(dateitem14, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem15 = new DateItem(this);
    dateitem15->show();
    map->insert(QString("2-6"), dateitem15 );
    connect(dateitem15, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem16 = new DateItem(this);
    dateitem16->show();
    map->insert(QString("2-7"), dateitem16 );
    connect(dateitem16, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem20 = new DateItem(this);
    dateitem20->show();
    map->insert(QString("3-1"), dateitem20 );
    connect(dateitem20, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem21 = new DateItem(this);
    dateitem21->show();
    map->insert(QString("3-2"), dateitem21 );
    connect(dateitem21, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem22 = new DateItem(this);
    dateitem22->show();
    map->insert(QString("3-3"), dateitem22 );
    connect(dateitem22, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem23 = new DateItem(this);
    dateitem23->show();
    map->insert(QString("3-4"), dateitem23 );
    connect(dateitem23, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem24 = new DateItem(this);
    dateitem24->show();
    map->insert(QString("3-5"), dateitem24 );
    connect(dateitem24, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem25 = new DateItem(this);
    dateitem25->show();
    map->insert(QString("3-6"), dateitem25 );
    connect(dateitem25, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem26 = new DateItem(this);
    dateitem26->show();
    map->insert(QString("3-7"), dateitem26 );
    connect(dateitem26, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem30 = new DateItem(this);
    dateitem30->show();
    map->insert(QString("4-1"), dateitem30 );
    connect(dateitem30, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem31 = new DateItem(this);
    dateitem31->show();
    map->insert(QString("4-2"), dateitem31 );
    connect(dateitem31, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem32 = new DateItem(this);
    dateitem32->show();
    map->insert(QString("4-3"), dateitem32 );
    connect(dateitem32, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem33 = new DateItem(this);
    dateitem33->show();
    map->insert(QString("4-4"), dateitem33 );
    connect(dateitem33, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem34 = new DateItem(this);
    dateitem34->show();
    map->insert(QString("4-5"), dateitem34 );
    connect(dateitem34, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem35 = new DateItem(this);
    dateitem35->show();
    map->insert(QString("4-6"), dateitem35 );
    connect(dateitem35, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem36 = new DateItem(this);
    dateitem36->show();
    map->insert(QString("4-7"), dateitem36 );
    connect(dateitem36, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem40 = new DateItem(this);
    dateitem40->show();
    map->insert(QString("5-1"), dateitem40 );
    connect(dateitem40, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem41 = new DateItem(this);
    dateitem41->show();
    map->insert(QString("5-2"), dateitem41 );
    connect(dateitem41, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem42 = new DateItem(this);
    dateitem42->show();
    map->insert(QString("5-3"), dateitem42 );
    connect(dateitem42, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem43 = new DateItem(this);
    dateitem43->show();
    map->insert(QString("5-4"), dateitem43 );
    connect(dateitem43, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem44 = new DateItem(this);
    dateitem44->show();
    map->insert(QString("5-5"), dateitem44 );
    connect(dateitem44, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem45 = new DateItem(this);
    dateitem45->show();
    map->insert(QString("5-6"), dateitem45 );
    connect(dateitem45, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem46 = new DateItem(this);
    dateitem46->show();
    map->insert(QString("5-7"), dateitem46 );
    connect(dateitem46, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem50 = new DateItem(this);
    dateitem50->hide();
    map->insert(QString("6-1"), dateitem50 );
    connect(dateitem50, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem51 = new DateItem(this);
    dateitem51->hide();
    map->insert(QString("6-2"), dateitem51 );
    connect(dateitem51, SIGNAL(clicked(QString)), this, SLOT(resetcalendardate(QString)));

    DateItem *dateitem52 = new DateItem(this);
    dateitem52->hide();
    map->insert(QString("6-3"), dateitem52 );

    DateItem *dateitem53 = new DateItem(this);
    dateitem53->hide();
    map->insert(QString("6-4"), dateitem53 );

    DateItem *dateitem54 = new DateItem(this);
    dateitem54->hide();
    map->insert(QString("6-5"), dateitem54 );

    DateItem *dateitem55 = new DateItem(this);
    dateitem55->hide();
    map->insert(QString("6-6"), dateitem55 );

    DateItem *dateitem56 = new DateItem(this);
    dateitem56->hide();
    map->insert(QString("6-7"), dateitem56 );

    setItemLayout();
    setCalendar();

    QTimer *timer = new QTimer(this);
    timer->setInterval(1000);
    connect(timer,SIGNAL(timeout()),this,SLOT(setTime()));
    timer->start();

    QBitmap objBitmap(size());
    QPainter painter(&objBitmap);
    painter.fillRect(rect(),Qt::white);
    painter.setBrush(QColor(0,0,0));
    painter.drawRoundedRect(this->rect(),10,10);
    setMask(objBitmap);

//    Display *dis = QX11Info::display ();
//    Atom atom_task = XInternAtom(QX11Info::display (),"_NET_WM_STATE_SKIP_TASKBAR",False);
//    Atom atom =  XInternAtom(dis,"_NET_WM_STATE",False);
//    XChangeProperty(dis,winId(),atom,XA_ATOM,32,PropModeAppend,(unsigned char *)&atom_task,1);

    this->createTray();
}

ChineseCalendar::~ChineseCalendar()
{
  delete mycalendat;
}

void ChineseCalendar::createTray()
{
    this->actionShow = new QAction(tr("隐藏/显示"), this);
    connect(actionShow, SIGNAL(triggered()), this, SLOT(showOrHide()));

    this->actionStaysOnTop = new QAction(tr("总在最前"), this);
    this->actionStaysOnTop->setCheckable(true);
    connect(actionStaysOnTop, SIGNAL(triggered()), this, SLOT(setMode()));

    this->actionStaysOnBottom = new QAction(tr("总在最后"), this);
    this->actionStaysOnBottom->setCheckable(true);
    connect(actionStaysOnBottom, SIGNAL(triggered()), this, SLOT(setMode()));

    this->actionStaysNormal = new QAction(tr("普通模式"), this);
    this->actionStaysNormal->setCheckable(true);
    this->actionStaysNormal->setChecked(true);
    connect(actionStaysNormal, SIGNAL(triggered()), this, SLOT(setMode()));

    this->ag = new QActionGroup(this);
    this->ag->addAction(actionStaysOnTop);
    this->ag->addAction(actionStaysOnBottom);
    this->ag->addAction(actionStaysNormal);

    this->actionQuit = new QAction(tr("退出程序"), this);
    connect(actionQuit, SIGNAL(triggered()), qApp, SLOT(quit()));

    this->trayMenu = new QMenu(this);
    this->trayMenu->addAction(actionShow);
    this->trayMenu->addSeparator();
    this->trayMenu->addAction(actionStaysOnTop);
    this->trayMenu->addAction(actionStaysOnBottom);
    this->trayMenu->addAction(actionStaysNormal);
    this->trayMenu->addSeparator();
    this->trayMenu->addAction(actionQuit);

    this->trayIcon = new QSystemTrayIcon(this);
    this->trayIcon->setIcon(icon);
    this->trayIcon->setContextMenu(trayMenu);
    this->trayIcon->show();
}

void ChineseCalendar::paintEvent(QPaintEvent *)
{
    QPainter painter(this);
    painter.drawPixmap(0,0,width(),height(),*bg);

//    painter.setPen(Qt::gray);
    painter.setPen(QColor(255,121,3,100));

    if(!isTall)
    {
    //row
        painter.drawLine(5,108,390,108);
        painter.drawLine(5,147,390,147);
        painter.drawLine(5,186,390,186);
        painter.drawLine(5,225,390,225);
        painter.drawLine(5,264,390,264);
//        painter.drawLine(5,303,390,303);
    }
    else
    {
        painter.drawLine(5,116,390,116);
        painter.drawLine(5,163,390,163);
        painter.drawLine(5,210,390,210);
        painter.drawLine(5,257,390,257);
//        painter.drawLine(5,304,390,304);
    }
    //column
    painter.drawLine(60,69,60,303);
    painter.drawLine(115,69,115,303);
    painter.drawLine(170,69,170,303);
    painter.drawLine(225,69,225,303);
    painter.drawLine(280,69,280,303);
    painter.drawLine(335,69,335,303);
}

void ChineseCalendar::setItemLayout()
{
    if(isTall == false)
    {
        map->value("1-1")->resizeItem(55,47);
        map->value("1-2")->resizeItem(55,47);
        map->value("1-3")->resizeItem(55,47);
        map->value("1-4")->resizeItem(55,47);
        map->value("1-5")->resizeItem(55,47);
        map->value("1-6")->resizeItem(55,47);
        map->value("1-7")->resizeItem(55,47);
        map->value("2-1")->resizeItem(55,47);
        map->value("2-2")->resizeItem(55,47);
        map->value("2-3")->resizeItem(55,47);
        map->value("2-4")->resizeItem(55,47);
        map->value("2-5")->resizeItem(55,47);
        map->value("2-6")->resizeItem(55,47);
        map->value("2-7")->resizeItem(55,47);
        map->value("3-1")->resizeItem(55,47);
        map->value("3-2")->resizeItem(55,47);
        map->value("3-3")->resizeItem(55,47);
        map->value("3-4")->resizeItem(55,47);
        map->value("3-5")->resizeItem(55,47);
        map->value("3-6")->resizeItem(55,47);
        map->value("3-7")->resizeItem(55,47);
        map->value("4-1")->resizeItem(55,47);
        map->value("4-2")->resizeItem(55,47);
        map->value("4-3")->resizeItem(55,47);
        map->value("4-4")->resizeItem(55,47);
        map->value("4-5")->resizeItem(55,47);
        map->value("4-6")->resizeItem(55,47);
        map->value("4-7")->resizeItem(55,47);
        map->value("5-1")->resizeItem(55,47);
        map->value("5-2")->resizeItem(55,47);
        map->value("5-3")->resizeItem(55,47);
        map->value("5-4")->resizeItem(55,47);
        map->value("5-5")->resizeItem(55,47);
        map->value("5-6")->resizeItem(55,47);
        map->value("5-7")->resizeItem(55,47);
        map->value("6-1")->resizeItem(55,47);
        map->value("6-2")->resizeItem(55,47);
        map->value("6-3")->resizeItem(55,47);
        map->value("6-4")->resizeItem(55,47);
        map->value("6-5")->resizeItem(55,47);
        map->value("6-6")->resizeItem(55,47);
        map->value("6-7")->resizeItem(55,47);
        isTall = true;
    }
    map->value("1-1")->move(5,69);
    map->value("1-2")->move(60,69);
    map->value("1-3")->move(115,69);
    map->value("1-4")->move(170,69);
    map->value("1-5")->move(225,69);
    map->value("1-6")->move(280,69);
    map->value("1-7")->move(335,69);
    map->value("2-1")->move(5,116);
    map->value("2-2")->move(60,116);
    map->value("2-3")->move(115,116);
    map->value("2-4")->move(170,116);
    map->value("2-5")->move(225,116);
    map->value("2-6")->move(280,116);
    map->value("2-7")->move(335,116);
    map->value("3-1")->move(5,163);
    map->value("3-2")->move(60,163);
    map->value("3-3")->move(115,163);
    map->value("3-4")->move(170,163);
    map->value("3-5")->move(225,163);
    map->value("3-6")->move(280,163);
    map->value("3-7")->move(335,163);
    map->value("4-1")->move(5,210);
    map->value("4-2")->move(60,210);
    map->value("4-3")->move(115,210);
    map->value("4-4")->move(170,210);
    map->value("4-5")->move(225,210);
    map->value("4-6")->move(280,210);
    map->value("4-7")->move(335,210);
    map->value("5-1")->move(5,257);
    map->value("5-2")->move(60,257);
    map->value("5-3")->move(115,257);
    map->value("5-4")->move(170,257);
    map->value("5-5")->move(225,257);
    map->value("5-6")->move(280,257);
    map->value("5-7")->move(335,257);
    map->value("6-1")->move(5,304);
    map->value("6-2")->move(60,304);
    map->value("6-3")->move(115,304);
    map->value("6-4")->move(170,304);
    map->value("6-5")->move(225,304);
    map->value("6-6")->move(280,304);
    map->value("6-7")->move(335,304);
}

void ChineseCalendar::resetItemLayout()
{
    map->value("1-1")->resizeItem(55,39);
    map->value("1-2")->resizeItem(55,39);
    map->value("1-3")->resizeItem(55,39);
    map->value("1-4")->resizeItem(55,39);
    map->value("1-5")->resizeItem(55,39);
    map->value("1-6")->resizeItem(55,39);
    map->value("1-7")->resizeItem(55,39);
    map->value("2-1")->resizeItem(55,39);
    map->value("2-2")->resizeItem(55,39);
    map->value("2-3")->resizeItem(55,39);
    map->value("2-4")->resizeItem(55,39);
    map->value("2-5")->resizeItem(55,39);
    map->value("2-6")->resizeItem(55,39);
    map->value("2-7")->resizeItem(55,39);
    map->value("3-1")->resizeItem(55,39);
    map->value("3-2")->resizeItem(55,39);
    map->value("3-3")->resizeItem(55,39);
    map->value("3-4")->resizeItem(55,39);
    map->value("3-5")->resizeItem(55,39);
    map->value("3-6")->resizeItem(55,39);
    map->value("3-7")->resizeItem(55,39);
    map->value("4-1")->resizeItem(55,39);
    map->value("4-2")->resizeItem(55,39);
    map->value("4-3")->resizeItem(55,39);
    map->value("4-4")->resizeItem(55,39);
    map->value("4-5")->resizeItem(55,39);
    map->value("4-6")->resizeItem(55,39);
    map->value("4-7")->resizeItem(55,39);
    map->value("5-1")->resizeItem(55,39);
    map->value("5-2")->resizeItem(55,39);
    map->value("5-3")->resizeItem(55,39);
    map->value("5-4")->resizeItem(55,39);
    map->value("5-5")->resizeItem(55,39);
    map->value("5-6")->resizeItem(55,39);
    map->value("5-7")->resizeItem(55,39);
    map->value("6-1")->resizeItem(55,39);
    map->value("6-2")->resizeItem(55,39);
    map->value("6-3")->resizeItem(55,39);
    map->value("6-4")->resizeItem(55,39);
    map->value("6-5")->resizeItem(55,39);
    map->value("6-6")->resizeItem(55,39);
    map->value("6-7")->resizeItem(55,39);
    isTall = false;

    map->value("1-1")->move(5,69);
    map->value("1-2")->move(60,69);
    map->value("1-3")->move(115,69);
    map->value("1-4")->move(170,69);
    map->value("1-5")->move(225,69);
    map->value("1-6")->move(280,69);
    map->value("1-7")->move(335,69);
    map->value("2-1")->move(5,108);
    map->value("2-2")->move(60,108);
    map->value("2-3")->move(115,108);
    map->value("2-4")->move(170,108);
    map->value("2-5")->move(225,108);
    map->value("2-6")->move(280,108);
    map->value("2-7")->move(335,108);
    map->value("3-1")->move(5,147);
    map->value("3-2")->move(60,147);
    map->value("3-3")->move(115,147);
    map->value("3-4")->move(170,147);
    map->value("3-5")->move(225,147);
    map->value("3-6")->move(280,147);
    map->value("3-7")->move(335,147);
    map->value("4-1")->move(5,186);
    map->value("4-2")->move(60,186);
    map->value("4-3")->move(115,186);
    map->value("4-4")->move(170,186);
    map->value("4-5")->move(225,186);
    map->value("4-6")->move(280,186);
    map->value("4-7")->move(335,186);
    map->value("5-1")->move(5,225);
    map->value("5-2")->move(60,225);
    map->value("5-3")->move(115,225);
    map->value("5-4")->move(170,225);
    map->value("5-5")->move(225,225);
    map->value("5-6")->move(280,225);
    map->value("5-7")->move(335,225);
    map->value("6-1")->move(5,264);
    map->value("6-2")->move(60,264);
    map->value("6-3")->move(115,264);
    map->value("6-4")->move(170,264);
    map->value("6-5")->move(225,264);
    map->value("6-6")->move(280,264);
    map->value("6-7")->move(335,264);
}

void ChineseCalendar::setTime()
{
    QDateTime dateTime = QDateTime::currentDateTime();
    this->label_15->setText(dateTime.toString("hh:mm:ss"));
}

void ChineseCalendar::resetcalendardate(QString day)
{
    QDate date(this->YearSelect->date().year(),this->monthCombo->currentText().toInt(),day.toInt());
    clearbackground();
    QString weekday;
    if(date.toString("ddd") == "Mon")
        weekday = "星期一";
    if(date.toString("ddd") == "Tue")
        weekday = "星期二";
    if(date.toString("ddd") == "Wed")
        weekday = "星期三";
    if(date.toString("ddd") == "Thu")
        weekday = "星期四";
    if(date.toString("ddd") == "Fri")
        weekday = "星期五";
    if(date.toString("ddd") == "Sat")
        weekday = "星期六";
    if(date.toString("ddd") == "Sun")
        weekday = "星期日";
    QString selecttime = date.toString("yyyy-MM-dd %1").arg(weekday);
    struct CCalendar d;
    mycalendat->ctcl_solar_to_lunar(date.year(),date.month(),date.day(),&d);
    QString selectmonth = d.cmonth;
    if (selectmonth == "一月")
        selectmonth = "正月";
    if (selectmonth == "十一月")
        selectmonth = "冬月";
    if (selectmonth == "十二月")
        selectmonth = "腊月";
    QString selectday = QString("农历 %1%2").arg(selectmonth).arg(d.cday);
    QString selectyear = QString("%1年(%2年)").arg(d.ganzhi).arg(d.shengxiao);
    this->label_10->setText(day);
    this->label_12->setText(selecttime);
    this->label_13->setText(selectday);
    this->label_14->setText(selectyear);
}

void ChineseCalendar::backtoday()
{
    QDate today = QDate::currentDate();
    YearSelect->setDate(today);
    monthCombo->setCurrentIndex(today.month() - 1);
    setCalendar();

}

void ChineseCalendar::setCalendar()
{
    struct CCalendar c;
    cleardate();
    QDate date(selectedDate.year(), selectedDate.month(), 1);
    while (date.month() == selectedDate.month()) {
        int weekDay = date.dayOfWeek();
        mycalendat->ctcl_solar_to_lunar(selectedDate.year(),selectedDate.month(),date.day(),&c);
        QString mycday;
        mycday=c.cday;
        if(c.sterm.at(0) >=QChar('0') && c.sterm.at(0) <= QChar('9'))
          mycday=c.cday;
        else
        {
          if(c.laststerm)
              mycday=c.cday;
          else
              mycday=c.sterm;
        }
        int day = date.day();
        if (weekDay == 7)
            weekDay = 0;
        int row = (day + (6 - weekDay) + 7 -1)/7;
        QString site = QString("%1-%2").arg(row).arg(weekDay+1);
        map->value(site)->setday(date.day());
        map->value(site)->setcday(mycday);
        if(weekDay == 6 || weekDay == 0)
            map->value(site)->setcolor();
         date = date.addDays(1);
    }

    if (!map->value("6-1")->day().isNull())
    {
        map->value("6-1")->show();
        map->value("6-2")->show();
        map->value("6-3")->show();
        map->value("6-4")->show();
        map->value("6-5")->show();
        map->value("6-6")->show();
        map->value("6-7")->show();
        resetItemLayout();
    } 

    QDate today = QDate::currentDate();
    if(today.year() == selectedDate.year() && today.month() == selectedDate.month())
    {
        int d = today.day();
        int w = today.dayOfWeek();
        if (w == 7)
            w = 0;
        int r = (d + (6 - w) + 7 -1)/7;
        QString add = QString("%1-%2").arg(r).arg(w+1);
        resetcalendardate(QString::number(today.day()));
        map->value(add)->setToday();
    }
}

void ChineseCalendar::clearbackground()
{
    map->value("1-1")->clearstyle();
    map->value("1-2")->clearstyle();
    map->value("1-3")->clearstyle();
    map->value("1-4")->clearstyle();
    map->value("1-5")->clearstyle();
    map->value("1-6")->clearstyle();
    map->value("1-7")->clearstyle();
    map->value("2-1")->clearstyle();
    map->value("2-2")->clearstyle();
    map->value("2-3")->clearstyle();
    map->value("2-4")->clearstyle();
    map->value("2-5")->clearstyle();
    map->value("2-6")->clearstyle();
    map->value("2-7")->clearstyle();
    map->value("3-1")->clearstyle();
    map->value("3-2")->clearstyle();
    map->value("3-3")->clearstyle();
    map->value("3-4")->clearstyle();
    map->value("3-5")->clearstyle();
    map->value("3-6")->clearstyle();
    map->value("3-7")->clearstyle();
    map->value("4-1")->clearstyle();
    map->value("4-2")->clearstyle();
    map->value("4-3")->clearstyle();
    map->value("4-4")->clearstyle();
    map->value("4-5")->clearstyle();
    map->value("4-6")->clearstyle();
    map->value("4-7")->clearstyle();
    map->value("5-1")->clearstyle();
    map->value("5-2")->clearstyle();
    map->value("5-3")->clearstyle();
    map->value("5-4")->clearstyle();
    map->value("5-5")->clearstyle();
    map->value("5-6")->clearstyle();
    map->value("5-7")->clearstyle();
    map->value("6-1")->clearstyle();
    map->value("6-2")->clearstyle();
    map->value("6-3")->clearstyle();
    map->value("6-4")->clearstyle();
    map->value("6-5")->clearstyle();
    map->value("6-6")->clearstyle();
    map->value("6-7")->clearstyle();
}

void ChineseCalendar::cleardate()
{
    map->value("1-1")->clear();
    map->value("1-2")->clear();
    map->value("1-3")->clear();
    map->value("1-4")->clear();
    map->value("1-5")->clear();
    map->value("1-6")->clear();
    map->value("1-7")->clear();
    map->value("2-1")->clear();
    map->value("2-2")->clear();
    map->value("2-3")->clear();
    map->value("2-4")->clear();
    map->value("2-5")->clear();
    map->value("2-6")->clear();
    map->value("2-7")->clear();
    map->value("3-1")->clear();
    map->value("3-2")->clear();
    map->value("3-3")->clear();
    map->value("3-4")->clear();
    map->value("3-5")->clear();
    map->value("3-6")->clear();
    map->value("3-7")->clear();
    map->value("4-1")->clear();
    map->value("4-2")->clear();
    map->value("4-3")->clear();
    map->value("4-4")->clear();
    map->value("4-5")->clear();
    map->value("4-6")->clear();
    map->value("4-7")->clear();
    map->value("5-1")->clear();
    map->value("5-2")->clear();
    map->value("5-3")->clear();
    map->value("5-4")->clear();
    map->value("5-5")->clear();
    map->value("5-6")->clear();
    map->value("5-7")->clear();
    map->value("6-1")->clear();
    map->value("6-2")->clear();
    map->value("6-3")->clear();
    map->value("6-4")->clear();
    map->value("6-5")->clear();
    map->value("6-6")->clear();
    map->value("6-7")->clear();
    map->value("6-1")->hide();
    map->value("6-2")->hide();
    map->value("6-3")->hide();
    map->value("6-4")->hide();
    map->value("6-5")->hide();
    map->value("6-6")->hide();
    map->value("6-7")->hide();
    setItemLayout();
}

void ChineseCalendar::mousePressEvent(QMouseEvent *event)
{
    if (event->button() == Qt::LeftButton)
    {
        if (map->value("6-1")->isHidden())
        {
            if (event->x()>5 && event->x()<390 && event->y()>69 && event->y()<304)
                moveable = false;
            else moveable = true;
        }
        else
        {
            if (event->x()>5 && event->x()<390 && event->y()>69 && event->y()<304)
                moveable = false ;
            else moveable = true;
        }
        dragPos = event->globalPos() - frameGeometry().topLeft();
        event->accept();
    }

}

void ChineseCalendar::mouseMoveEvent(QMouseEvent *event)
{
    if (event->buttons() & Qt::LeftButton && moveable == true )
    {
        if (map->value("6-1")->isHidden())
        {
            if (event->x()>5 && event->x()<390 && event->y()>69 && event->y()<304)
                return ;
            else move(event->globalPos() - dragPos);
        }
        else
        {
            if (event->x()>5 && event->x()<390 && event->y()>69 && event->y()<304)
                return ;
            else move(event->globalPos() - dragPos);
        }
        setWindowOpacity(0.5);
    }
    event->accept();

}

void ChineseCalendar::mouseReleaseEvent(QMouseEvent *event)
{
    if (event->button() == Qt::LeftButton)
    {
        setWindowOpacity(1);
    }
    event->accept();
}

void ChineseCalendar::setMonth(int month)
{

    int day=0;
    int newmonth = month+1;
    if(newmonth<=0)
    {
        newmonth = 12;
        monthCombo->setCurrentIndex(11);
    }
    if(newmonth>12)
    {
        newmonth = 1;
    }
    if(newmonth ==1 || newmonth ==3 || newmonth == 5 || newmonth == 7 || newmonth  == 8 || newmonth == 10 || newmonth ==12)
    {
        day =31;
    }
    else if(newmonth ==4 || newmonth==6 || newmonth ==9 || newmonth ==11)
    {
       day =30;
    }
   if(selectedDate.year()%4 ==0 && selectedDate.year()%100!=0)
    {
            day = 29;
    }
    else if(selectedDate.year()%400 ==0)
    {
            day = 29;
    }
    else
    {
            day = 28;
    }
    selectedDate = QDate(selectedDate.year(),newmonth,day);
    setCalendar();
}

void ChineseCalendar::setYear(QDate date)
{
    selectedDate = QDate(date.year(), selectedDate.month(), selectedDate.day());
    setCalendar();
}

void ChineseCalendar::on_TbpreviousYear_clicked()
{
	YearSelect->setDate(selectedDate.addYears(-1));
}

void ChineseCalendar::on_TbpreviousMonth_clicked()
{
    if (monthCombo->currentIndex() == 0)
    {
        YearSelect->setDate(selectedDate.addYears(-1));
        monthCombo->setCurrentIndex(11);
    }
    else
        monthCombo->setCurrentIndex(monthCombo->currentIndex()-1);
}

void ChineseCalendar::on_TbnextMonth_clicked()
{
    if (monthCombo->currentIndex() == 11)
    {
        YearSelect->setDate(selectedDate.addYears(1));
        monthCombo->setCurrentIndex(0);
    }
    else
        monthCombo->setCurrentIndex(monthCombo->currentIndex()+1);
}

void ChineseCalendar::on_TbnextYear_clicked()
{
	YearSelect->setDate(selectedDate.addYears(1));
}

void ChineseCalendar::showOrHide()
{
    if(this->isHidden())
    {
        this->show();
    }else
        this->hide();
}

void ChineseCalendar::setMode()
{
    if(this->actionStaysOnTop->isChecked())
    {
        this->setWindowFlags(Qt::ToolTip | Qt::FramelessWindowHint);
        this->show();
    } else if(this->actionStaysOnBottom->isChecked())
    {
        this->setWindowFlags(Qt::WindowStaysOnBottomHint | Qt::FramelessWindowHint);
        this->show();
    } else
    {
        this->setWindowFlags(Qt::FramelessWindowHint);
        this->show();
    }
}
