#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "portable.h"
#include "chinese.h"
#include "vga.h"
#include "HBF_api.h"
#include "font.h"
static char *efont; 
static int cmaplen,emaplen;
/*****************************************************************
 chfp is used to record how to read a system font file if any.
 *****************************************************************/
 
static struct {
  int empty;               /* offset of this bloc from the top of file */
  int start;               /* first font code of this block            */
  int len;                 /* number of font in this block             */
  int maplen;              /* length of font for each character        */
  FILE *fp;                /* Font FILE pointer                        */
} chfp[10];

static int chfpnum;        /* number of font block in system font file */


#define INTERNAL_FONT 0
#define HBF_FONT 1

static int FontType;
static void ReadHBFFont();
static WORD tran_code_HBF(int sys,CHAR b1,CHAR b2);
static void drawHBFFont(int x,int y,WORD code);
static char *chfontpath;
static char buf[3*24+2],buf1[24*24+2];

/************************************************************************
 FUNCTION    : load_sys_font_table
 DESCRIPTION : 
    This function is used to load all fonts used in CHDRV.  It can be loaded
 when CHDRV startup or a system reset signal is raised.
 
 MODIFIED :
    11/5/94
       Add memory release codes for reset system.

*/
               




void load_sys_font_table()
{
  char *fname;
  FILE *fp,*ffp;
  char file[255];
  int i,j,clen,cloc,len,empty,maxfont,preloadfont,emapwidth,emapheight;
  int expand_fontlen,cmapwidth,cmapheight,loadfont;
  int cmaplen;
  char *buf;
  
  /* $ parse enviroment variables */
  fname = getenv("CHFONT");
  if (fname == NULL)
    fname = CHSYS"kcfont";
  else
    fname = strdup(fname);

  SYSERR1("Font file is %s",fname);

  fp =fopen(fname,"rb");
  if (fp == NULL)
    {
      printf("Can't open %s\n",fname);
      sigquit(0);
      exit(-1);
    }
  
  fname = getenv("FONTCACHE");
  if (fname == NULL)
    maxfont = 5000;
  else
    {
      maxfont = atoi(fname);
    }

  fname = getenv("PRELOADFONT");
  if (fname == NULL)
    preloadfont = 0;
  else
    {
      preloadfont = atoi(fname);
    }

  /*$ initialize font cache */
  printf("font cache buffer is %d",maxfont);
  FontCache_init(maxfont);
  printf("Font cache initialized");
  
  if (!chdrv_is_in_startup_stage)
    if (chfontpath)
      free(chfontpath);

  chfontpath = getenv("CHFONTDIR");
  if (chfontpath == NULL)
    chfontpath = CHSYS;
  else
    chfontpath = strdup(chfontpath);
  printf("Font path is %s",chfontpath);

  /*$ load ascii font */

  fscanf(fp,"%s",file);

  /* $if {if the first line of configuration file is !!!HBF}
         We use HBF font description file
     $else
         We use system flavour font description file
     $end 
   */
         
  if (strcmp(file,"!!!HBF")==0)
    {
      FontType = HBF_FONT;
      fgets(file,255,fp);
      fscanf(fp,"%s",file);
    }
  else
    FontType = INTERNAL_FONT;

  /*$ no matter which flavour we load ascii file now */
  len = fscanf(fp,"%d %d %d\n",&empty,&emapwidth,&emapheight);
  if (len == 2)
    {
	emapheight = emapwidth;
	emapwidth = 8;
    }
  cmaplen = ((emapwidth+7)/8)*emapheight;

  buf = (char *) malloc(cmaplen*256);
  if (buf == NULL)
    {
	SYSERR("out of memory");
	sigquit(0);
	exit(0);
    }
  ffp = fopen(file,"rb");
  if (ffp == NULL)
    {
      SYSERR1("Can't open %s\n",file);
      sigquit(0);
      exit(-1);
    }
  fseek(ffp,empty,SEEK_SET);
  emaplen = mon_fontsize(emapwidth,emapheight);
  len = fread(buf,cmaplen,256,ffp);
  SYSERR("ASCII Font loaded");
  if (len != 256)
    {
      SYSERR1("English font has %d fonts ,should be 256\n",len);
      sigquit(0);
      exit(1);
    }
  fclose(ffp);

  if (!chdrv_is_in_startup_stage)
    if (efont)
      free(efont);

  efont = (char *) malloc(256*emaplen);
  if (efont == NULL)
    {
	SYSERR("out of memory");
	sigquit(0);
	exit(-1);
    }
  for(i=0;i<256;i++)
      mon_expandfont(buf+cmaplen*i,efont+emaplen*i,emapwidth,emapheight);
  free(buf);
  /* $load chinese font */
  /* $if {We choice HBF font}
          Load HBF font into memory
     $else
          Load SYstem font file by the below routine
     $end
   */

  if (FontType == HBF_FONT)
    {
	SYSERR("Load HBF font");
	ReadHBFFont(fp);
	fclose(fp);
	return;
    }
  /* $The below codes is something long and hard to read.But it is used 
      to load system font table described in document
   */
  if (!chdrv_is_in_startup_stage)
    while(chfpnum--)
      fclose(chfp[chfpnum].fp);
  loadfont = preloadfont;
  while(!feof(fp))
    {
      char mybuf[24*12];
	
      *file = 0;
      fgets(mybuf,255,fp);
      len = sscanf(mybuf,"%s %d %d %d\n",file,&empty,&cmapwidth,&cmapheight);
      /* for compatiable to previous verion */
      if (len == 3)
	{
	    cmapheight = cmapwidth;
	    cmapwidth = 16;
	}
      cmaplen = ((cmapwidth+7)/8)*cmapheight;
      if (*file == 0)
	break;

      chfp[chfpnum].fp = fopen(file,"rb");
      if (chfp[chfpnum].fp == NULL)
	{
	  SYSERR1("Can't open %s\n",file);
	  sigquit(0);
	  exit(-1);
	}
      SYSERR1("Open font file %s",file);
      fseek(chfp[chfpnum].fp,empty,SEEK_SET);
      do{
	fscanf(fp,"%d %d",&cloc,&clen);
	if (cloc == 0 && clen == 0)
	  {
	      fgets(mybuf,255,fp);
	      break;
	  }
	chfp[chfpnum].start = cloc;
	chfp[chfpnum].len = clen;
	chfp[chfpnum].empty = empty;
	chfp[chfpnum].maplen = cmaplen;
	if (cloc >= preloadfont)
	  {
	    chfp[chfpnum+1].fp = chfp[chfpnum].fp;
	    chfpnum++;
	    continue;
	  }
	
	/* should load some fonts here,but ..... */
	chfp[chfpnum+1].fp = chfp[chfpnum].fp;
	cmapwidth = ch_fontwidth()*2;
	cmapheight = ch_fontheight();
	memset(mybuf,24*12,0);
	for(i=cloc;i<cloc+clen;i++)
	  {
	    loadfont--;
	    if (loadfont == 0) break;
	    if (fread(mybuf,chfp[chfpnum].maplen,1,chfp[chfpnum].fp))
	      {
		mon_expandfont(buf,buf1,cmapwidth,cmapheight);
		FontCache_add(i,buf1,cmapwidth,cmapheight);
	      }
	  }

	chfpnum++;
	if (chfpnum == MAX_SYSTEM_TABLE)
	  {
	      SYSERR("System font table is too large,please change\n"
                      "macro MAX_SYSTEM_TABLE in chinese.c and recompiler\n");
	      break;
	  }
      } while(1);
      
    }
  fclose(fp);
}

void ch_drawctext(int x,int y,WORD code)
{
  int i,type,fontwidth,fontheight;
  char *fontdata;

#ifdef SLOW_CHECK
  if (write_to_screen<=0) return;
#endif 
  /* If font is already in cache buffer */
  fontwidth = ch_fontwidth();
  fontheight = ch_fontheight();
  
  fontdata = FontCache_find(code,&type,fontwidth*2,fontheight);
  //fontdata = NULL;
  if (fontdata != NULL)
    {
      if (type == HARDWARE)
	mon_drawcachefont(x,y*fontheight,*(int*)fontdata);
      else
	mon_drawctext(x,y*fontheight,fontdata);
      return;
    }

  /* Otherwise get from internal or HBF's scheme */
  if (FontType == HBF_FONT)
    {
      drawHBFFont(x,y,code);
      return;
    }

  for(i=0;i<chfpnum;i++)
    if ((code >= chfp[i].start) && (code < (chfp[i].start + chfp[i].len)))
      {
	/*memset(buf,0,VSCR_fontlen);*/
	memset(buf,0,2*16);
	fseek(chfp[i].fp,chfp[i].maplen*(code-chfp[i].start)+
	      chfp[i].empty,SEEK_SET);
	fread(buf,chfp[i].maplen,1,chfp[i].fp);
	break;
      }
  if (i != chfpnum)
    {
      mon_expandfont(buf,buf1,fontwidth*2,fontheight);
      FontCache_add(code,buf1,fontwidth*2,fontheight);
      mon_drawctext(x,y*fontheight,buf1);
    }
}


void ch_drawtext(int x,int y,CHAR c)
{
#ifdef SLOW_CHECK
  if (write_to_screen<=0) return;
#endif
  mon_drawtext(x,y*ch_fontheight(),efont+c*emaplen);
}

/* the transform rule is some bug now.I must be debug future */
WORD tran_code(int sys,CHAR b1,CHAR b2)
{
  WORD code;
  
  if (FontType == HBF_FONT)
    return tran_code_HBF(sys,b1,b2);
  switch(sys)
    {
    case CODE_BIG5:
      if (b2 < 0x40)
	return 0xffff;
      else if (b2 <0x7f)
	code = b2 - 0x40;
      else if (b2 < 0xa1)
	return 0xffff;
      else if (b2 < 0xff)
	code = b2 - 0xa1 + 0x3f;
      
      if (b1 < 0x81)
	return 0xffff;
      else if (b1 <= 0x8d)
	code += 0xeeb8 - 0x8001 + (b1 - 0x81)*157;
      else if (b1 <= 0xa0)
	code += 0xe311 - 0x8001 + (b1 - 0x8e)*157;
      else if (b1 <= 0xa3)
	code += 0x8400 - 0x8001 + (b1 - 0xa1)*157;
      else if (b1 < 0xc6)
	code += 0x8800 - 0x8001 + (b1 - 0xa4)*157;
      else if (b1 == 0xc6)
	{
	  if (b2 < 0x7f)
	    code += 0x8800 - 0x8001 + (b1 - 0xa4)*157;
	  else
	    code = 0x8001 - 0x8001 + (b2 -0xa1);
	}
      else if (b1 <= 0xc8)
	code += 0x803f - 0x8001 + (b1 - 0xc7)*157;
      else if (b1 <= 0xf9)
	code += 0x9d19 - 0x8001 + (b1 -0xc9)*157;
      else if (b1 <= 0xfe)
	code += 0xe000 -0x8001 + (b1 - 0xfa)*157;
      else
	return 0xffff;
      break;
    default:
      code = 0xffff;
    }
/*
  if (code > 14000)
    {
      code = 0xffff;
    }
*/
  return code;
}


static HBF *hbf;  

static void ReadHBFFont(FILE *fp)
{
  char buf[100],*tok;
  int ptr,i;

  fgets(buf,100,fp);
  tok = strtok(buf," \t\n");
  SYSERR1("Open HBF font %s\n",tok);  
  hbf = HBF_OpenFont(tok);

  if (hbf == NULL) {
    SYSERR("HBF font open error\n");
    return;
  }
  SYSERR1("Number of code ranges is %d\n",hbf->numcoderange);
  hbf->chfp = (FILE **) malloc(sizeof(FILE *)*hbf->numcoderange);
  for(i=0;i<hbf->numcoderange;i++)
    {
      SYSERR1("Open font %s\n",hbf->chfile[i]);
      strcpy(buf,chfontpath);
      strcat(buf,hbf->chfile[i]);
      hbf->chfp[i] = fopen(buf,"r");
      if (hbf->chfp[i] == NULL)
	{
	  SYSERR1("Font file %s can't open\n",buf);
	  continue;
	}
      fseek(hbf->chfp[i],hbf->chlen[i],SEEK_SET);
    }
  SYSERR("HBF font opened\n");
}

static WORD tran_code_HBF(int sys,CHAR b1,CHAR b2)
{
  int i;
  WORD code;
  WORD ch;
  ch = (b1 <<8)+b2;

  for(i=0;i<hbf->numcoderange;i++)
    if (ch >= hbf->coderange[i*2] && ch <= hbf->coderange[i*2+1])
      break;
  if (i == hbf->numcoderange)
    {
      return 0xffff;
    }
  else
    {
      CHAR c1 = hbf->coderange[i*2]/256;
      CHAR c2 = hbf->coderange[i*2]%256;
      return hbf->codestart[i]+(b1-c1)*hbf->charsofline+
	    (hbf->b2tran[b2]-hbf->b2tran[c2]);
    }
}

static void drawHBFFont(int x,int y,WORD code)
{
  int i,fontwidth,fontsize,fontheight;
  char buf[32],buf1[32];

  fontheight = ch_fontheight();
  fontwidth = ch_fontwidth();
  for(i=0;i<hbf->numcoderange;i++)
    {
      if (code < hbf->codestart[i])
	continue;
      if (code >= hbf->codestart[i+1])
	continue;
      fseek(hbf->chfp[i],hbf->sizeb*(code-hbf->codestart[i])+hbf->chlen[i],SEEK_SET);
      fread(buf,hbf->sizeb,1,hbf->chfp[i]);
      if (hbf->sizeb < 32)
	memset(buf+hbf->sizeb,0,32-hbf->sizeb);
      mon_expandfont(buf,buf1,fontwidth,fontheight);
      FontCache_add(code,buf,fontwidth*2,fontheight);
      mon_drawctext(x,y*fontheight,buf);
      return;
    }
}
	    
	  
void Read_Font_Config()
{
}
      
