//
// MetadataRowReader.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// <%=Time.now%>
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil.Metadata {

	using System;
	using System.Collections;
	using System.IO;

	using Mono.Cecil.Binary;

	class MetadataRowReader : BaseMetadataRowVisitor {

		MetadataTableReader m_mtrv;
		BinaryReader m_binaryReader;
		MetadataRoot m_metadataRoot;
		IDictionary m_ciCache;

		int m_blobHeapIdxSz;
		int m_stringsHeapIdxSz;
		int m_guidHeapIdxSz;

		public MetadataRowReader (MetadataTableReader mtrv)
		{
			m_mtrv = mtrv;
			m_binaryReader = mtrv.GetReader ();
			m_metadataRoot = mtrv.GetMetadataRoot ();
			m_ciCache = new Hashtable ();
		}

		int GetIndexSize (int rid)
		{
			return m_mtrv.GetNumberOfRows (rid) < (1 << 16) ? 2 : 4;
		}

		int GetCodedIndexSize (CodedIndex ci)
		{
			return Utilities.GetCodedIndexSize (ci,
				new Utilities.TableRowCounter (m_mtrv.GetNumberOfRows), m_ciCache);
		}

		uint ReadByIndexSize (int size)
		{
			if (size == 2) {
				return (uint) m_binaryReader.ReadUInt16 ();
			} else if (size == 4) {
				return m_binaryReader.ReadUInt32 ();
			} else {
				throw new MetadataFormatException ("Non valid size for indexing");
			}
		}

		public override void VisitRowCollection (RowCollection coll)
		{
			m_blobHeapIdxSz = m_metadataRoot.Streams.BlobHeap != null ?
				m_metadataRoot.Streams.BlobHeap.IndexSize : 2;
			m_stringsHeapIdxSz = m_metadataRoot.Streams.StringsHeap != null ?
				m_metadataRoot.Streams.StringsHeap.IndexSize : 2;
			m_guidHeapIdxSz = m_metadataRoot.Streams.GuidHeap != null ?
				m_metadataRoot.Streams.GuidHeap.IndexSize : 2;
		}

<% $tables.each { |table| %>		public override void Visit<%=table.row_name%> (<%=table.row_name%> row)
		{
<% table.columns.each { |col|
 if (col.target.nil?)
%>			row.<%=col.property_name%> = <%=col.read_binary("m_binaryReader")%>;
<% elsif (col.target == "BlobHeap")
%>			row.<%=col.property_name%> = ReadByIndexSize (m_blobHeapIdxSz);
<% elsif (col.target == "StringsHeap")
%>			row.<%=col.property_name%> = ReadByIndexSize (m_stringsHeapIdxSz);
<% elsif (col.target == "GuidHeap")
%>			row.<%=col.property_name%> = ReadByIndexSize (m_guidHeapIdxSz);
<% elsif (col.type == "MetadataToken")
%>			row.<%=col.property_name%> = Utilities.GetMetadataToken (CodedIndex.<%=col.target%>,
				ReadByIndexSize (GetCodedIndexSize (CodedIndex.<%=col.target%>)));
<% else
%>			row.<%=col.property_name%> = ReadByIndexSize (GetIndexSize (<%=col.target%>Table.RId));
<% end
}%>		}
<%  } %>	}
}
