#ifndef H_CDW_EXTERNAL_TOOLS
#define H_CDW_EXTERNAL_TOOLS

#include <stdbool.h>
#include <stddef.h> /* size_t */

#include <ncursesw/ncurses.h>

#include "main.h"




/* don't change order and values of labels from MKISOFS to MD5SUM,
   they are used to index a table in external_tools.c */
enum cdw_tool {
	CDW_TOOL_NONE = -1,

	CDW_TOOL_MKISOFS = 0, /* both: original mkisofs and genisoimage */
	CDW_TOOL_CDRECORD,    /* both: original cdrecord and wodim */
	CDW_TOOL_GROWISOFS,
	CDW_TOOL_DVD_RW_FORMAT,
	CDW_TOOL_DVD_RW_MEDIAINFO,
	CDW_TOOL_MD5SUM,

	CDW_TOOL_LIBCDIO
}; /** \brief Tool used to perform given task */



/* six external tools available: cdrecord, mkisofs, growisofs,
   dvd-rw+mediainfo, dvd-rw+format, md5sum;

   I'm not including "libcdio", because this is a library (although
   I should check for it somehow)  */
#define CDW_N_TOOLS 6



/* maximal number of instances of a tool (locations in filesystem), that can
   be recognized and handled by cdw; 10 instances seems to be reasonable limit;
   +1 is for special value "system default" */
#define CDW_EXT_TOOLS_N_INSTANCES_MAX (10 + 1)


cdw_rv_t cdw_ext_tools_init(void);
void cdw_ext_tools_clean(void);


/* basic getters */
const char *cdw_ext_tools_get_tool_fullpath(int tool_id);
const char *cdw_ext_tools_get_tool_name(int tool_id);
bool cdw_ext_tools_is_tool_available(enum cdw_tool tool_id);


/* additional getters */
int cdw_ext_tools_config_get_cd_family_id(void);
int cdw_ext_tools_config_get_dvd_family_id(void);
bool cdw_ext_tools_config_is_manual(void);
bool cdw_ext_tools_is_cdrecord_wodim(void);


/* functions used by cdw config ui: getters, setters, creator */
cdw_rv_t cdw_ext_tools_create_config_dropdowns(WINDOW *window, int row, int col, int width);
void cdw_ext_tools_save_dropdown_states(void);
bool cdw_ext_tools_get_manual_selection_state(void);
void cdw_ext_tools_save_manual_selection_state(bool ms);


/* debug and error message functions */
void cdw_ext_tools_debug_print_config(void);
cdw_rv_t cdw_ext_tools_error_dialog(enum cdw_tool tool_id);


#endif /* H_CDW_EXTERNAL_TOOLS */
