#ifndef __MAIN_H
#define __MAIN_H


#define CDW_ENTER 10
#define CDW_ESCAPE 27

void clean_before_cdw_exit(void);
int cdw_main_loop(void);

/**
 * Function return values. Introduced to avoid using only numbers
 * and increase redability of code.
 */
enum return_value {
	CDW_GEN_ERROR = -30,        /* general error, may be used when no other error applies */
	CDW_FILE_INVALID = -31,     /* file properties are diffrent than assumed, eg. is not a directory */
	CDW_PERM_EROR = -32,        /* file permissions different than assumed */
	CDW_MEM_ERROR = -33,       /* memory error: malloc() returning NULL is a very good example */
	CDW_SYS_ERROR = -34,       /* system function (eg. lstat()) call returns error */

	CDW_FAILSAFE_MODE = -99    /* options module works without reading/writing conf file on disk, because of previous errors */
};


#endif /* __MAIN */
