#! /bin/bash

function die() {
	echo "${*}" 1>&2
	exit 1
}

PREFIX=${PREFIX:-/opt/sandbox}
BUILD_CFLAGS="${CFLAGS:--O0 -ggdb3 -pipe}"
BUILD_CXXFLAGS="${CXXFLAGS:--O0 -ggdb3 -pipe}"

INSTALL=no
[[ "${1}" = "install" ]] && INSTALL=yes
echo " *** INSTALL=${INSTALL}"

case $(uname -m) in
	x86_64)
		if [[ -d /lib32 ]]; then
			ABI_BITS=(64 32)
		else
			ABI_BITS=(64) # no multilib-arch
		fi
		;;
	*)
		# default to 32bit arch
		ABI_BITS=(32)
		;;
esac

function get_libdir() {
	if [[ ${#ABI_BITS[@]} = 1 ]]; then
		echo "lib" # no multilib arch
	else
		echo "lib${ABI_bits}"
	fi
}

if [[ ! -f configure ]]; then
	./autogen.sh || die "./autogen failed."
fi

echo "Building for ABIs: ${ABI_BITS[@]} ..."
for ABI_bits in "${ABI_BITS[@]}"; do
	echo " ************************************************"
	echo " * Building for ${ABI_bits}-BIT ABI..."

	export CFLAGS="${BUILD_CFLAGS} -m${ABI_bits}"
	export CXXFLAGS="${BUILD_CXXFLAGS} -m${ABI_bits}"

	# XXX solves link error when linking 32bit version of src/example program
	export LDFLAGS="-L/usr/$(get_libdir)"

	# required to find proper libcaptury.pc
	libdir=$(get_libdir ${ABI_bits})
	export PKG_CONFIG_PATH="${PREFIX}/${libdir}/pkgconfig"

	mkdir -p "output${ABI_bits}"
	pushd "output${ABI_bits}" || die
		confopts=
		makeopts=
		if [[ "${ABI_bits}" = "32" ]]; then
			# XXX we have to work here a little bit around as strip-soname
			# XXX is usually not available for the lower bits on multilib hosts.
			# XXX so just use the one we've built earlier ;)
			confopts="${confopts} --disable-builtin-strip-soname"
			makeopts="${makeopts} STRIP_SONAME=$(pwd)/../output64/src/libGLcaptury/strip-soname"
		fi
		makeopts="${makeopts} NATIVE_LIBGL=/usr/${libdir}/libGL.so"
		makeopts="${makeopts} NATIVE_LIBX11=/usr/${libdir}/libX11.so"

		if [[ ! -f config.h ]]; then
			../configure --prefix=${PREFIX} --libdir=${PREFIX}/${libdir} ${confopts} \
				|| die "configure failed for ${ABI_bits}-BIT ABI"
		fi

		echo "running make: make ${makeopts}"
		make ${makeopts} || die "make failed for ${ABI_bits}-BIT ABI"

		if test x$INSTALL = xyes; then
			echo " *** installing for ABI ${ABI_bits}"
			make ${makeopts} install || "make install failed for ${ABI_bits}-BIT ABI"
		fi
	popd
	echo " *** finished ABI ${ABI_bits}"
done

echo "YEEEHAAH!"
