/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef AUDIOMEMORYSAMPLE_HPP
#define AUDIOMEMORYSAMPLE_HPP

#include "AudioSample.h"

class CMemoryAudioSample: public CAudioSample
{
private:

protected:
   CMemoryAudioSample &operator =(const CMemoryAudioSample &); // no copy (yet)

public:
   CMemoryAudioSample();
   CMemoryAudioSample(const CMemoryAudioSample &);
   CMemoryAudioSample(const SoundAttributes &attr, SamplePos sample_length);
   ~CMemoryAudioSample();

   bool Create(const SoundAttributes &attr, SamplePos sample_length);

   void RawCopy(void *input_buffer, SamplePos offset, SamplePos length);
   void *GetRawPointer(SamplePos offset = 0) const;

   CMemoryAudioSample &Append(const CMemoryAudioSample &samp);
   CMemoryAudioSample &Prepend(const CMemoryAudioSample &samp);
   CMemoryAudioSample &Cut(SamplePos start_sample, SamplePos end_sample);
   CMemoryAudioSample &Splice(SamplePos position, const CMemoryAudioSample &samp);
   CMemoryAudioSample &Copy();
   CMemoryAudioSample &Copy(SamplePos start_sample, SamplePos end_sample);
};


#endif
