/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include "Log.h"

// -- stl stuff
#include <iostream>
#include <fstream>
#include <sstream>

namespace camitk
{
// global static logfile
static std::ofstream logFile;

/// global instances
std::ofstream * Log::logFilePtr = NULL;
bool Log::showTimeInfo = false;
bool Log::showUserInfo = false;

//--------------- showTime ------------------
void Log::showTime(bool show) {
  showTimeInfo = show;
}

//--------------- getShowTime ------------------
bool Log::getShowTime() {
  return showTimeInfo;
}

//--------------- showUser ------------------
void Log::showUser(bool show) {
  showUserInfo = show;
}

//--------------- getShowUser ------------------
bool Log::getShowUser() {
  return showUserInfo;
}

//--------------- getUserInformation ------------------
std::string Log::getUserInformation() {
    static std::string user = "";
    if (user == "") {
      if (NULL != getenv("USERNAME")) 
        user = getenv("USERNAME");
      else if (NULL != getenv("USER")) 
        user = getenv("USER");
      else
        user = "unidentified user";
    }
    return user;
}

//---------------openLogFile------------------//
void Log::openLogFile()   {  
    logFile.open("log.txt");
    logFilePtr = new std::ofstream;
    logFilePtr->open("log.txt");
}

//---------------closeLogFile------------------//
void Log::closeLogFile()   {
    logFile.flush();
    logFile.close();
    logFilePtr->flush();
    logFilePtr->close();
}

//--------------- getLogStream ------------------
std::ostream * Log::getLogStream() {
    if (logFilePtr)
        return logFilePtr;
    else 
      return &std::cout;
}

}

