/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core image component stuff
#include "ImageComponentPopup.h"
#include "ImageComponent.h"
#include "MedicalDataOriginDialog.h"

// -- Core stuff
#include "Application.h"
#include "MainWindow.h"
#include "Component.h"
#include "InteractiveViewer.h"

// -- QT stuff
#include <QMessageBox>



namespace camitk {
// ---------------------- constructor ----------------------------
ImageComponentPopup::ImageComponentPopup ( Component *dc, QWidget *parent ) : ComponentPopupMenu ( dc, parent ) {

    medicalDataOriginDialog = NULL;
    imageFilterMenu = NULL;
    dad = ( ImageComponent* ) dc;

    displayIn3Did = addAction ( "Show In 3D", SLOT ( displayIn3D() ), true );
    // to avoid unexpected calls
    updateDisplayIn3D(true);

    /* 3D reconstruction */
    addSeparator();

}

ImageComponentPopup::~ImageComponentPopup() {
    
    if ( medicalDataOriginDialog )
        delete medicalDataOriginDialog;

}



void ImageComponentPopup::selectOrigin() {
    //display the dialog window
    if ( !medicalDataOriginDialog )
        medicalDataOriginDialog = new MedicalDataOriginDialog ( dad, Application::getMainWindow() );

    medicalDataOriginDialog->exec();
}


// ---------------------- displayIn3D ----------------------------
void ImageComponentPopup::displayIn3D() {
    // if true, display in 3D, else hide.
    dad->setAllVisibleIn3D ( displayIn3Did->isChecked() );
    camitk::InteractiveViewer::get3DViewer()->refresh();
}

// ---------------------- updateDisplayIn3D ----------------------------
void ImageComponentPopup::updateDisplayIn3D ( bool in3D) {
  displayIn3Did->blockSignals(true);
  displayIn3Did->setChecked(in3D);
  displayIn3Did->blockSignals(false);
}

}
