/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef IMAGE_MANAGER_PLUGIN_H
#define IMAGE_MANAGER_PLUGIN_H


// -- Core image component stuff
#include "CamiTKAPI.h"
#include "ImageComponent.h"

// -- Core stuff
#include "ComponentExtension.h"

// -- QT stuff
#include <QObject>
#include <QMap>


namespace camitk
{
/** 
 * Abstract class created to support export file formats for ImageComponent
 *  Any data component plugin creating an ImageComponent should inherit from this class.
 * 
 */

class CAMITK_API ImageComponentExtension : public ComponentExtension {

  public:

    /// get the plugin name
    virtual QString getName() const;

    /// get the plugin description (can be html)
    virtual QString getDescription() const;

    /// get a new instance from data stored in a file (this is the most important method to redefine in your subclass)
    virtual Component * open(const QString &) throw (AbortException) = 0;

protected:
    /// Constructor protected because the class is virtual
    ImageComponentExtension(); 

    /// the destructor
    virtual ~ImageComponentExtension() {};

};

}

#endif // IMAGE_MANAGER_PLUGIN_H
