/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef VTK_RAWDATA_MANAGER_H
#define VTK_RAWDATA_MANAGER_H


// -- raw data image component stuff
#include "RawDataDialog.h"

// -- Core image component stuff
#include <ImageComponent.h>

// -- VTK stuff
#include <vtkSmartPointer.h>
#include <vtkImageData.h>


using namespace camitk;
/**This class manage vtk images
 *
 *
 * $Revision: 1.5 $
 */


class RawImageComponent : public ImageComponent  {
    Q_OBJECT
public:
    /// default constructor: give it the name of the file containing the data
    RawImageComponent(const QString&) throw (AbortException);

    /// Destructor
    ~RawImageComponent();

    virtual void createComponent();

    void createDialog();

protected:
    RawDataDialog * myDialog;

};



#endif // VTK_RAWDATA_MANAGER_H
