/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "Arrows.h"
#include <PMManagerDC.h>
#include <AtomDC.h>
#include <AtomDecoration.h>

#include <InteractiveViewer.h>

#include "MMLMonitorDisplayFactory.h"

bool arrowsRegistered=MMLMonitorDisplayFactory::getInstance()->registerClass<Arrows>("Arrows",Monitor::VECTORSET);

Arrows::Arrows(Monitor* monitor, MMLComponent* manager): MMLMonitorDisplay(monitor, manager)
{

}

Arrows::~Arrows()
{

}

// ---------------------- update ----------------------------
void Arrows::update()
{
  PMManagerDC* pmMgr=manager->getPMManager();
  AtomDecoration* deco;
  AtomDC* adc;

  if (monitor->getNumberOfValues()>0){
    
    for ( unsigned int i = 0; i <monitor->getNumberOfIndex();i++ ) {
	   
      adc = pmMgr->getDC (pmMgr->getPhysicalModel()->getAtom(monitor->getIndexOfValues(i)));
      deco = adc->getDecoration("Force", GeometricObject::ARROW);
      deco->setColor(1.0, 0.3, 0.15);
      deco->update(monitor->getValue(3*i),monitor->getValue(3*i+1),monitor->getValue(3*i+2));
      deco->show(true);
	    
    }
  }
}

// ---------------------- hide ----------------------------
void Arrows::hide()
{
  PMManagerDC* pmMgr=manager->getPMManager();
  AtomDecoration* deco;
  AtomDC* adc;

  if (monitor->getNumberOfValues()>0){
    
    for ( unsigned int i = 0; i <monitor->getNumberOfIndex();i++ ) {
	   
      adc = pmMgr->getDC (pmMgr->getPhysicalModel()->getAtom(monitor->getIndexOfValues(i)));
      deco = adc->getDecoration("Force", GeometricObject::ARROW);
      deco->show(false);
	    
    }
  }
}



