#------------------
# CamiTK packaging
#------------------

# Do not forget to change the version variables in CamiTKBuild.cmake
#
# To make a source tar ball, just use the custom target camitk_package_source, e.g. "make camitk_package_source"
#
# To make an executable/installable, you will have to properly set a specific CAMITK_INSTALL_ROOT
#
# CAMITK_INSTALL_ROOT will be used as the root installation directory on the targeted plateform
# Usual values for unix are /usr or /usr/local
#
# Therefore, in order to produce a proper deb for system-wide install, you can run something like:
# cmake -DCAMITK_INSTALL_ROOT=/usr -DCMAKE_BUILD_TYPE=Release -DACTION_ITKSEGMENTATION=TRUE -DACTION_ITKFILTERS=TRUE -DAPPLICATION_WIZARD=TRUE -DCOMPONENT_DICOM=TRUE -DCOMPONENT_ITKIMAGE=TRUE -DCOMPONENT_MML=TRUE -DCOMPONENT_PHYSICALMODEL=TRUE -DMML_GENERATE_XSD_LIB=TRUE /home/promayon/Dev/CamiTK/camitk
# fakeroot make camitk_package
#
# To build source package
# make camitk_package_source
# (it generates the correct CamiTKVersion.h)
#
# Once CAMITK_INSTALL_ROOT is properly defined, type "make camitk_package"
# 
# To check the content of a deb package:
# dpkg --contents package.deb
# To install the content of a deb in a subdirectory instead of system-wide:
# dpkg --vextract package.deb subdirectory
#
# To produce a window installer with NSIS from linux, you need to install the nsis package (on ubuntu, type "sudo apt-get install nsis")
# Be sure to use the makensisw.exe and not makensis.exe as the value of the MAKENSIS variable.
#
# To generate different components that can be opt out at install time, see
# http://www.itk.org/Wiki/CMake:Component_Install_With_CPack
#
# More generally see http://www.itk.org/Wiki/CMake:CPackConfiguration


# package name
string(TOLOWER ${CAMITK_PROJECT_NAME} CPACK_PACKAGE_NAME)
set(CPACK_PACKAGE_VERSION_MAJOR ${CAMITK_VER_MAJ})
set(CPACK_PACKAGE_VERSION_MINOR ${CAMITK_VER_MIN})
set(CPACK_PACKAGE_VERSION_PATCH ${CAMITK_VER_PACKAGE_PAT})
string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)

# contact information
set(CPACK_PACKAGE_VENDOR "UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525")
set(CPACK_PACKAGE_CONTACT "http://camitk.imag.fr")	

# resource files
set(CPACK_RESOURCE_FILE_README "${CAMITK_SOURCE_DIR}/README")
set(CPACK_RESOURCE_FILE_LICENSE "${CAMITK_SOURCE_DIR}/COPYRIGHT")

# executable
set(CPACK_PACKAGE_EXECUTABLES "imp" "imp" "wizard" "wizard")

# There is a "bug"/packaging problem with CMake 2.8.7 and 2.8.8 on ubuntu 12.04
# The package that is produced is corrupted.
# The workaround (see http://cmake.3232098.n2.nabble.com/Creating-package-td7577614.html )
# mkdir tmp
# cp camitk-3.0.0-blue-ubuntu12.04_amd64.deb tmp
# cd tmp
# ar xv camitk-3.0.0-blue-ubuntu12.04_amd64.deb data.tar.gz
# tar xzvf data.tar.gz
# tar zcvf data.tgz ./usr
# mv data.tgz data.tar.gz
# ar rv camitk-3.0.0-blue-ubuntu12.04_amd64.deb data.tar.gz 

SET(CPACK_PACKAGE_DESCRIPTION "${CPACK_PACKAGE_NAME}\n ${CPACK_PACKAGE_DESCRIPTION_SUMMARY}")

# Package information
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY ${CPACK_PACKAGE_DESCRIPTION_SUMMARY})
set(CPACK_DEBIAN_PACKAGE_DESCRIPTION ${CPACK_PACKAGE_DESCRIPTION})


if (UNIX AND NOT WIN32)
  set(CPACK_GENERATOR "DEB") # "RPM")
else()
  set(CPACK_GENERATOR "NSIS")
endif()

set(CPACK_SOURCE_GENERATOR "TGZ" "ZIP" )

# package name and version
string(TOLOWER ${CAMITK_PROJECT_NAME} CPACK_PACKAGE_NAME)
set(CPACK_PACKAGE_VERSION_MAJOR ${CAMITK_VER_MAJ})
set(CPACK_PACKAGE_VERSION_MINOR ${CAMITK_VER_MIN})
set(CPACK_PACKAGE_VERSION_PATCH ${CAMITK_VER_PACKAGE_PAT})

string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}" CPACK_SOURCE_PACKAGE_FILE_NAME)


set(CPACK_SOURCE_IGNORE_FILES
"~$"
"/\\\\.svn/"
"/\\\\.git/"
"/kdev4$/"
"/build/"
${CPACK_SOURCE_IGNORE_FILES}
)

# ----------------
# Debian packages
# ----------------
if (UNIX AND NOT WIN32)
	
	message(STATUS "Packaging CamiTK for UNIX systems")
	# Try to find architecture
	execute_process(COMMAND uname -m OUTPUT_VARIABLE CPACK_PACKAGE_ARCHITECTURE)
	string(STRIP "${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_ARCHITECTURE)
	# Try to find distro name and distro-specific arch
	execute_process(COMMAND lsb_release -is OUTPUT_VARIABLE LSB_ID)
	execute_process(COMMAND lsb_release -rs OUTPUT_VARIABLE LSB_RELEASE)
	string(STRIP "${LSB_ID}" LSB_ID)
	string(STRIP "${LSB_RELEASE}" LSB_RELEASE)
	set(LSB_DISTRIB "${LSB_ID}${LSB_RELEASE}")
	if(NOT LSB_DISTRIB)
		set(LSB_DISTRIB "unix")
	endif(NOT LSB_DISTRIB)
	message(STATUS "Packager architecture : ${LSB_DISTRIB}")

	#Find DPKG
	find_program(DPKG
		NAMES dpkg-deb
		PATHS "/usr/bin" #Add paths here
	)
	if ( DPKG )
		get_filename_component(DPKG_PATH ${DPKG} ABSOLUTE)
		message(STATUS "Packaging deb using ${DPKG_PATH}: OK")
		set(DPKG_FOUND "YES")
	else() 
		set(DPKG_FOUND "NO")
	endif()

	


	# For Debian-based distribs we want to create DEB packages.
	if("${LSB_DISTRIB}" MATCHES "Ubuntu|Debian")

# 		make_directory(${CMAKE_BINARY_DIR}/packaging/debian)
# 		set(GTK_UPDATE_ICON_CACHE "gtk-update-icon-cache -f -t ${THEME_DIRECTORY}")
# 		configure_file( ${CMAKE_SOURCE_DIR}/cmake/debian/postinst.in ${CMAKE_BINARY_DIR}/packaging/debian/postinst )
# 		configure_file( ${CMAKE_SOURCE_DIR}/cmake/debian/prerm.in ${CMAKE_BINARY_DIR}/packaging/debian/prerm )
# 
# 		set(CPACK_GENERATOR "DEB")
# 		set(CPACK_DEBIAN_PACKAGE_PRIORITY "extra")
# 		set(CPACK_DEBIAN_PACKAGE_SECTION "photos")
# 		set(CPACK_DEBIAN_PACKAGE_RECOMMENDS "")
# 		set(CPACK_DEBIAN_PACKAGE_CONTROL_EXTRA "${CMAKE_BINARY_DIR}/packaging/debian/postinst;${CMAKE_BINARY_DIR}/packaging/debian/prerm;" )

		# We need to alter the architecture names as per distro rules
		if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "i[3-6]86")
			set(CPACK_PACKAGE_ARCHITECTURE i386)
		endif("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "i[3-6]86")
		if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "x86_64")
			set(CPACK_PACKAGE_ARCHITECTURE amd64)
		endif("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "x86_64")
		# Set the dependencies based on the distrib version

		# Installation path
		# Set the install location to "/usr"
		set(CAMITK_INSTALL_ROOT "/usr")
		set(CPACK_PACKAGING_INSTALL_PREFIX "/usr")
		set(CPACK_PACKAGE_DEFAULT_LOCATION "/usr")
		set(CPACK_SET_DESTDIR TRUE)

		# For building on a different system
		# set(LSB_DISTRIB Ubuntu11.10)

		# Dependencies depending on the Operating System.
		# Ubuntu
		if("${LSB_DISTRIB}" MATCHES "Ubuntu11.10")
			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.6-qt4, libxerces-c3.1 ")
		endif("${LSB_DISTRIB}" MATCHES "Ubuntu11.10")
		# For Ubuntu11.04
		if("${LSB_DISTRIB}" MATCHES "Ubuntu12.04")
			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev, libinsighttoolkit3.20, libxml2, libvtk5.8-qt4, libxerces-c3.1 ")
		endif("${LSB_DISTRIB}" MATCHES "Ubuntu12.04")

		# Debian
# 		if("${LSB_DISTRIB}" MATCHES "Debian5.*")
# 			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libgtk2.0-0, libsqlite3-0, libglade2-0, libgegl-0.0-0, libcairo2, libexiv2-5, liblcms1, libjpeg62, libpng12-0, liblensfun0, liblensfun-data")
# 
# 		endif("${LSB_DISTRIB}" MATCHES "Debian5.*")
# 		if("${LSB_DISTRIB}" MATCHES "Debiantesting")
# 			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libgtk2.0-0, libsqlite3-0, libglade2-0, libgegl-0.0-0, libcairo2, libexiv2-5, liblcms1, libjpeg62, libpng12-0, liblensfun0, liblensfun-data")
# 		endif("${LSB_DISTRIB}" MATCHES "Debiantesting")

		if(NOT CPACK_DEBIAN_PACKAGE_DEPENDS)
			message("WARNING: ${LSB_DISTRIB} not supported yet.\nPlease set deps in cmake/darktable-packaging.cmake before packaging.")
		endif(NOT CPACK_DEBIAN_PACKAGE_DEPENDS)

	endif("${LSB_DISTRIB}" MATCHES "Ubuntu|Debian")

	# package name
	string(TOLOWER "${CPACK_PACKAGE_NAME}_${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)

	# contact information
	set(CPACK_PACKAGE_VENDOR "UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525")
	set(CPACK_PACKAGE_CONTACT "http://camitk.imag.fr")	
	set(CPACK_DEBIAN_PACKAGE_MAINTAINER "CamiTK Developers <camitk-developers@lists.forge.imag.fr>")

	# resource files
	set(CPACK_RESOURCE_FILE_README "${CAMITK_SOURCE_DIR}/README")
	set(CPACK_RESOURCE_FILE_LICENSE "${CAMITK_SOURCE_DIR}/COPYRIGHT")

	#set(CPACK_INSTALL_CMAKE_PROJECTS "???"
	# information description
	set(CPACK_PACKAGE_DESCRIPTION_FILE "${CAMITK_SOURCE_DIR}/README")
	set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Computer Assisted Medical Intervention Took Kit.
	CamiTK is a C++ framework that helps researchers and clinicians to easily and rapidly collaborate in order to prototype CAMI applications, that feature medical images, surgical navigation and biomechanical simulations.")
	SET(CPACK_PACKAGE_DESCRIPTION "${CPACK_PACKAGE_NAME}\n ${CPACK_PACKAGE_DESCRIPTION_SUMMARY}")



# if(DPKG_FOUND)
#                 set(CPACK_PACKAGING_INSTALL_PREFIX "/usr")
#                 set(CPACK_PACKAGE_DEFAULT_LOCATION "/usr")
# 		set(CPACK_DEBIAN_PACKAGE_DESCRIPTION ${CPACK_PACKAGE_DESCRIPTION})
# 		set(CPACK_PACKAGE_DESCRIPTION_SUMMARY ${CPACK_PACKAGE_DESCRIPTION_SUMMARY})
# 		set(CPACK_SET_DESTDIR TRUE)
# 		#set(CPACK_INSTALLED_DIRECTORIES "${CAMITK_INSTALL_ROOT}/include" "usr/include")
# 		set(CPACK_DEBIAN_PACKAGE_ARCHITECTURE i386) # Change to your architecture here, there is no such thing as i686 in deb!
# 		# TODO update list of dependencies
# 		message(STATUS "Variable LSB_DISTRIB = ${LSB_DISTRIB} ")
# 		# For Ubuntu10.04
# 		if("${LSB_DISTRIB}" MATCHES "Ubuntu10.04")
# 			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libinsighttoolkit3.16  ( >= 3.16.0-1 ), libxml2, libvtk5.2-qt4")
# 		endif("${LSB_DISTRIB}" MATCHES "Ubuntu10.04")
# 		# For Ubuntu10.10
# 		if("${LSB_DISTRIB}" MATCHES "Ubuntu10.10")
# 			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libinsighttoolkit3.18, libxml2, libvtk5.4-qt4")
# 		endif("${LSB_DISTRIB}" MATCHES "Ubuntu10.10")
# 		# For Ubuntu11.04
# 		if("${LSB_DISTRIB}" MATCHES "Ubuntu11.04")
# 			set(CPACK_DEBIAN_PACKAGE_DEPENDS "libinsighttoolkit3.18, libxml2, libvtk5.4-qt4 ")
# 		endif("${LSB_DISTRIB}" MATCHES "Ubuntu11.04")
# 		# For Ubuntu11.04
# 		
# 	endif() 

	# -------------
	# RPM packages
	# -------------
	# TODO test rpm packaging
	find_program(RPMBUILD
		NAMES rpmbuild
		PATHS "/usr/bin"
	)

	if ( RPMBUILD )
		get_filename_component(RPMBUILD_PATH ${RPMBUILD} ABSOLUTE)
		message(STATUS "Packaging rpm using ${RPMBUILD_PATH}: OK")
		set(RPMBUILD_FOUND "YES")
	else () 
		SET(RPMBUILD_FOUND "NO")
	endif()

	if(RPMBUILD_FOUND AND NOT WIN32)
		set(CPACK_SET_DESTDIR TRUE)
	endif(RPMBUILD_FOUND AND NOT WIN32)
endif()

if(WIN32 AND NOT UNIX)
	# -----------------------
	# NSIS Windows installer
	# -----------------------
	
	# Update package name for windows release
	set(LSB_DISTRIB "win32")
	set(CPACK_PACKAGE_ARCHITECTURE i386)
	string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}" CPACK_PACKAGE_FILE_NAME)
	
	Message(status "CPACK_PACKAGE_FILE_NAME : ${CPACK_PACKAGE_FILE_NAME}")
	
	# Try to find Makensis on Linux distribution
	find_program(MAKENSIS
	  NAMES makensis
	  PATHS "/usr/bin"
	)

	if(MAKENSIS)
		# NSIS Windows installer
		message(STATUS "Packaging nsis using ${MAKENSIS}")
		
		# IMPORTANT !!!
		# There is a bug in NSI that does not handle full unix paths properly. Make
		# sure there is at least one set of four (4) backslashes.
		
		# include(GetPrerequisites)
		# set(TARGET_DIR ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/Debug)
		# set(PREREQ "")
		# get_prerequisites(${CAMITK_BIN_DIR}/Debug/imp.exe PREREQ 1 1 ${CAMITK_BIN_DIR} ${VTK_LIBRARY_DIRS}/Release)
		# get_prerequisites(${TARGET_DIR}/${EXECNAME}.exe" PREREQ 0 1 ${TARGET_DIR} "")
		# Get the list of shared library files required by <target>.  The list
       # in the variable named <prerequisites_var> should be empty on first
       # entry to this function.  On exit, <prerequisites_var> will contain the
       # list of required shared library files.

       # <target> is the full path to an executable file.  <prerequisites_var>
       # is the name of a CMake variable to contain the results.
       # <exclude_system> must be 0 or 1 indicating whether to include or
       # exclude "system" prerequisites.  If <recurse> is set to 1 all
       # prerequisites will be found recursively, if set to 0 only direct
       # prerequisites are listed.  <exepath> is the path to the top level
       # executable used for @executable_path replacment on the Mac.  <dirs> is
       # a list of paths where libraries might be found: these paths are
       # searched first when a target without any path info is given.  Then
       # standard system locations are also searched: PATH, Framework
       # locations, /usr/lib...
		#message(STATUS "PREREQ=${PREREQ}")
        #set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS ${PREREQ})	
		
		set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
                  ##TODO use GetPrerequisites.cmake (i.e. find a better way to list dependencies)
                  ##get_prerequisites() is not well enough documented to justify the time investement - EP May 2011
				  ${QT_BINARY_DIR}/QtCore4.dll 
				  ${QT_BINARY_DIR}/QtGui4.dll
				  ${QT_BINARY_DIR}/QtSvg4.dll
				  ${QT_BINARY_DIR}/QtXml4.dll
				  ${QT_BINARY_DIR}/QtNetwork4.dll
				  ${QT_BINARY_DIR}/QtSql4.dll
				  ${QT_BINARY_DIR}/QtWebKit4.dll
                  ${VTK_LIBRARY_DIRS}/Release/QVTK.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkCommon.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtksys.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkFiltering.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkGraphics.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkHybrid.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkIO.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkImaging.dll
                  ${VTK_LIBRARY_DIRS}/Release/vtkRendering.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkVolumeRendering.dll
                  ${VTK_LIBRARY_DIRS}/Release/vtkverdict.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkDICOMParser.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkNetCDF.dll 
				   ${VTK_LIBRARY_DIRS}/Release/vtkNetCDF_cxx.dll
                  # ${VTK_LIBRARY_DIRS}/Release/vtkmesh.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkexpat.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkjpeg.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkmetaio.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkpng.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtktiff.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkzlib.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkInfovis.dll 
                  # ${VTK_LIBRARY_DIRS}/Release/vtkQtChart.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkfreetype.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkftgl.dll
                  ${VTK_LIBRARY_DIRS}/Release/vtkalglib.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtklibxml2.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkViews.dll 
                  ${VTK_LIBRARY_DIRS}/Release/vtkexoIIc.dll
                  ${VTK_LIBRARY_DIRS}/Release/vtkWidgets.dll	
				  # Wizard dependencies
				  ${XERCESC_ROOT_DIR}/bin/xerces-c_3_1.dll
				  
		)
		
		##ITK is required
		# FIND_PACKAGE(ITK)
		if (${ITK_FOUND})
			message(pass ${VTK_LIBRARY_DIRS})
			set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS ${CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS} ${ITK_DIR}/bin/Release/ITKCommon.dll)
		endif ()
		
	   	# Application icon
		set(CAMITK_PACKAGE_ICON "${CMAKE_CURRENT_SOURCE_DIR}\\\\core\\\\icons\\\\appIcon.ico") #set here the current icon for CamiTK
		set(CPACK_PACKAGE_ICON ${CAMITK_PACKAGE_ICON}) #icon for the top bar NSIS installer
		set(CPACK_NSIS_MUI_ICON ${CAMITK_PACKAGE_ICON}) #icon for the generated install program (the .exe to run to install CamiTK).
		set(CPACK_NSIS_MUI_UNIICON ${CAMITK_PACKAGE_ICON}) #icon for the generated uninstall program (the .exe to run to uninstall CamiTK).
		
		# Create desktop icons, by forcing CPack to build an internal command, as 'set(CPACK_NSIS_MODIFY_PATH ON)' option setted in the additional page doesn't work.
	    set(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "CreateShortCut \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\" \\\"$INSTDIR\\\\bin\\\\imp.exe\\\"")              
				
		# Tell CPack to remove the icons after uninstalling
		set(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "Delete \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\"")
				
		# Installer name
		set(CPACK_NSIS_DISPLAY_NAME "CamiTK ${CAMITK_VER_MAJ}.${CAMITK_VER_MIN}.${CAMITK_VER_PACKAGE_PAT}")
		set(CPACK_NSIS_INSTALLED_ICON_NAME ${CAMITK_PROJECT_NAME})
		
		
		
		
		set(CPACK_PACKAGE_INSTALL_DIRECTORY ${CAMITK_PROJECT_NAME})
		set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\camitk.imag.fr")
		set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\camitk.imag.fr")
		set(CPACK_NSIS_CONTACT ${CPACK_PACKAGE_CONTACT})
		include(InstallRequiredSystemLibraries)
	else()
	    message(STATUS "Can not find makensis: nsis packaging is not possible")
	endif()

endif()

# ---------------
# Mac App Bundle
# ---------------
if(APPLE)
    # TODO test this!
    set(CPACK_GENERATOR "PackageMaker")
    # Libraries are bundled directly
    set(CPACK_COMPONENT_LIBRARIES_HIDDEN TRUE)
    # Bundle Properties
    set(MACOSX_BUNDLE_BUNDLE_NAME ${CPACK_PACKAGE_NAME})
    set(MACOSX_BUNDLE_BUNDLE_VERSION ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_SHORT_VERSION_STRING ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_LONG_VERSION_STRING "Version ${PROJECT_VERSION}")
endif()


# -------------------------------------
# System and dependencies requirements
# -------------------------------------
include(InstallRequiredSystemLibraries)


# and here we go...
include(CPack)


# ----------------------------------
# CamiTK specific packaging targets
# ----------------------------------

# create specific target for package source
add_custom_target(camitk_package_source
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/CamiTKPackageVersion.h
                ${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package_source
    COMMAND ${CMAKE_COMMAND}
        -E remove ${CAMITK_SOURCE_DIR}/core/CamiTKVersion.h
)

# create specific target for binary package
add_custom_target(camitk_package
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h-backup
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/CamiTKPackageVersion.h
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h-backup
                ${CAMITK_BINARY_DIR}/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
)
