/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "RemovableLineEdit.h"
#include "ExtTypeWindow.h"
#include "ExtensionWindow.h"

RemovableLineEdit::RemovableLineEdit(QMainWindow * dad) : QWidget(dad)
{
    ui.setupUi(this);
	this->ui.TopLevelRadioButton->hide();
	this->ui.dotLabel->hide();
    this->dad = dad;
}

void RemovableLineEdit::remove() {
    ExtTypeWindow * dadExtType = dynamic_cast<ExtTypeWindow*> (this->dad);
	ExtensionWindow * dadExtension = dynamic_cast<ExtensionWindow*> (this->dad);

	if (dadExtType != NULL) {
		dadExtType->removeLineEdit(this);
		return;
	}
	else if (dadExtension != NULL) {
        dadExtension->removeExtTypeFile(this);
		return;
	}

}

void RemovableLineEdit::radioButtonChanged(bool res) {
	ExtensionWindow * dadExtension = dynamic_cast<ExtensionWindow*> (this->dad);
	if (dadExtension != NULL) {
        dadExtension->rleToggle(this, res);
		return;
	}

}