/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ParameterWidget.h"
#include "ExtTypeWindow.h"

#include <QDate>
#include <QTime>
#include <QDateTime>
#include <QTextStream>

ParameterWidget::ParameterWidget(QMainWindow * dad) : QWidget(dad)
{
    ui.setupUi(this);
    this->dad = dad;
	typeChanged(ui.parameterTypeComboBox->currentText());
}

void ParameterWidget::removedClicked() {
    ExtTypeWindow * dadExtType = dynamic_cast<ExtTypeWindow*> (this->dad);
    if (dadExtType != NULL)
		dadExtType->removeParameter(this);
}

void ParameterWidget::typeChanged(QString type) {
	if (type == "int")
		ui.parameterDefaultValueLineEdit->setText("0");
	else if (type == "bool")
		ui.parameterDefaultValueLineEdit->setText("false");
	else if (type == "double")
		ui.parameterDefaultValueLineEdit->setText("0.0");
	else if (type == "QString")
		ui.parameterDefaultValueLineEdit->setText("QString(\"Hello World\")");
	else if (type == "QDate") {
		QDate today = QDate::currentDate();
		QString defValue;
		QTextStream in(&defValue);
		in << "QDate(" << today.year() << ", " << today.month() << ", " << today.day() << ")";
		ui.parameterDefaultValueLineEdit->setText(defValue);
	}
	else if (type == "QTime") {
		QTime now = QTime::currentTime();
		QString defValue;
	    QTextStream in(&defValue);
		in << "QTime(" << now.hour() << ", " << now.minute() << ", " << now.second() << ")";
		ui.parameterDefaultValueLineEdit->setText(defValue);
	}
	else if (type == "QColor")
		ui.parameterDefaultValueLineEdit->setText("QColor(255, 255, 255, 255)");
	else if (type == "QPoint")
		ui.parameterDefaultValueLineEdit->setText("QPoint(0, 0)");
	else if (type == "QPointF")
		ui.parameterDefaultValueLineEdit->setText("QPointF(0.0, 0.0)");
	else if (type == "QVector3D")
		ui.parameterDefaultValueLineEdit->setText("QVector3D(0.0, 0.0, 0.0)");
}