/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef TETRAHEDRALIZE_H
#define TETRAHEDRALIZE_H

#include <Action.h>
using namespace camitk;

/** Use TetGen from http://tetgen.berlios.de to generate a
 *  Delaunay Tetrahedralization of the set of points of a mesh.
 *
 *  Beware of the licence of TetGen before using this extension,
 *  an extract is copyied here to appear in this
 *  extension API documentation:
\verbatim
The software (TetGen) is licensed under the terms of the  MIT  license
with the following exceptions:

Distribution of  modified  versions  of this code is permissible UNDER
THE CONDITION THAT  THIS CODE AND ANY MODIFICATIONS  MADE TO IT IN THE
SAME SOURCE FILES  tetgen.h AND tetgen.cxx  REMAIN UNDER  COPYRIGHT OF
THE  ORIGINAL AUTHOR,  BOTH  SOURCE AND OBJECT  CODE  ARE MADE  FREELY
AVAILABLE  WITHOUT   CHARGE,   AND  CLEAR   NOTICE  IS  GIVEN  OF  THE
MODIFICATIONS.

Distribution of this code for  any  commercial purpose  is permissible
ONLY BY DIRECT ARRANGEMENT WITH THE COPYRIGHT OWNER.
\endverbatim
 * The full license text is available in the file tetgen1.4.3/LICENSE.
 *
 * The code of this extension itself is available under the LGPL.
 *
 */
class Tetrahedralize : public Action {

public:
    /// the constructor
    Tetrahedralize(ActionExtension* extension);

    /// the destructor
    virtual ~Tetrahedralize() {};
    
public slots:
    /// method applied when the action is called
    virtual ApplyStatus apply();

};

#endif // TETRAHEDRALIZE_H
