/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

/**
 * @file SphereTopology.cpp
 * @brief Class implementation for 3D sphere mesh creation
 * @author Mathieu BAILET
 * @date July 5 2012
 */

#include "SphereTopology.h"
#include <MeshComponent.h>
#include <Log.h>
#include <Application.h>
#include <MainWindow.h>

#include <vtkCell.h>
#include <vtkPoints.h>
#include <vtkSmartPointer.h>
#include <vtkHexahedron.h>
#include <vtkUnstructuredGrid.h>
#include <vtkCellArray.h>
#include <vtkSphereSource.h>

SphereTopology::SphereTopology(ActionExtension *extension) : Action(extension) {
    setName("Sphere Topology");
    setEmbedded(true);
    setDescription("Build a sphere");
    setComponent(""); // empty component: it does not need any data to be triggered
    setFamily("Mesh Processing");
    addTag("Build Sphere");

    setProperty("Center X", 0.);
    setProperty("Center Y", 0.);
    setProperty("Center Z", 0.);
    setProperty("Radius", 1.);
    setProperty("Phi Resolution", 10);
    setProperty("Theta Resolution", 10);
}

SphereTopology::~SphereTopology() {
}

Action::ApplyStatus SphereTopology::apply() {
    double cX = property("Center X").toDouble();
    double cY = property("Center Y").toDouble();
    double cZ = property("Center Z").toDouble();
    double radius = property("Radius").toDouble();
    int phiRes = property("Phi Resolution").toDouble();;
    int thetaRes = property("Theta Resolution").toDouble();;

    vtkSmartPointer<vtkSphereSource> sphere = vtkSmartPointer<vtkSphereSource>::New();
    sphere->SetCenter(cX, cY, cZ);
    sphere->SetRadius(radius);
    sphere->SetPhiResolution(phiRes);
    sphere->SetThetaResolution(thetaRes);
    sphere->Update();

    vtkSmartPointer<vtkPolyData> pData = sphere->GetOutput();

    MeshComponent* result = new MeshComponent(pData, "Sphere");
    Application::refresh();
    Application::resetProgressBar();
    Application::showStatusBarMessage("");

    return SUCCESS;
}