/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DELETELASTINSTANCIATEDACTION_H
#define DELETELASTINSTANCIATEDACTION_H

#include <Action.h>

using namespace camitk;

/** Remove the last top-level selected component (if several top level components were selected, the latest one is removed).
 *  Note that no prompt is asked to the user to save or not the component if unsaved.
 */
class RemoveLastInstanciatedAction : public Action {

public:
    /// Default Constructor
    RemoveLastInstanciatedAction(ActionExtension *extension);
	
    /// Default Destructor
    virtual ~RemoveLastInstanciatedAction();
	
    /// Returns NULL: no widget at all for this action
    virtual QWidget * getWidget();
	
public slots:
    /// apply the action select the last instanciated component
    virtual ApplyStatus apply();
};

#endif // DELETELASTINSTANCIATEDACTION_H
