/**
* This file is a part of the Cairo-Dock project
*
* Copyright : (C) see the 'copyright' file.
* E-mail    : see the 'copyright' file.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 3
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __TOMBOY_DBUS__
#define  __TOMBOY_DBUS__

#include <dbus/dbus-glib.h>
#include "tomboy-struct.h"


gboolean dbus_connect_to_bus (void);
void dbus_disconnect_from_bus (void);

void dbus_detect_tomboy (void);
void dbus_detect_tomboy_async (void);


void getAllNotes_async (void);
void free_all_notes (void);

gchar *addNote (const gchar *note_name);
void deleteNote (const gchar *note_title);
void showNote (const gchar *note_id);


GList *cd_tomboy_find_notes_with_tag (const gchar *cTag);

GList *cd_tomboy_find_notes_with_contents (const gchar **cContents);

GList *cd_tomboy_find_note_for_today (void);
GList *cd_tomboy_find_note_for_this_week (void);
GList *cd_tomboy_find_note_for_next_week (void);

#endif
