/***************************************************************************
 *   Copyright (C) 2004 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *   Copyright (C) 2006 by Fco. Javier M. C. (Porting to QT4)              *
 *   fcojavmc@todo-redes.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QMessageBox>
#include <QWidget>
#include <QComboBox>
#include <QToolButton>
#include <QTextStream>
#include <QLayout>
#include <QMessageBox>
#include <fstream>

#include "listseriefacturaview.h"
#include "company.h"
#include "configuracion.h"
#include "busquedacliente.h"
#include "busquedafecha.h"

#include "funcaux.h"


ListSerieFacturaView::ListSerieFacturaView(company *comp, QWidget *parent)
        : Ficha(parent) {
    _depura("INIT_ListSerieFacturaView::ListSerieFacturaView", 1);
    setAttribute(Qt::WA_DeleteOnClose);
    setupUi(this);
    companyact = comp;
    mui_listado->setcompany(comp);
    mui_listado->cargar();
    companyact->meteWindow(windowTitle(), this);
    _depura("END_ListSerieFacturaView::ListSerieFacturaView", 1);
}


ListSerieFacturaView::~ListSerieFacturaView() {
    _depura("ListSerieFacturaView::~ListSerieFacturaView", 0);
    _depura("END ListSerieFacturaView::~ListSerieFacturaView", 0);
}


int ListSerieFacturaView::sacaWindow() {
    companyact->sacaWindow(this);
    return 0;
}

/// ===================================== SUBFORMULARIO ===============================================
ListSerieFacturaSubForm::ListSerieFacturaSubForm(QWidget *parent) : SubForm2Bf(parent) {
    setDBTableName("serie_factura");
    setDBCampoId("codigoserie_factura");
    addSHeader("codigoserie_facturaorig", DBCampo::DBvarchar, DBCampo::DBDupPrimaryKey | DBCampo::DBNoSave, SHeader::DBNoView | SHeader::DBBlockView, "codigoserie_factura");
    addSHeader("codigoserie_factura", DBCampo::DBvarchar, DBCampo::DBNotNull, SHeader::DBNone, tr("Codigo serie factura"));
    addSHeader("descserie_factura", DBCampo::DBvarchar, DBCampo::DBNotNull, SHeader::DBNone, tr("Descripcion serie factura"));
    setinsercion(TRUE);
}

