/***************************************************************************
 *   Copyright (C) 2004 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *   Copyright (C) 2006 by Fco. Javier M. C. (Porting to QT4)              *
 *   fcojavmc@todo-redes.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QMessageBox>
#include <QWidget>
#include <QComboBox>
#include <QToolButton>
#include <QTextStream>
#include <QLayout>
#include <QMessageBox>

#include <fstream>

#include "listalmacenview.h"
#include "company.h"
#include "configuracion.h"
#include "busquedacliente.h"
#include "busquedafecha.h"

#include "funcaux.h"


ListAlmacenView::ListAlmacenView(company *comp, QWidget *parent)
        : Ficha(parent) {
    _depura("ListAlmacenView::ListAlmacenView", 1);
    setAttribute(Qt::WA_DeleteOnClose);
    setupUi(this);
    companyact = comp;
    mui_listado->setcompany(comp);
    mui_listado->cargar();
    companyact->meteWindow(windowTitle(), this);
    _depura("END ListAlmacenView::ListAlmacenView", 1);
}


void ListAlmacenView::on_mui_aceptar_clicked() {
    try {
        mui_listado->guardar();
        close();
    } catch (...) {
        mensajeInfo("Error al guardar los almacenes");
    } // end try
}


ListAlmacenView::~ListAlmacenView() {
    _depura("ListAlmacenView::~ListAlmacenView", 0);
    _depura("END ListAlmacenView::~ListAlmacenView", 0);
}


int ListAlmacenView::sacaWindow() {
    companyact->sacaWindow(this);
    return 0;
}

/// ===================================== SUBFORMULARIO ===============================================
ListAlmacenSubForm::ListAlmacenSubForm(QWidget *parent) : SubForm2Bf(parent) {
    setDBTableName("almacen");
    setDBCampoId("idalmacen");
    addSHeader("idalmacen", DBCampo::DBint, DBCampo::DBPrimaryKey, SHeader::DBNoView, tr("Id almacen"));
    addSHeader("codigoalmacen", DBCampo::DBvarchar, DBCampo::DBNotNull, SHeader::DBNone, tr("Codigo almacen"));
    addSHeader("nomalmacen", DBCampo::DBvarchar, DBCampo::DBNotNull, SHeader::DBNone, tr("Nombre almacen"));
    setinsercion(TRUE);
}

void ListAlmacenSubForm::cargar() {
        _depura("ListAlmacenSubForm::cargar", 0);
        cursor2 * cur= companyact()->cargacursor("SELECT * FROM almacen");
        SubForm3::cargar(cur);
        delete cur;
        _depura("END ListAlmacenSubForm::cargar", 0);
}