# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Rick Spencer rick.spencer@canonical.com
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3, as published 
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
import os
import gtk

from bughugger.bughuggerconfig import getdatapath
from desktopcouch.records.couchgrid import CouchGrid

class JsonsearchesDialog(gtk.Dialog):
    __gtype_name__ = "JsonsearchesDialog"

    def __init__(self):
        """__init__ - This function is typically not called directly.
        Creation of a JsonsearchesDialog requires redeading the associated ui
        file and parsing the ui definition extrenally, 
        and then calling JsonsearchesDialog.finish_initializing().
    
        Use the convenience function NewJsonsearchesDialog to create 
        a JsonsearchesDialog object.
    
        """
        pass

    def finish_initializing(self, builder):
        """finish_initalizing should be called after parsing the ui definition
        and creating a JsonsearchesDialog object with it in order to finish
        initializing the start of the new JsonsearchesDialog instance.
    
        """
        #get a reference to the builder and set up the signals
        self.builder = builder
        self.builder.connect_signals(self)
        record_type = "http://wiki.ubuntu.com/Quickly/BughuggerUrlSearch"
        keys = ["search_name","url"]
        database = "bughugger"
        self.__grid = CouchGrid(database, record_type, keys)
        self.__grid.editable = True
        self.__grid.show()
        self.builder.get_object("vbox1").pack_start(self.__grid)

        if len(self.__grid.get_model()) == 0:
            #there are no json searches, let's blast some in

            self.__grid.append_row(("server subscribed","http://qa.ubuntu.com/reports/team-subscribed/ubuntu-server-subscribed-bug-tasks.json"))
            self.__grid.append_row(("deskstop subscribed","http://qa.ubuntu.com/reports/team-subscribed/canonical-desktop-team-subscribed-bug-tasks.json"))
            self.__grid.append_row(("foundations subscribed","http://qa.ubuntu.com/reports/team-subscribed/canonical-foundations-subscribed-bug-tasks.json"))

            self.__grid.append_row(("desktop assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-desktop-team-assigned-bug-tasks.json"))
            self.__grid.append_row(("foundations assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-foundations-assigned-bug-tasks.json"))
            self.__grid.append_row(("kernel assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-kernel-team-assigned-bug-tasks.json"))
            self.__grid.append_row(("mobile assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-mobile-assigned-bug-tasks.json"))
            self.__grid.append_row(("server assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-server-assigned-bug-tasks.json"))
            self.__grid.append_row(("qa assigned","http://qa.ubuntu.com/reports/team-assigned/canonical-qa-assigned-bug-tasks.json"))

            self.__grid.append_row(("no package bugs","http://qa.ubuntu.com/reports/package/no-package-bugs.json"))
            self.__grid.append_row(("linux package bugs","http://qa.ubuntu.com/reports/package/linux-package-bugs.json"))

    def add_row(self, widget, data=None):
        self.__grid.append_row([])

    def delete_row(self, widget, data=None):
        delete_on_remove = True

        #get the selected rows, and return if nothing is selected
        model, rows = self.__grid.get_selection().get_selected_rows()
        if len(rows) == 0:
            return

        #the last column in the model holds the record_id
        id_index = model.get_n_columns() - 1
        
        #loop through and remove
        iters = [model.get_iter(path) for path in rows]
        for i in iters:
            record_id = self.__grid.get_model().get_value(i,id_index)
            self.__grid.get_model().remove(i)

            #delete the row if desired, but don't try to delete rows
            #that haven't been saved
            if delete_on_remove and record_id != "":
                self.__grid.database.delete_record(record_id)


    def run_search(self, widget, data=None):
        self.url = self.__grid.selected_rows[0]["url"]
        self.search_name = self.__grid.selected_rows[0]["search_name"]
        self.response(-5)

    def ok(self, widget, data=None):
        """ok - The user has elected to save the changes.
        Called before the dialog returns gtk.RESONSE_OK from run().

        """
        pass

    def cancel(self, widget, data=None):
        """cancel - The user has elected cancel changes.
        Called before the dialog returns gtk.RESPONSE_CANCEL for run()

        """         
        pass

def NewJsonsearchesDialog():
    """NewJsonsearchesDialog - returns a fully instantiated
    dialog-camel_case_nameDialog object. Use this function rather than
    creating JsonsearchesDialog instance directly.
    
    """

    #look for the ui file that describes the ui
    ui_filename = os.path.join(getdatapath(), 'ui', 'JsonsearchesDialog.ui')
    if not os.path.exists(ui_filename):
        ui_filename = None

    builder = gtk.Builder()
    builder.add_from_file(ui_filename)    
    dialog = builder.get_object("jsonsearches_dialog")
    dialog.finish_initializing(builder)
    return dialog

if __name__ == "__main__":
    dialog = NewJsonsearchesDialog()
    dialog.show()
    gtk.main()

