/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "SystemInfoDisks.h"
#include "SystemCall.h"
#include <vector>
using namespace std;

const QString SystemInfoDisks::d_hdr_label[NumberOfColumns] = {
	QT_TR_NOOP( "File system" ),
	QT_TR_NOOP( "Type" ),
	QT_TR_NOOP( "Size" ),
	QT_TR_NOOP( "Used" ),
	QT_TR_NOOP( "Available" ),
	QT_TR_NOOP( "Use" ),
	QT_TR_NOOP( "Mounted on" )
};


//*******************************************************************
// SystemInfoDisks                                       CONSTRUCTOR
//*******************************************************************
SystemInfoDisks::SystemInfoDisks( QWidget* const in_parent )
: QListView( in_parent )
, d_syscall( new SystemCall( this ) )
{
	for( int i = 0; i < NumberOfColumns; ++i ) {
		addColumn( tr( d_hdr_label[i] ) );
		setColumnAlignment( i, ( i == FileSystem || i == Mount ) ? Qt::AlignLeft : Qt::AlignRight );
	}
	setSelectionMode( Extended );
	setAllColumnsShowFocus( TRUE );
	setSorting( -1 );
	
	connect( d_syscall, SIGNAL( finished( int ) ), this, SLOT( finished( int ) ));
	vector<QString> parameters;
	parameters.push_back( "df" );
	parameters.push_back( "-h" );
	parameters.push_back( "-T" );
	d_syscall->run( parameters );
}
// end of SystemInfoDisks

//*******************************************************************
// ~SystemInfoDisks                                       DESTRUCTOR
//*******************************************************************
SystemInfoDisks::~SystemInfoDisks()
{
	if( d_syscall ) {
		delete d_syscall;
		d_syscall = 0;
	}
}
// end of ~SystemInfoDisks

//*******************************************************************
// finished                                             PRIVATE slot
//*******************************************************************
void SystemInfoDisks::finished( int )
{
	vector<QString> stdout_lines;
	vector<QString> stderr_lines;
		
	d_syscall->result( stdout_lines, stderr_lines );
	delete d_syscall;
	d_syscall = 0;
		
	if( FALSE == stdout_lines.empty() ) {
		QStringList lines = QStringList::split( '\n', stdout_lines[0] );
		QStringList::Iterator it = lines.begin();
		++it;
		while( it != lines.end() ) {
			add_item( *it );
			++it;
		}
	}
}
// end of finished

//*******************************************************************
// add_item                                                  PRIVATE
//********************************************************************
void SystemInfoDisks::add_item( const QString& in_line )
{
	const QStringList elements = QStringList::split( ' ', in_line );
	
	QListViewItem* const item = new QListViewItem( this );
	if( item ) {
		const int n = elements.size();
		for( int i = 0; i < n; ++i ) {
			item->setText( i, elements[i] );
		}
	}
}
// end of add_item
