/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SYSTEMCALL_H
#define INCLUDED_SYSTEMCALL_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/
class QProcess;

class SystemCall : public QDialog
{
	Q_OBJECT
	
// ******* TYPES *******
public:
	typedef enum {
		OFF_LINE = 0,
		ON_LINE
	} Mode;
	
// ******* CONSTRUCTION *******
public:
	SystemCall( QWidget* );
	~SystemCall();
private:
	SystemCall( const SystemCall& );
	SystemCall& operator=( const SystemCall& );

// ******* MEMBERS *******
private:
	QProcess* d_process;
	std::vector<QString> d_cout_strings;
	std::vector<QString> d_cerr_strings;
	Mode      d_mode;
	QString   d_stdout_buffer;
	QString   d_stderr_buffer;
	
// ******* METHODS *******
public:
	bool run           ( const std::vector<QString>&, const Mode = OFF_LINE );
	void result        ( std::vector<QString>&, std::vector<QString>& );
private:
	void delproc       ();
	void keyPressEvent( QKeyEvent* );
private slots:
	void read_stdout   ();
	void read_stderr   ();
	void process_exited();
signals:
	void finished      ( int );
	void stdout_line   ( const QString& );
	void stderr_line   ( const QString& );
};

#endif // INCLUDED_SYSTEMCALL_H
