/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_LIMITS_H
#define INCLUDED_LIMITS_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- class declaration (singleton):
-------------------------------------------------------------------*/
class Limits : public QObject
{
	Q_OBJECT
private:
	Limits();
	Limits( const Limits& );
	Limits& operator=( const Limits& );

// ******* CONSTANTS *******
private:
	static const QString FilePath;
	static const QString AcceptPrefix;
	static const QString BlockPrefix;
	static const QString HomePrefix;
	static const QString CommentMark;
	static const QString MsgCaption;
	static const QString MsgInfo;

// ******* MEMBERS *******
private:
	static Limits*       d_instance;
	bool                 d_apply;
	std::vector<QString> d_accepted;
	std::vector<QString> d_blocked;
	
// ******* METHODS *******
public:
	static Limits* instance();
	void   refresh ();
	bool   accepted( const QString& );
	bool   apply   () const;
private:
	void   check_home_dir( QString& );
};

//*******************************************************************
// apply                                                      PUBLIC
//*******************************************************************
inline bool Limits::apply() const
{
	return d_apply;
}
// end of apply

#endif // INCLUDED_LIMITS_H
