// distribution boxbackup-0.10 (svn version: 494)
//  
// Copyright (c) 2003 - 2006
//      Ben Summers and contributors.  All rights reserved.
//  
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All use of this software and associated advertising materials must 
//    display the following acknowledgment:
//        This product includes software developed by Ben Summers.
// 4. The names of the Authors may not be used to endorse or promote
//    products derived from this software without specific prior written
//    permission.
// 
// [Where legally impermissible the Authors do not disclaim liability for 
// direct physical injury or death caused solely by defects in the software 
// unless it is modified by a third party.]
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
// ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//  
//  
//  
// win32test.cpp : Defines the entry point for the console application.
//

//#include <windows.h>
#include "Box.h"

#ifdef WIN32

#include "../../bin/bbackupd/BackupDaemon.h"
#include "BoxPortsAndFiles.h"
#include "emu.h"

int main(int argc, char* argv[])
{
	chdir("c:\\tmp");
	openfile("test", O_CREAT, 0);
	struct stat ourfs;
	//test our opendir, readdir and closedir
	//functions
	DIR *ourDir = opendir("C:");

	if ( ourDir != NULL )
	{
		struct dirent *info;
		do
		{
			info = readdir(ourDir);
			if ( info ) printf("File/Dir name is : %s\r\n", info->d_name);

		}while ( info != NULL );

		closedir(ourDir);

	}
	
	std::string diry("C:\\Projects\\boxbuild\\testfiles\\");
	ourDir = opendir(diry.c_str());
	if ( ourDir != NULL )
	{
		struct dirent *info;
		do
		{
			info = readdir(ourDir);
			if ( info == NULL ) break;
			std::string file(diry + info->d_name);
			stat(file.c_str(), &ourfs);
			if ( info ) printf("File/Dir name is : %s\r\n", info->d_name);

		}while ( info != NULL );

		closedir(ourDir);

	}

	stat("c:\\windows", &ourfs);
	stat("c:\\autoexec.bat", &ourfs);
	printf("Finished dir read");
#if 0
	//remove - sleepycat include a version of getopt - mine never REALLY worked !
	//test our getopt function
	std::string commline("-q -c fgfgfg -f -l hello");

	int c;
	while((c = getopt(commline.size(), (char * const *)commline.c_str(), "qwc:l:")) != -1)
	{
		printf("switch = %c, param is %s\r\n", c, optarg);
	}
#endif
	//end of getopt test
	
	//now test our statfs funct
	stat("c:\\cert.cer", &ourfs);
	
	

	char *timee;
	
	timee = ctime(&ourfs.st_mtime);

	if ( S_ISREG(ourfs.st_mode))
	{
		printf("is a normal file");
	}
	else
	{
		printf("is a directory?");
	}

	lstat("c:\\windows", &ourfs);

	if ( S_ISDIR(ourfs.st_mode))
	{
		printf("is a directory");
	}
	else
	{
		printf("is a file?");
	}

	//test the syslog functions
	openlog("Box Backup", 0,0);
	//the old ones are the best...
	syslog(LOG_ERR, "Hello World");
	syslog(LOG_ERR, "Value of int is: %i", 6);

	closelog();

	//first off get the path name for the default 
	char buf[MAX_PATH];
	
	GetModuleFileName(NULL, buf, sizeof(buf));
	std::string buffer(buf);
	std::string conf("-c " + buffer.substr(0,(buffer.find("win32test.exe"))) + "bbackupd.conf");
	//std::string conf( "-c " + buffer.substr(0,(buffer.find("bbackupd.exe"))) + "bbackupd.conf");


	return 0;
}

#endif // WIN32
