#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast
{
	using System;
	
	public partial class DepthFirstVisitor : IAstVisitor
	{

		public virtual void OnCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{				
			if (EnterCompileUnit(node))
			{
				Visit(node.Modules);
				LeaveCompileUnit(node);
			}
		}
			
		public virtual bool EnterCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{
			return true;
		}
		
		public virtual void LeaveCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{
		}

		public virtual void OnExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{				
			if (EnterExplicitMemberInfo(node))
			{
				Visit(node.InterfaceType);
				LeaveExplicitMemberInfo(node);
			}
		}
			
		public virtual bool EnterExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{
			return true;
		}
		
		public virtual void LeaveExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{
		}

		public virtual void OnSimpleTypeReference(Boo.Lang.Compiler.Ast.SimpleTypeReference node)
		{
		}

		public virtual void OnArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{				
			if (EnterArrayTypeReference(node))
			{
				Visit(node.ElementType);
				Visit(node.Rank);
				LeaveArrayTypeReference(node);
			}
		}
			
		public virtual bool EnterArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{
			return true;
		}
		
		public virtual void LeaveArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{
		}

		public virtual void OnCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{				
			if (EnterCallableTypeReference(node))
			{
				Visit(node.Parameters);
				Visit(node.ReturnType);
				LeaveCallableTypeReference(node);
			}
		}
			
		public virtual bool EnterCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{
			return true;
		}
		
		public virtual void LeaveCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{
		}

		public virtual void OnGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{				
			if (EnterGenericTypeReference(node))
			{
				Visit(node.GenericArguments);
				LeaveGenericTypeReference(node);
			}
		}
			
		public virtual bool EnterGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{
			return true;
		}
		
		public virtual void LeaveGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{
		}

		public virtual void OnGenericTypeDefinitionReference(Boo.Lang.Compiler.Ast.GenericTypeDefinitionReference node)
		{
		}

		public virtual void OnCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{				
			if (EnterCallableDefinition(node))
			{
				Visit(node.Attributes);
				Visit(node.Parameters);
				Visit(node.GenericParameters);
				Visit(node.ReturnType);
				Visit(node.ReturnTypeAttributes);
				LeaveCallableDefinition(node);
			}
		}
			
		public virtual bool EnterCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{
			return true;
		}
		
		public virtual void LeaveCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{
		}

		public virtual void OnNamespaceDeclaration(Boo.Lang.Compiler.Ast.NamespaceDeclaration node)
		{
		}

		public virtual void OnImport(Boo.Lang.Compiler.Ast.Import node)
		{				
			if (EnterImport(node))
			{
				Visit(node.AssemblyReference);
				Visit(node.Alias);
				LeaveImport(node);
			}
		}
			
		public virtual bool EnterImport(Boo.Lang.Compiler.Ast.Import node)
		{
			return true;
		}
		
		public virtual void LeaveImport(Boo.Lang.Compiler.Ast.Import node)
		{
		}

		public virtual void OnModule(Boo.Lang.Compiler.Ast.Module node)
		{				
			if (EnterModule(node))
			{
				Visit(node.Attributes);
				Visit(node.Members);
				Visit(node.BaseTypes);
				Visit(node.GenericParameters);
				Visit(node.Namespace);
				Visit(node.Imports);
				Visit(node.Globals);
				Visit(node.AssemblyAttributes);
				LeaveModule(node);
			}
		}
			
		public virtual bool EnterModule(Boo.Lang.Compiler.Ast.Module node)
		{
			return true;
		}
		
		public virtual void LeaveModule(Boo.Lang.Compiler.Ast.Module node)
		{
		}

		public virtual void OnClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{				
			if (EnterClassDefinition(node))
			{
				Visit(node.Attributes);
				Visit(node.Members);
				Visit(node.BaseTypes);
				Visit(node.GenericParameters);
				LeaveClassDefinition(node);
			}
		}
			
		public virtual bool EnterClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{
			return true;
		}
		
		public virtual void LeaveClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{
		}

		public virtual void OnStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{				
			if (EnterStructDefinition(node))
			{
				Visit(node.Attributes);
				Visit(node.Members);
				Visit(node.BaseTypes);
				Visit(node.GenericParameters);
				LeaveStructDefinition(node);
			}
		}
			
		public virtual bool EnterStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{
			return true;
		}
		
		public virtual void LeaveStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{
		}

		public virtual void OnInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{				
			if (EnterInterfaceDefinition(node))
			{
				Visit(node.Attributes);
				Visit(node.Members);
				Visit(node.BaseTypes);
				Visit(node.GenericParameters);
				LeaveInterfaceDefinition(node);
			}
		}
			
		public virtual bool EnterInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{
			return true;
		}
		
		public virtual void LeaveInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{
		}

		public virtual void OnEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{				
			if (EnterEnumDefinition(node))
			{
				Visit(node.Attributes);
				Visit(node.Members);
				Visit(node.BaseTypes);
				Visit(node.GenericParameters);
				LeaveEnumDefinition(node);
			}
		}
			
		public virtual bool EnterEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{
			return true;
		}
		
		public virtual void LeaveEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{
		}

		public virtual void OnEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{				
			if (EnterEnumMember(node))
			{
				Visit(node.Attributes);
				Visit(node.Initializer);
				LeaveEnumMember(node);
			}
		}
			
		public virtual bool EnterEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{
			return true;
		}
		
		public virtual void LeaveEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{
		}

		public virtual void OnField(Boo.Lang.Compiler.Ast.Field node)
		{				
			if (EnterField(node))
			{
				Visit(node.Attributes);
				Visit(node.Type);
				Visit(node.Initializer);
				LeaveField(node);
			}
		}
			
		public virtual bool EnterField(Boo.Lang.Compiler.Ast.Field node)
		{
			return true;
		}
		
		public virtual void LeaveField(Boo.Lang.Compiler.Ast.Field node)
		{
		}

		public virtual void OnProperty(Boo.Lang.Compiler.Ast.Property node)
		{				
			if (EnterProperty(node))
			{
				Visit(node.Attributes);
				Visit(node.Parameters);
				Visit(node.Getter);
				Visit(node.Setter);
				Visit(node.Type);
				Visit(node.ExplicitInfo);
				LeaveProperty(node);
			}
		}
			
		public virtual bool EnterProperty(Boo.Lang.Compiler.Ast.Property node)
		{
			return true;
		}
		
		public virtual void LeaveProperty(Boo.Lang.Compiler.Ast.Property node)
		{
		}

		public virtual void OnEvent(Boo.Lang.Compiler.Ast.Event node)
		{				
			if (EnterEvent(node))
			{
				Visit(node.Attributes);
				Visit(node.Add);
				Visit(node.Remove);
				Visit(node.Raise);
				Visit(node.Type);
				LeaveEvent(node);
			}
		}
			
		public virtual bool EnterEvent(Boo.Lang.Compiler.Ast.Event node)
		{
			return true;
		}
		
		public virtual void LeaveEvent(Boo.Lang.Compiler.Ast.Event node)
		{
		}

		public virtual void OnLocal(Boo.Lang.Compiler.Ast.Local node)
		{
		}

		public virtual void OnBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{				
			if (EnterBlockExpression(node))
			{
				Visit(node.Parameters);
				Visit(node.ReturnType);
				Visit(node.Body);
				LeaveBlockExpression(node);
			}
		}
			
		public virtual bool EnterBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{
			return true;
		}
		
		public virtual void LeaveBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{
		}

		public virtual void OnMethod(Boo.Lang.Compiler.Ast.Method node)
		{				
			if (EnterMethod(node))
			{
				Visit(node.Attributes);
				Visit(node.Parameters);
				Visit(node.GenericParameters);
				Visit(node.ReturnType);
				Visit(node.ReturnTypeAttributes);
				Visit(node.Body);
				Visit(node.Locals);
				Visit(node.ExplicitInfo);
				LeaveMethod(node);
			}
		}
			
		public virtual bool EnterMethod(Boo.Lang.Compiler.Ast.Method node)
		{
			return true;
		}
		
		public virtual void LeaveMethod(Boo.Lang.Compiler.Ast.Method node)
		{
		}

		public virtual void OnConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{				
			if (EnterConstructor(node))
			{
				Visit(node.Attributes);
				Visit(node.Parameters);
				Visit(node.GenericParameters);
				Visit(node.ReturnType);
				Visit(node.ReturnTypeAttributes);
				Visit(node.Body);
				Visit(node.Locals);
				Visit(node.ExplicitInfo);
				LeaveConstructor(node);
			}
		}
			
		public virtual bool EnterConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{
			return true;
		}
		
		public virtual void LeaveConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{
		}

		public virtual void OnDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{				
			if (EnterDestructor(node))
			{
				Visit(node.Attributes);
				Visit(node.Parameters);
				Visit(node.GenericParameters);
				Visit(node.ReturnType);
				Visit(node.ReturnTypeAttributes);
				Visit(node.Body);
				Visit(node.Locals);
				Visit(node.ExplicitInfo);
				LeaveDestructor(node);
			}
		}
			
		public virtual bool EnterDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{
			return true;
		}
		
		public virtual void LeaveDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{
		}

		public virtual void OnParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{				
			if (EnterParameterDeclaration(node))
			{
				Visit(node.Type);
				Visit(node.Attributes);
				LeaveParameterDeclaration(node);
			}
		}
			
		public virtual bool EnterParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{
			return true;
		}
		
		public virtual void LeaveParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{
		}

		public virtual void OnGenericParameterDeclaration(Boo.Lang.Compiler.Ast.GenericParameterDeclaration node)
		{
		}

		public virtual void OnDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{				
			if (EnterDeclaration(node))
			{
				Visit(node.Type);
				LeaveDeclaration(node);
			}
		}
			
		public virtual bool EnterDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{
			return true;
		}
		
		public virtual void LeaveDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{
		}

		public virtual void OnAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{				
			if (EnterAttribute(node))
			{
				Visit(node.Arguments);
				Visit(node.NamedArguments);
				LeaveAttribute(node);
			}
		}
			
		public virtual bool EnterAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{
			return true;
		}
		
		public virtual void LeaveAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{
		}

		public virtual void OnStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{				
			if (EnterStatementModifier(node))
			{
				Visit(node.Condition);
				LeaveStatementModifier(node);
			}
		}
			
		public virtual bool EnterStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{
			return true;
		}
		
		public virtual void LeaveStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{
		}

		public virtual void OnGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{				
			if (EnterGotoStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Label);
				LeaveGotoStatement(node);
			}
		}
			
		public virtual bool EnterGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{
			return true;
		}
		
		public virtual void LeaveGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{
		}

		public virtual void OnLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{				
			if (EnterLabelStatement(node))
			{
				Visit(node.Modifier);
				LeaveLabelStatement(node);
			}
		}
			
		public virtual bool EnterLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{
			return true;
		}
		
		public virtual void LeaveLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{
		}

		public virtual void OnBlock(Boo.Lang.Compiler.Ast.Block node)
		{				
			if (EnterBlock(node))
			{
				Visit(node.Modifier);
				Visit(node.Statements);
				LeaveBlock(node);
			}
		}
			
		public virtual bool EnterBlock(Boo.Lang.Compiler.Ast.Block node)
		{
			return true;
		}
		
		public virtual void LeaveBlock(Boo.Lang.Compiler.Ast.Block node)
		{
		}

		public virtual void OnDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{				
			if (EnterDeclarationStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Declaration);
				Visit(node.Initializer);
				LeaveDeclarationStatement(node);
			}
		}
			
		public virtual bool EnterDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{
			return true;
		}
		
		public virtual void LeaveDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{
		}

		public virtual void OnMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{				
			if (EnterMacroStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Arguments);
				Visit(node.Block);
				LeaveMacroStatement(node);
			}
		}
			
		public virtual bool EnterMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{
			return true;
		}
		
		public virtual void LeaveMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{
		}

		public virtual void OnTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{				
			if (EnterTryStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.ProtectedBlock);
				Visit(node.ExceptionHandlers);
				Visit(node.EnsureBlock);
				LeaveTryStatement(node);
			}
		}
			
		public virtual bool EnterTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{
			return true;
		}
		
		public virtual void LeaveTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{
		}

		public virtual void OnExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{				
			if (EnterExceptionHandler(node))
			{
				Visit(node.Declaration);
				Visit(node.Block);
				LeaveExceptionHandler(node);
			}
		}
			
		public virtual bool EnterExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{
			return true;
		}
		
		public virtual void LeaveExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{
		}

		public virtual void OnIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{				
			if (EnterIfStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Condition);
				Visit(node.TrueBlock);
				Visit(node.FalseBlock);
				LeaveIfStatement(node);
			}
		}
			
		public virtual bool EnterIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{
			return true;
		}
		
		public virtual void LeaveIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{
		}

		public virtual void OnUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{				
			if (EnterUnlessStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Condition);
				Visit(node.Block);
				LeaveUnlessStatement(node);
			}
		}
			
		public virtual bool EnterUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{
			return true;
		}
		
		public virtual void LeaveUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{
		}

		public virtual void OnForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{				
			if (EnterForStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Declarations);
				Visit(node.Iterator);
				Visit(node.Block);
				LeaveForStatement(node);
			}
		}
			
		public virtual bool EnterForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{
			return true;
		}
		
		public virtual void LeaveForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{
		}

		public virtual void OnWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{				
			if (EnterWhileStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Condition);
				Visit(node.Block);
				LeaveWhileStatement(node);
			}
		}
			
		public virtual bool EnterWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{
			return true;
		}
		
		public virtual void LeaveWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{
		}

		public virtual void OnBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{				
			if (EnterBreakStatement(node))
			{
				Visit(node.Modifier);
				LeaveBreakStatement(node);
			}
		}
			
		public virtual bool EnterBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{
			return true;
		}
		
		public virtual void LeaveBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{
		}

		public virtual void OnContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{				
			if (EnterContinueStatement(node))
			{
				Visit(node.Modifier);
				LeaveContinueStatement(node);
			}
		}
			
		public virtual bool EnterContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{
			return true;
		}
		
		public virtual void LeaveContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{
		}

		public virtual void OnReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{				
			if (EnterReturnStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Expression);
				LeaveReturnStatement(node);
			}
		}
			
		public virtual bool EnterReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{
			return true;
		}
		
		public virtual void LeaveReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{
		}

		public virtual void OnYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{				
			if (EnterYieldStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Expression);
				LeaveYieldStatement(node);
			}
		}
			
		public virtual bool EnterYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{
			return true;
		}
		
		public virtual void LeaveYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{
		}

		public virtual void OnRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{				
			if (EnterRaiseStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Exception);
				LeaveRaiseStatement(node);
			}
		}
			
		public virtual bool EnterRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{
			return true;
		}
		
		public virtual void LeaveRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{
		}

		public virtual void OnUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{				
			if (EnterUnpackStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Declarations);
				Visit(node.Expression);
				LeaveUnpackStatement(node);
			}
		}
			
		public virtual bool EnterUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{
			return true;
		}
		
		public virtual void LeaveUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{
		}

		public virtual void OnExpressionStatement(Boo.Lang.Compiler.Ast.ExpressionStatement node)
		{				
			if (EnterExpressionStatement(node))
			{
				Visit(node.Modifier);
				Visit(node.Expression);
				LeaveExpressionStatement(node);
			}
		}
			
		public virtual bool EnterExpressionStatement(Boo.Lang.Compiler.Ast.ExpressionStatement node)
		{
			return true;
		}
		
		public virtual void LeaveExpressionStatement(Boo.Lang.Compiler.Ast.ExpressionStatement node)
		{
		}

		public virtual void OnOmittedExpression(Boo.Lang.Compiler.Ast.OmittedExpression node)
		{
		}

		public virtual void OnExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{				
			if (EnterExpressionPair(node))
			{
				Visit(node.First);
				Visit(node.Second);
				LeaveExpressionPair(node);
			}
		}
			
		public virtual bool EnterExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{
			return true;
		}
		
		public virtual void LeaveExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{
		}

		public virtual void OnMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{				
			if (EnterMethodInvocationExpression(node))
			{
				Visit(node.Target);
				Visit(node.Arguments);
				Visit(node.NamedArguments);
				LeaveMethodInvocationExpression(node);
			}
		}
			
		public virtual bool EnterMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{
			return true;
		}
		
		public virtual void LeaveMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{
		}

		public virtual void OnUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{				
			if (EnterUnaryExpression(node))
			{
				Visit(node.Operand);
				LeaveUnaryExpression(node);
			}
		}
			
		public virtual bool EnterUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{
			return true;
		}
		
		public virtual void LeaveUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{
		}

		public virtual void OnBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{				
			if (EnterBinaryExpression(node))
			{
				Visit(node.Left);
				Visit(node.Right);
				LeaveBinaryExpression(node);
			}
		}
			
		public virtual bool EnterBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{
			return true;
		}
		
		public virtual void LeaveBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{
		}

		public virtual void OnConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{				
			if (EnterConditionalExpression(node))
			{
				Visit(node.Condition);
				Visit(node.TrueValue);
				Visit(node.FalseValue);
				LeaveConditionalExpression(node);
			}
		}
			
		public virtual bool EnterConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{
			return true;
		}
		
		public virtual void LeaveConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{
		}

		public virtual void OnReferenceExpression(Boo.Lang.Compiler.Ast.ReferenceExpression node)
		{
		}

		public virtual void OnMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{				
			if (EnterMemberReferenceExpression(node))
			{
				Visit(node.Target);
				LeaveMemberReferenceExpression(node);
			}
		}
			
		public virtual bool EnterMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{
			return true;
		}
		
		public virtual void LeaveMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{
		}

		public virtual void OnGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{				
			if (EnterGenericReferenceExpression(node))
			{
				Visit(node.Target);
				Visit(node.GenericArguments);
				LeaveGenericReferenceExpression(node);
			}
		}
			
		public virtual bool EnterGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{
			return true;
		}
		
		public virtual void LeaveGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{
		}

		public virtual void OnQuasiquoteExpression(Boo.Lang.Compiler.Ast.QuasiquoteExpression node)
		{
		}

		public virtual void OnStringLiteralExpression(Boo.Lang.Compiler.Ast.StringLiteralExpression node)
		{
		}

		public virtual void OnCharLiteralExpression(Boo.Lang.Compiler.Ast.CharLiteralExpression node)
		{
		}

		public virtual void OnTimeSpanLiteralExpression(Boo.Lang.Compiler.Ast.TimeSpanLiteralExpression node)
		{
		}

		public virtual void OnIntegerLiteralExpression(Boo.Lang.Compiler.Ast.IntegerLiteralExpression node)
		{
		}

		public virtual void OnDoubleLiteralExpression(Boo.Lang.Compiler.Ast.DoubleLiteralExpression node)
		{
		}

		public virtual void OnNullLiteralExpression(Boo.Lang.Compiler.Ast.NullLiteralExpression node)
		{
		}

		public virtual void OnSelfLiteralExpression(Boo.Lang.Compiler.Ast.SelfLiteralExpression node)
		{
		}

		public virtual void OnSuperLiteralExpression(Boo.Lang.Compiler.Ast.SuperLiteralExpression node)
		{
		}

		public virtual void OnBoolLiteralExpression(Boo.Lang.Compiler.Ast.BoolLiteralExpression node)
		{
		}

		public virtual void OnRELiteralExpression(Boo.Lang.Compiler.Ast.RELiteralExpression node)
		{
		}

		public virtual void OnSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{				
			if (EnterSpliceExpression(node))
			{
				Visit(node.Expression);
				LeaveSpliceExpression(node);
			}
		}
			
		public virtual bool EnterSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{
			return true;
		}
		
		public virtual void LeaveSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{
		}

		public virtual void OnSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{				
			if (EnterSpliceTypeReference(node))
			{
				Visit(node.Expression);
				LeaveSpliceTypeReference(node);
			}
		}
			
		public virtual bool EnterSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{
			return true;
		}
		
		public virtual void LeaveSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{
		}

		public virtual void OnSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{				
			if (EnterSpliceMemberReferenceExpression(node))
			{
				Visit(node.Target);
				Visit(node.NameExpression);
				LeaveSpliceMemberReferenceExpression(node);
			}
		}
			
		public virtual bool EnterSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{
			return true;
		}
		
		public virtual void LeaveSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{
		}

		public virtual void OnSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{				
			if (EnterSpliceTypeMember(node))
			{
				Visit(node.Attributes);
				Visit(node.TypeMember);
				Visit(node.NameExpression);
				LeaveSpliceTypeMember(node);
			}
		}
			
		public virtual bool EnterSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{
			return true;
		}
		
		public virtual void LeaveSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{
		}

		public virtual void OnExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{				
			if (EnterExpressionInterpolationExpression(node))
			{
				Visit(node.Expressions);
				LeaveExpressionInterpolationExpression(node);
			}
		}
			
		public virtual bool EnterExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{
			return true;
		}
		
		public virtual void LeaveExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{
		}

		public virtual void OnHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{				
			if (EnterHashLiteralExpression(node))
			{
				Visit(node.Items);
				LeaveHashLiteralExpression(node);
			}
		}
			
		public virtual bool EnterHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{
			return true;
		}
		
		public virtual void LeaveHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{
		}

		public virtual void OnListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{				
			if (EnterListLiteralExpression(node))
			{
				Visit(node.Items);
				LeaveListLiteralExpression(node);
			}
		}
			
		public virtual bool EnterListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{
			return true;
		}
		
		public virtual void LeaveListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{
		}

		public virtual void OnArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{				
			if (EnterArrayLiteralExpression(node))
			{
				Visit(node.Items);
				Visit(node.Type);
				LeaveArrayLiteralExpression(node);
			}
		}
			
		public virtual bool EnterArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{
			return true;
		}
		
		public virtual void LeaveArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{
		}

		public virtual void OnGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{				
			if (EnterGeneratorExpression(node))
			{
				Visit(node.Expression);
				Visit(node.Declarations);
				Visit(node.Iterator);
				Visit(node.Filter);
				LeaveGeneratorExpression(node);
			}
		}
			
		public virtual bool EnterGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{
			return true;
		}
		
		public virtual void LeaveGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{
		}

		public virtual void OnExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{				
			if (EnterExtendedGeneratorExpression(node))
			{
				Visit(node.Items);
				LeaveExtendedGeneratorExpression(node);
			}
		}
			
		public virtual bool EnterExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{
			return true;
		}
		
		public virtual void LeaveExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{
		}

		public virtual void OnSlice(Boo.Lang.Compiler.Ast.Slice node)
		{				
			if (EnterSlice(node))
			{
				Visit(node.Begin);
				Visit(node.End);
				Visit(node.Step);
				LeaveSlice(node);
			}
		}
			
		public virtual bool EnterSlice(Boo.Lang.Compiler.Ast.Slice node)
		{
			return true;
		}
		
		public virtual void LeaveSlice(Boo.Lang.Compiler.Ast.Slice node)
		{
		}

		public virtual void OnSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{				
			if (EnterSlicingExpression(node))
			{
				Visit(node.Target);
				Visit(node.Indices);
				LeaveSlicingExpression(node);
			}
		}
			
		public virtual bool EnterSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{
			return true;
		}
		
		public virtual void LeaveSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{
		}

		public virtual void OnTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{				
			if (EnterTryCastExpression(node))
			{
				Visit(node.Target);
				Visit(node.Type);
				LeaveTryCastExpression(node);
			}
		}
			
		public virtual bool EnterTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{
			return true;
		}
		
		public virtual void LeaveTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{
		}

		public virtual void OnCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{				
			if (EnterCastExpression(node))
			{
				Visit(node.Target);
				Visit(node.Type);
				LeaveCastExpression(node);
			}
		}
			
		public virtual bool EnterCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{
			return true;
		}
		
		public virtual void LeaveCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{
		}

		public virtual void OnTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{				
			if (EnterTypeofExpression(node))
			{
				Visit(node.Type);
				LeaveTypeofExpression(node);
			}
		}
			
		public virtual bool EnterTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{
			return true;
		}
		
		public virtual void LeaveTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{
		}
				
	}
}

