
#include <gtkmm.h>
#include "image.hh"
#include "src/ui-tools.hh"

namespace Bmp
{
  Image::Image ()
  : Gtk::Widget ()
  , m_surface (Cairo::RefPtr<Cairo::ImageSurface>(0))
  {
    set_flags (Gtk::NO_WINDOW); 
  }

  Image::~Image ()
  {}

  void
  Image::on_size_request (Gtk::Requisition * r)
  {
    r->width = 0;
    r->height = 0;

    if (m_surface)
    {
      r->width += m_surface->get_width();
      r->height += m_surface->get_height();
    }
  }

  bool
  Image::on_expose_event (GdkEventExpose * event)
  {
    ::Cairo::RefPtr< ::Cairo::Context> cr = get_window()->create_cairo_context();

    Gdk::Cairo::rectangle (cr, get_allocation());

    cr->translate (get_allocation().get_x(), get_allocation().get_y());
    cr->clip ();

    cr->set_operator (::Cairo::OPERATOR_CLEAR);
    cr->paint ();

    if (m_surface)
    {
      cr->set_source (m_surface, 0, 0);
      cr->set_operator (::Cairo::OPERATOR_ATOP);
      cr->paint ();
    }

    return true;
  }

  void
  Image::clear ()
  {
    m_surface = ::Cairo::RefPtr < ::Cairo::ImageSurface > (0);
    queue_draw ();
  }

  void
  Image::set (Glib::RefPtr<Gdk::Pixbuf> pixbuf)
  {
    m_surface = ::Cairo::ImageSurface::create (Cairo::FORMAT_ARGB32, pixbuf->get_width(), pixbuf->get_height()); 
    ::Cairo::RefPtr< ::Cairo::Context> cr = ::Cairo::Context::create (m_surface); 

    cr->set_operator (::Cairo::OPERATOR_CLEAR);
    cr->set_source_rgba (1., 1., 1., 1.);
    cr->rectangle (0, 0, pixbuf->get_width(), pixbuf->get_height());
    cr->fill ();

    cr->set_operator (::Cairo::OPERATOR_SOURCE);
    Gdk::Cairo::set_source_pixbuf (cr, pixbuf, 0, 0);
    cr->rectangle (0, 0, pixbuf->get_width(), pixbuf->get_height());
    cr->fill ();

    Util::cairo_image_surface_border (m_surface, 2.);
    set_size_request (pixbuf->get_width(), pixbuf->get_height());
  }

  void
  Image::set (Cairo::RefPtr<Cairo::ImageSurface> surface)
  {
    m_surface = surface;
    Util::cairo_image_surface_border (m_surface, 2.);
    set_size_request (surface->get_width(), surface->get_height());
  }
}
