/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef __A2DP_IPC_H__
#define __A2DP_IPC_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h> 
#include <sys/poll.h>
#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))

// Ipc shared
void init_ipc(int inet, char* addr, char* bcst, int port);

int make_udp_socket();
int make_client_socket();
int make_server_socket();
void setup_socket(int sockfd);
void close_socket(int *sockfd);
void close_server_socket(int *sockfd);


typedef void (*fnpollfd_cb)(struct pollfd* pollfds, void* param1, void* param2);

struct pollfd_cb_inf {
	fnpollfd_cb pollfd_cb;
	void* param1;
	void* param2;
};

struct pollinfo {
	struct pollfd* pollfds;
	struct pollfd_cb_inf* pollfds_cb;
	int maxfd;
	int pollfdcount;
	int polltimeout;
};

void add_fd_to_poll(struct pollinfo* pollinfos, int fd, int events, int timeout, fnpollfd_cb pollfd_cb, void* param1, void* param2);

int poll_accept(int sockfd, int timeout);
int poll_error(int sockfd, int timeout);
int poll_out(int sockfd, int timeout);
int accept_socket(int sockfd);
ssize_t send_socket(int sockfd, void* buffer, size_t size);
ssize_t recv_socket(int sockfd, void* buffer, size_t size);
void async_run_process(char* cmd, int wait);
void startup_a2dpd_upon_request();

// Config files shared
void get_config_filename(char* filename, size_t buffersize);
void read_config_string(char* filename, char* section, char* key, char* returnbuffer, size_t buffersize, char* defvalue);
int read_config_int(char* filename, char* section, char* key, int defvalue);

#endif
