//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
//

using Glade;
using Gtk;
using Mono.Unix;
using System;

namespace Imendio.Blam {
    class About {
	[Widget] Gtk.Window about                 = null;
	[Widget] Gtk.Image  logoImage             = null;
	[Widget] Gtk.Label  authorsLabel          = null;
	[Widget] Gtk.Label  translatorsLabel      = null;
	[Widget] Gtk.Label  versionLabel          = null;
	[Widget] Gtk.VBox   translatorBox         = null;
	[Widget] Gtk.Label  translatorsNamesLabel = null;
	
	static About aboutBox;
	
	About (Gtk.Window parent)
	{
	    Glade.XML gladeXML = Glade.XML.FromAssembly("blam.glade",
							"about", null);
	    gladeXML.Autoconnect(this);
	    
	    about.TransientFor = parent;
	    logoImage.Pixbuf = Gdk.Pixbuf.LoadFromResource("blam-about.png");
	    about.Icon = Gdk.Pixbuf.LoadFromResource("blam.png");
	    versionLabel.Markup = "<b>" + versionLabel.Text + Defines.VERSION + "</b>";
	    authorsLabel.Markup = "<b>" + authorsLabel.Text + "</b>";
	    if (translatorsNamesLabel.Text.Equals ("translator-credits")) {
		translatorBox.Hide ();
	    } else {
		translatorsLabel.Markup = "<b>" + translatorsLabel.Text + "</b>";
	    }
	}
	
	public void OkClicked(object obj, EventArgs args)
	{
	    about.Hide();
	}
	
	public void OnDelete(object obj, DeleteEventArgs args)
	{
	    aboutBox = null;
	}
	
	static public void Show(Gtk.Window parent)
	{
	    if (aboutBox == null) {
		aboutBox = new About(parent);
	    }
	    aboutBox.about.Show();
	}
    }
    
    class AddChannelDialog {
    [Widget] Gtk.Dialog addChannelDialog = null;
    [Widget] Gtk.Entry  urlEntry         = null;
    [Widget] Gtk.Entry	usernameEntry	 = null;
    [Widget] Gtk.Entry	passwordEntry	 = null;
    [Widget] Gtk.Image  dialogImage      = null;
    [Widget] Gtk.Button okButton         = null;
	
	private Application mApp;
	
	public AddChannelDialog (Application app)
	{
	    mApp = app;
	    
	    Glade.XML gladeXML = Glade.XML.FromAssembly ("blam.glade",
							 "addChannelDialog",
							 null);
	    gladeXML.Autoconnect (this);
	    addChannelDialog.TransientFor = mApp.Window;
	    addChannelDialog.Icon = Gdk.Pixbuf.LoadFromResource ("blam.png");
	    
	    dialogImage.Pixbuf =
		Gdk.Pixbuf.LoadFromResource ("blam-add-news.png");
	}

	public void Show ()
	{
	    urlEntry.Text = ""; //otherwise it will keep adding it on to the end
	    urlEntry.PasteClipboard();
	    usernameEntry.Text = "";
	    passwordEntry.Text = "";
	 
	    addChannelDialog.ShowAll ();
	}

    public void Show (string url)
    {
        urlEntry.Text = url;
        usernameEntry.Text = "";
        passwordEntry.Text = "";
	    
        addChannelDialog.ShowAll ();
    }

	public void CancelButtonClicked (object obj, EventArgs args)
	{
	    addChannelDialog.Hide();
	}
	
	public void OkButtonClicked (object obj, EventArgs args)
	{
	    Channel channel = new Channel ();
		
	    channel.Url = urlEntry.Text;
	    channel.http_username = usernameEntry.Text;
	    channel.http_password = passwordEntry.Text;

	    mApp.CCollection.Add (channel);

	    addChannelDialog.Hide ();
	}

	public void EntryChanged (object obj, EventArgs args)
	{
	    if (!urlEntry.Text.Equals("")) {
		okButton.Sensitive = true;
	    } else {
		okButton.Sensitive = false;
	    }
	}
	
	public void EntryActivated (object obj, EventArgs args)
	{
	    if (!urlEntry.Text.Equals("")) {
		okButton.Click();
	    }
	}
    }
    
    class RemoveChannelDialog {
	[Widget] Gtk.Dialog removeChannelDialog = null;
	[Widget] Gtk.Label  dialogTextLabel     = null;

	private ChannelCollection mCollection;

	private static RemoveChannelDialog removeDialog = null;
	
	private RemoveChannelDialog(Gtk.Window parent,
				    ChannelCollection collection)
	{
	    mCollection = collection;
	    Glade.XML gladeXML = Glade.XML.FromAssembly("blam.glade",
							"removeChannelDialog",
							null);
	    gladeXML.Autoconnect(this);
	    removeChannelDialog.TransientFor = parent;

	    removeChannelDialog.Icon = Gdk.Pixbuf.LoadFromResource ("blam.png");
	}

	public static void Show (Gtk.Window parent, ChannelCollection collection, Channel channel)
	{
	    if (removeDialog == null) {
		removeDialog = new RemoveChannelDialog (parent, collection);
	    }

	    string name = "<b>" + channel.Name + "</b>";
	  
	    string str = String.Format (Catalog.GetString ("Do you want to remove the channel {0} from the channel list?"), name);

	    removeDialog.dialogTextLabel.Markup = str;
	    
	    int response = removeDialog.removeChannelDialog.Run ();
	    removeDialog.removeChannelDialog.Hide ();
	    
	    switch (response) {
	    case (int) ResponseType.Cancel:
		return;
	    case (int) ResponseType.Ok:
		removeDialog.mCollection.Remove (channel);
		return;
	    }
	}
    }
}

